/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.type;

import egovframework.rte.itl.integration.type.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractType
implements Type {
    private Log LOG = LogFactory.getLog(this.getClass());
    protected String id;
    protected String name;
    protected List<Class<?>> assignableClasses;

    protected AbstractType() {
    }

    protected AbstractType(String id, String name, Class<?>[] assignableClasses) {
        this(id, name, Arrays.asList(assignableClasses));
    }

    protected AbstractType(String id, String name, List<Class<?>> assignableClasses) {
        if (!StringUtils.hasText((String)id)) {
            this.LOG.error((Object)("id does not have a text (id = \"" + id + "\")"));
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)name)) {
            this.LOG.error((Object)("name does not have a text (name = \"" + name + "\")"));
            throw new IllegalArgumentException();
        }
        if (assignableClasses == null || assignableClasses.size() == 0) {
            this.LOG.error((Object)("assignableClasses is null or empty (assignableClasses = " + assignableClasses + ")"));
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.assignableClasses = assignableClasses;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (!StringUtils.hasText((String)id)) {
            this.LOG.error((Object)("id does not have a text (id = \"" + id + "\")"));
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtils.hasText((String)name)) {
            this.LOG.error((Object)("name does not have a text (name = \"" + name + "\")"));
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public List<Class<?>> getAssignableClasses() {
        return this.assignableClasses;
    }

    public void setAssignableClasses(List<Class<?>> assignableClasses) {
        if (assignableClasses == null || assignableClasses.size() == 0) {
            this.LOG.error((Object)("assignableClasses is null or empty (assignableClasses = " + assignableClasses + ")"));
            throw new IllegalArgumentException();
        }
        this.assignableClasses = assignableClasses;
    }

    @Override
    public boolean isAssignableFrom(Class<?> clazz) {
        if (clazz == null) {
            this.LOG.error((Object)"Argument 'clazz' is null");
            throw new IllegalArgumentException();
        }
        for (Class<?> assignableClass : this.assignableClasses) {
            if (!assignableClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return StringUtils.hasText((String)this.id) && StringUtils.hasText((String)this.name) && this.assignableClasses != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractType other = (AbstractType)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getClass().getName() + " {id = " + StringUtils.quote((String)this.id) + "}";
    }
}

