/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.filehandling;

import egovframework.rte.fdl.string.EgovStringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VFS;
import org.apache.regexp.RE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovFileUtil {
    private static final Log log = LogFactory.getLog(EgovFileUtil.class);
    private static FileObject basefile;
    private static FileSystemManager manager;

    static {
        try {
            manager = VFS.getManager();
            basefile = manager.resolveFile(System.getProperty("user.dir"));
        }
        catch (FileSystemException e) {
            log.error((Object)("EgovFileUtil : " + e.getMessage()));
        }
    }

    public static int rm(String cmd) throws FileSystemException {
        int result = -1;
        try {
            FileObject file = manager.resolveFile(basefile, cmd);
            result = file.delete(Selectors.SELECT_SELF_AND_CHILDREN);
            log.debug((Object)("result is " + result));
        }
        catch (FileSystemException e) {
            log.error((Object)e.toString());
            throw new FileSystemException((Throwable)e);
        }
        return result;
    }

    public static void cp(String source, String target) throws Exception {
        try {
            FileObject src = manager.resolveFile(basefile, source);
            FileObject dest = manager.resolveFile(basefile, target);
            if (dest.exists() && dest.getType() == FileType.FOLDER) {
                dest = dest.resolveFile(src.getName().getBaseName());
            }
            dest.copyFrom(src, Selectors.SELECT_ALL);
        }
        catch (FileSystemException fse) {
            log.error((Object)fse.toString());
            throw new FileSystemException((Throwable)fse);
        }
    }

    public static void mv(String source, String target) throws Exception {
        try {
            FileObject src = manager.resolveFile(basefile, source);
            FileObject dest = manager.resolveFile(basefile, target);
            if (dest.exists() && dest.getType() == FileType.FOLDER) {
                dest = dest.resolveFile(src.getName().getBaseName());
            }
            src.moveTo(dest);
        }
        catch (FileSystemException fse) {
            log.error((Object)fse.toString());
            throw new FileSystemException((Throwable)fse);
        }
    }

    public static FileName pwd() {
        return basefile.getName();
    }

    public static long touch(String filepath) throws Exception {
        long currentTime = 0L;
        FileObject file = manager.resolveFile(basefile, filepath);
        if (!file.exists()) {
            file.createFile();
        }
        currentTime = System.currentTimeMillis();
        file.getContent().setLastModifiedTime(currentTime);
        return currentTime;
    }

    public static void cd(String changDirectory) throws Exception {
        String path = !EgovStringUtil.isNull((String)changDirectory) ? changDirectory : System.getProperty("user.home");
        FileObject tmp = manager.resolveFile(basefile, path);
        if (tmp.exists()) {
            basefile = tmp;
        } else {
            log.info((Object)("Folder does not exist: " + tmp.getName()));
        }
        log.info((Object)("Current folder is " + basefile.getName()));
    }

    public List ls(String[] cmd) throws FileSystemException {
        boolean recursive;
        ArrayList list = new ArrayList();
        int pos = 1;
        if (cmd.length > pos && cmd[pos].equals("-R")) {
            recursive = true;
            ++pos;
        } else {
            recursive = false;
        }
        FileObject file = cmd.length > pos ? manager.resolveFile(basefile, cmd[pos]) : basefile;
        if (file.getType() == FileType.FOLDER) {
            log.info((Object)("Contents of " + file.getName()));
            log.info((Object)this.listChildren(file, recursive, ""));
        } else {
            log.info((Object)file.getName());
            FileContent content = file.getContent();
            log.info((Object)("Size: " + content.getSize() + " bytes."));
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            String lastMod = dateFormat.format(new Date(content.getLastModifiedTime()));
            log.info((Object)("Last modified: " + lastMod));
        }
        return list;
    }

    private StringBuffer listChildren(FileObject dir, boolean recursive, String prefix) throws FileSystemException {
        StringBuffer line = new StringBuffer();
        FileObject[] children = dir.getChildren();
        int i = 0;
        while (i < children.length) {
            FileObject child = children[i];
            line.append(prefix).append(child.getName().getBaseName());
            if (child.getType() == FileType.FOLDER) {
                line.append("/");
                if (recursive) {
                    line.append(this.listChildren(child, recursive, String.valueOf(prefix) + "    "));
                }
            } else {
                line.append("");
            }
            ++i;
        }
        return line;
    }

    public static String readFile(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        return EgovFileUtil.readFileContent(in);
    }

    public static String readFileContent(InputStream in) throws IOException {
        StringBuffer buf = new StringBuffer();
        int i = in.read();
        while (i != -1) {
            buf.append((char)i);
            i = in.read();
        }
        return buf.toString();
    }

    public static String readFile(File file, String encoding) throws IOException {
        StringBuffer sb = new StringBuffer();
        List lines = FileUtils.readLines((File)file, (String)encoding);
        Iterator it = lines.iterator();
        while (true) {
            sb.append((String)it.next());
            if (!it.hasNext()) break;
            sb.append("");
        }
        return sb.toString();
    }

    public static void writeFile(File file, String text) {
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new FileWriter(file);
                writer.write(text);
            }
            catch (Exception e) {
                log.error((Object)("Error creating File: " + file.getName() + ":" + e));
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeFile(String fileName, String text) {
        EgovFileUtil.writeFile(new File(fileName), text);
    }

    public static void writeFile(String fileName, String data, String encoding) throws IOException {
        FileUtils.writeStringToFile((File)new File(fileName), (String)data, (String)encoding);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getContent(FileObject file) throws IOException {
        FileContent content = file.getContent();
        int size = (int)content.getSize();
        byte[] buf = new byte[size];
        InputStream in = content.getInputStream();
        try {
            block6: {
                int pos;
                int read;
                block5: {
                    read = 0;
                    pos = 0;
                    if (!true) break block5;
                    if (pos >= size) return buf;
                    if (read < 0) break block6;
                }
                do {
                    read = in.read(buf, pos, size - pos);
                    pos += read;
                    if (pos >= size) return buf;
                } while (read >= 0);
            }
            return buf;
        }
        finally {
            in.close();
        }
    }

    public static void writeContent(FileObject file, OutputStream outstr) throws IOException {
        InputStream instr = file.getContent().getInputStream();
        try {
            int nread;
            byte[] buffer = new byte[1024];
            while ((nread = instr.read(buffer)) >= 0) {
                outstr.write(buffer, 0, nread);
            }
        }
        finally {
            instr.close();
        }
    }

    public static void copyContent(FileObject srcFile, FileObject destFile) throws IOException {
        OutputStream outstr = destFile.getContent().getOutputStream();
        try {
            EgovFileUtil.writeContent(srcFile, outstr);
        }
        finally {
            outstr.close();
        }
    }

    public static String getFileExtension(String filename) {
        return FilenameUtils.getExtension((String)filename);
    }

    public static boolean isExistsFile(String filename) {
        File file = new File(filename);
        return file.exists();
    }

    public static String stripFilename(String filename) {
        return FilenameUtils.getBaseName((String)filename);
    }

    public static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                EgovFileUtil.delete(children[i]);
                ++i;
            }
        }
        if (!file.delete()) {
            throw new IOException("Unable to delete " + file.getPath());
        }
    }

    public static StringBuffer readTextFile(String fileName, boolean newline) throws FileNotFoundException, IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        StringBuffer buf = new StringBuffer();
        BufferedReader in = null;
        try {
            String str;
            in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                buf.append(str);
                if (!newline) continue;
                buf.append(System.getProperty("line.separator"));
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buf;
    }

    public static FileObject getFileObject(String filepath) throws Exception {
        FileSystemManager mgr = VFS.getManager();
        return mgr.resolveFile(mgr.resolveFile(System.getProperty("user.dir")), filepath);
    }

    public static List<String> grep(Object[] search, String pattern) throws Exception {
        RE searchPattern = new RE(pattern);
        String[] strings = searchPattern.grep(search);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < strings.length) {
            list.add(strings[i]);
            ++i;
        }
        return list;
    }

    public static List<String> grep(File file, String pattern) throws Exception {
        RE searchPattern = new RE(pattern);
        List lists = FileUtils.readLines((File)file);
        Object[] search = lists.toArray();
        String[] strings = searchPattern.grep(search);
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < strings.length) {
            list.add(strings[i]);
            ++i;
        }
        return list;
    }
}

