/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.job;

import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.UnexpectedJobExecutionException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.core.step.job.DefaultJobParametersExtractor;
import org.springframework.batch.core.step.job.JobParametersExtractor;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.util.Assert;

public class JobStep
extends AbstractStep {
    private static final String JOB_PARAMETERS_KEY = JobStep.class.getName() + ".JOB_PARAMETERS";
    private Job job;
    private JobLauncher jobLauncher;
    private JobParametersExtractor jobParametersExtractor = new DefaultJobParametersExtractor();

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state((this.jobLauncher != null ? 1 : 0) != 0, (String)"A JobLauncher must be provided");
        Assert.state((this.job != null ? 1 : 0) != 0, (String)"A Job must be provided");
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public void setJobParametersExtractor(JobParametersExtractor jobParametersExtractor) {
        this.jobParametersExtractor = jobParametersExtractor;
    }

    protected void doExecute(StepExecution stepExecution) throws Exception {
        JobParameters jobParameters;
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        if (executionContext.containsKey(JOB_PARAMETERS_KEY)) {
            jobParameters = (JobParameters)executionContext.get(JOB_PARAMETERS_KEY);
        } else {
            jobParameters = this.jobParametersExtractor.getJobParameters(this.job, stepExecution);
            executionContext.put(JOB_PARAMETERS_KEY, (Object)jobParameters);
        }
        JobExecution jobExecution = this.jobLauncher.run(this.job, jobParameters);
        if (jobExecution.getStatus().isUnsuccessful()) {
            throw new UnexpectedJobExecutionException("Step failure: the delegate Job failed in JobStep.");
        }
    }
}

