/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.file.transform;

import egovframework.rte.bat.core.reflection.EgovReflectionSupport;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovFieldExtractor<T>
implements FieldExtractor<T>,
InitializingBean {
    private static final Log logger = LogFactory.getLog(EgovFieldExtractor.class);
    private String[] names;
    private EgovReflectionSupport<T> reflection;

    public void setNames(String[] names) {
        Assert.notNull((Object)names, (String)"Names must be non-null");
        this.names = Arrays.asList(names).toArray(new String[names.length]);
    }

    public Object[] extract(T item) {
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            this.reflection.generateGetterMethodMap(this.names, item);
        }
        catch (Exception e) {
            logger.debug((Object)e);
        }
        for (int i = 0; i < this.names.length; ++i) {
            values.add(this.reflection.invokeGettterMethod(item, this.names[i]));
        }
        return values.toArray();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.names, (String)"The 'names' property must be set.");
        this.reflection = new EgovReflectionSupport();
    }
}

