/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.file.transform;

import egovframework.rte.bat.core.item.file.transform.EgovAbstractLineTokenizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.file.transform.IncorrectLineLengthException;
import org.springframework.batch.item.file.transform.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovFixedLengthTokenizer
extends EgovAbstractLineTokenizer {
    private Range[] ranges;
    private int maxRange = 0;
    boolean open = false;

    public void setColumns(Range[] ranges) {
        this.ranges = Arrays.asList(ranges).toArray(new Range[ranges.length]);
        this.calculateMaxRange(ranges);
    }

    private void calculateMaxRange(Range[] ranges) {
        if (ranges == null || ranges.length == 0) {
            this.maxRange = 0;
            return;
        }
        this.open = false;
        this.maxRange = ranges[0].getMin();
        for (int i = 0; i < ranges.length; ++i) {
            int upperBound;
            if (ranges[i].hasMaxValue()) {
                upperBound = ranges[i].getMax();
            } else {
                upperBound = ranges[i].getMin();
                if (upperBound > this.maxRange) {
                    this.open = true;
                }
            }
            if (upperBound <= this.maxRange) continue;
            this.maxRange = upperBound;
        }
    }

    @Override
    protected List<String> doTokenize(String line) {
        ArrayList<String> tokens = new ArrayList<String>(this.ranges.length);
        int lineLength = line.length();
        if (lineLength == 0) {
            throw new IncorrectLineLengthException("Line length must be longer than 0", this.maxRange, lineLength);
        }
        if (lineLength < this.maxRange) {
            throw new IncorrectLineLengthException("Line is shorter than max range " + this.maxRange, this.maxRange, lineLength);
        }
        if (!this.open && lineLength > this.maxRange) {
            throw new IncorrectLineLengthException("Line is longer than max range " + this.maxRange, this.maxRange, lineLength);
        }
        for (int i = 0; i < this.ranges.length; ++i) {
            int startPos = this.ranges[i].getMin() - 1;
            int endPos = this.ranges[i].getMax();
            String token = lineLength >= endPos ? line.substring(startPos, endPos) : (lineLength >= startPos ? line.substring(startPos) : "");
            tokens.add(token);
        }
        return tokens;
    }
}

