/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.ULogger;
import org.apache.log4j.db.ConnectionSource;
import org.apache.log4j.plugins.Pauseable;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.scheduler.Job;
import org.apache.log4j.scheduler.Scheduler;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

public class CustomSQLDBReceiver
extends Receiver
implements Pauseable {
    protected volatile Connection connection = null;
    protected String sqlStatement = "";
    static int DEFAULT_REFRESH_MILLIS = 1000;
    int refreshMillis = DEFAULT_REFRESH_MILLIS;
    protected String idField = null;
    int lastID = -1;
    private static final String WHERE_CLAUSE = " WHERE ";
    private static final String AND_CLAUSE = " AND ";
    private boolean whereExists = false;
    private boolean paused = false;
    private ConnectionSource connectionSource;
    public static final String LOG4J_ID_KEY = "log4jid";
    private Thread receiverThread;
    private Job customReceiverJob;

    public void activateOptions() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("CustomSQLDBReceiver cannot function without a connection source");
        }
        this.whereExists = this.sqlStatement.toUpperCase().indexOf(WHERE_CLAUSE) > -1;
        this.customReceiverJob = new CustomReceiverJob();
        if (this.repository == null) {
            throw new IllegalStateException("CustomSQLDBReceiver cannot function without a reference to its owning repository");
        }
        if (this.repository instanceof LoggerRepositoryEx) {
            Scheduler scheduler = ((LoggerRepositoryEx)this.repository).getScheduler();
            scheduler.schedule(this.customReceiverJob, System.currentTimeMillis() + 500L, this.refreshMillis);
        }
    }

    void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public void setRefreshMillis(int refreshMillis) {
        this.refreshMillis = refreshMillis;
    }

    public int getRefreshMillis() {
        return this.refreshMillis;
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    public void close() {
        try {
            block4: {
                try {
                    if (this.connection == null || this.connection.isClosed()) break block4;
                    this.connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Object var3_2 = null;
                    this.connection = null;
                }
            }
            Object var3_1 = null;
            this.connection = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.connection = null;
            throw throwable;
        }
    }

    public void finalize() {
        this.close();
    }

    public void shutdown() {
        this.getLogger().info("removing receiverJob from the Scheduler.");
        if (this.repository instanceof LoggerRepositoryEx) {
            Scheduler scheduler = ((LoggerRepositoryEx)this.repository).getScheduler();
            scheduler.delete(this.customReceiverJob);
        }
        this.lastID = -1;
    }

    public void setSql(String s) {
        this.sqlStatement = s;
    }

    public String getSql() {
        return this.sqlStatement;
    }

    public void setIDField(String id) {
        this.idField = id;
    }

    public String getIDField() {
        return this.idField;
    }

    public synchronized void setPaused(boolean p) {
        this.paused = p;
    }

    public synchronized boolean isPaused() {
        return this.paused;
    }

    static /* synthetic */ ULogger access$201(CustomSQLDBReceiver x0) {
        return x0.getLogger();
    }

    static /* synthetic */ ULogger access$301(CustomSQLDBReceiver x0) {
        return x0.getLogger();
    }

    class CustomReceiverJob
    implements Job {
        CustomReceiverJob() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute() {
            block29: {
                Connection connection = null;
                int oldLastID = CustomSQLDBReceiver.this.lastID;
                try {
                    Object var28_30;
                    try {
                        connection = CustomSQLDBReceiver.this.connectionSource.getConnection();
                        Statement statement = connection.createStatement();
                        Logger eventLogger = null;
                        long timeStamp = 0L;
                        String level = null;
                        String threadName = null;
                        String message = null;
                        String ndc = null;
                        Hashtable<String, String> mdc = null;
                        String[] exception = null;
                        String className = null;
                        String methodName = null;
                        String fileName = null;
                        String lineNumber = null;
                        Hashtable<String, String> properties = null;
                        String currentSQLStatement = CustomSQLDBReceiver.this.sqlStatement;
                        currentSQLStatement = CustomSQLDBReceiver.this.whereExists ? CustomSQLDBReceiver.this.sqlStatement + CustomSQLDBReceiver.AND_CLAUSE + CustomSQLDBReceiver.this.idField + " > " + CustomSQLDBReceiver.this.lastID : CustomSQLDBReceiver.this.sqlStatement + CustomSQLDBReceiver.WHERE_CLAUSE + CustomSQLDBReceiver.this.idField + " > " + CustomSQLDBReceiver.this.lastID;
                        ResultSet rs = statement.executeQuery(currentSQLStatement);
                        int i = 0;
                        while (true) {
                            if (!rs.next()) {
                                if (CustomSQLDBReceiver.this.lastID != oldLastID) {
                                    ComponentBase.access$201((CustomSQLDBReceiver)CustomSQLDBReceiver.this).debug("lastID: " + CustomSQLDBReceiver.this.lastID);
                                    oldLastID = CustomSQLDBReceiver.this.lastID;
                                }
                                statement.close();
                                statement = null;
                                break;
                            }
                            if (++i == 1000) {
                                CustomReceiverJob customReceiverJob = this;
                                synchronized (customReceiverJob) {
                                    try {
                                        this.wait(300L);
                                    }
                                    catch (InterruptedException ie) {
                                        // empty catch block
                                    }
                                    i = 0;
                                }
                            }
                            eventLogger = Logger.getLogger(rs.getString("LOGGER"));
                            timeStamp = rs.getTimestamp("TIMESTAMP").getTime();
                            level = rs.getString("LEVEL");
                            threadName = rs.getString("THREAD");
                            message = rs.getString("MESSAGE");
                            ndc = rs.getString("NDC");
                            String mdcString = rs.getString("MDC");
                            mdc = new Hashtable<String, String>();
                            if (mdcString != null) {
                                if (mdcString.indexOf("{{") > -1 && mdcString.indexOf("}}") > -1) {
                                    mdcString = mdcString.substring(mdcString.indexOf("{{") + 2, mdcString.indexOf("}}"));
                                }
                                StringTokenizer tok = new StringTokenizer(mdcString, ",");
                                while (tok.countTokens() > 1) {
                                    mdc.put(tok.nextToken(), tok.nextToken());
                                }
                            }
                            exception = new String[]{rs.getString("EXCEPTION")};
                            className = rs.getString("CLASS");
                            methodName = rs.getString("METHOD");
                            fileName = rs.getString("FILE");
                            lineNumber = rs.getString("LINE");
                            String propertiesString = rs.getString("PROPERTIES");
                            properties = new Hashtable<String, String>();
                            if (propertiesString != null) {
                                if (propertiesString.indexOf("{{") > -1 && propertiesString.indexOf("}}") > -1) {
                                    propertiesString = propertiesString.substring(propertiesString.indexOf("{{") + 2, propertiesString.indexOf("}}"));
                                }
                                StringTokenizer tok2 = new StringTokenizer(propertiesString, ",");
                                while (tok2.countTokens() > 1) {
                                    String name = tok2.nextToken();
                                    String value = tok2.nextToken();
                                    if (name.equals(CustomSQLDBReceiver.LOG4J_ID_KEY)) {
                                        try {
                                            int thisInt = Integer.parseInt(value);
                                            value = String.valueOf(thisInt);
                                            if (thisInt > CustomSQLDBReceiver.this.lastID) {
                                                CustomSQLDBReceiver.this.lastID = thisInt;
                                            }
                                        }
                                        catch (Exception e) {
                                            // empty catch block
                                        }
                                    }
                                    properties.put(name, value);
                                }
                            }
                            Level levelImpl = Level.toLevel(level);
                            LoggingEvent event = new LoggingEvent(eventLogger.getName(), eventLogger, levelImpl, message, null);
                            event.setLocationInformation(new LocationInfo(fileName, className, methodName, lineNumber));
                            properties.putAll(mdc);
                            event.setTimeStamp(timeStamp);
                            event.setThrowableInformation(new ThrowableInformation(exception));
                            event.setProperties(properties);
                            event.setThreadName(threadName);
                            event.setNDC(ndc);
                            CustomSQLDBReceiver.this.doPost(event);
                        }
                    }
                    catch (SQLException sqle) {
                        ComponentBase.access$301((CustomSQLDBReceiver)CustomSQLDBReceiver.this).error((Object)"*************Problem receiving events", sqle);
                        var28_30 = null;
                        CustomSQLDBReceiver.this.closeConnection(connection);
                        break block29;
                    }
                    var28_30 = null;
                    CustomSQLDBReceiver.this.closeConnection(connection);
                }
                catch (Throwable throwable) {
                    Object var28_31 = null;
                    CustomSQLDBReceiver.this.closeConnection(connection);
                    throw throwable;
                }
            }
            CustomReceiverJob customReceiverJob = this;
            synchronized (customReceiverJob) {
                while (CustomSQLDBReceiver.this.isPaused()) {
                    try {
                        this.wait(1000L);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                        continue;
                    }
                    break;
                }
                return;
            }
        }
    }
}

