/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.ProgressMonitorInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.helpers.UtilLoggingLevel;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.xml.SAXErrorHandler;
import org.apache.log4j.xml.UtilLoggingEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UtilLoggingXMLDecoder
implements Decoder {
    private static final String BEGIN_PART = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><!DOCTYPE log SYSTEM \"logger.dtd\"><log>";
    private static final String END_PART = "</log>";
    private DocumentBuilderFactory dbf;
    private DocumentBuilder docBuilder;
    private Map additionalProperties = new HashMap();
    private String partialEvent;
    private static final String RECORD_END = "</record>";
    private Component owner = null;

    public UtilLoggingXMLDecoder(Component owner) {
        this();
        this.owner = owner;
    }

    public UtilLoggingXMLDecoder() {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setValidating(false);
        try {
            this.docBuilder = this.dbf.newDocumentBuilder();
            this.docBuilder.setErrorHandler(new SAXErrorHandler());
            this.docBuilder.setEntityResolver(new UtilLoggingEntityResolver());
        }
        catch (ParserConfigurationException pce) {
            System.err.println("Unable to get document builder");
        }
    }

    public void setAdditionalProperties(Map additionalProperties) {
        this.additionalProperties.putAll(additionalProperties);
    }

    private Document parse(String data) {
        if (this.docBuilder == null || data == null) {
            return null;
        }
        Document document = null;
        try {
            StringBuffer buf = new StringBuffer(1024);
            if (!data.startsWith("<?xml")) {
                buf.append(BEGIN_PART);
            }
            buf.append(data);
            if (!data.endsWith(END_PART)) {
                buf.append(END_PART);
            }
            InputSource inputSource = new InputSource(new StringReader(buf.toString()));
            inputSource.setSystemId("dummy://logger.dtd");
            document = this.docBuilder.parse(inputSource);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    public Vector decode(URL url) throws IOException {
        LineNumberReader reader = null;
        reader = this.owner != null ? new LineNumberReader(new InputStreamReader(new ProgressMonitorInputStream(this.owner, "Loading " + url, url.openStream()))) : new LineNumberReader(new InputStreamReader(url.openStream()));
        Vector v = new Vector();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                StringBuffer buffer = new StringBuffer(line);
                int i = 0;
                while (i < 100) {
                    buffer.append(reader.readLine());
                    ++i;
                }
                v.addAll(this.decodeEvents(buffer.toString()));
            }
            Object var8_7 = null;
            this.partialEvent = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.partialEvent = null;
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return v;
    }

    public Vector decodeEvents(String document) {
        if (document != null) {
            if (document.equals("")) {
                return null;
            }
            String newDoc = null;
            String newPartialEvent = null;
            if (document.lastIndexOf(RECORD_END) == -1) {
                this.partialEvent = this.partialEvent + document;
                return null;
            }
            if (document.lastIndexOf(RECORD_END) + RECORD_END.length() < document.length()) {
                newDoc = document.substring(0, document.lastIndexOf(RECORD_END) + RECORD_END.length());
                newPartialEvent = document.substring(document.lastIndexOf(RECORD_END) + RECORD_END.length());
            } else {
                newDoc = document;
            }
            if (this.partialEvent != null) {
                newDoc = this.partialEvent + newDoc;
            }
            this.partialEvent = newPartialEvent;
            Document doc = this.parse(newDoc);
            if (doc == null) {
                return null;
            }
            return this.decodeEvents(doc);
        }
        return null;
    }

    public LoggingEvent decode(String data) {
        Document document = this.parse(data);
        if (document == null) {
            return null;
        }
        Vector events = this.decodeEvents(document);
        if (events.size() > 0) {
            return (LoggingEvent)events.firstElement();
        }
        return null;
    }

    private Vector decodeEvents(Document document) {
        Vector<LoggingEvent> events = new Vector<LoggingEvent>();
        NodeList eventList = document.getElementsByTagName("record");
        int eventIndex = 0;
        while (eventIndex < eventList.getLength()) {
            Node eventNode = eventList.item(eventIndex);
            Logger logger = null;
            long timeStamp = 0L;
            Level level = null;
            String threadName = null;
            String message = null;
            Object ndc = null;
            String[] exception = null;
            String className = null;
            String methodName = null;
            Object fileName = null;
            Object lineNumber = null;
            Hashtable<String, String> properties = new Hashtable<String, String>();
            NodeList list = eventNode.getChildNodes();
            int listLength = list.getLength();
            if (listLength != 0) {
                int y = 0;
                while (y < listLength) {
                    String tagName = list.item(y).getNodeName();
                    if (tagName.equalsIgnoreCase("logger")) {
                        logger = Logger.getLogger(this.getCData(list.item(y)));
                    }
                    if (tagName.equalsIgnoreCase("millis")) {
                        timeStamp = Long.parseLong(this.getCData(list.item(y)));
                    }
                    if (tagName.equalsIgnoreCase("level")) {
                        level = UtilLoggingLevel.toLevel(this.getCData(list.item(y)));
                    }
                    if (tagName.equalsIgnoreCase("thread")) {
                        threadName = this.getCData(list.item(y));
                    }
                    if (tagName.equalsIgnoreCase("sequence")) {
                        properties.put("log4jid", this.getCData(list.item(y)));
                    }
                    if (tagName.equalsIgnoreCase("message")) {
                        message = this.getCData(list.item(y));
                    }
                    if (tagName.equalsIgnoreCase("class")) {
                        className = this.getCData(list.item(y));
                    }
                    if (tagName.equalsIgnoreCase("method")) {
                        methodName = this.getCData(list.item(y));
                    }
                    if (tagName.equalsIgnoreCase("exception")) {
                        ArrayList<String> exceptionList = new ArrayList<String>();
                        NodeList exList = list.item(y).getChildNodes();
                        int exlistLength = exList.getLength();
                        int i2 = 0;
                        while (i2 < exlistLength) {
                            Node exNode = exList.item(i2);
                            String exName = exList.item(i2).getNodeName();
                            if (exName.equalsIgnoreCase("message")) {
                                exceptionList.add(this.getCData(exList.item(i2)));
                            }
                            if (exName.equalsIgnoreCase("frame")) {
                                NodeList exList2 = exNode.getChildNodes();
                                int exlist2Length = exList2.getLength();
                                int i3 = 0;
                                while (i3 < exlist2Length) {
                                    exceptionList.add(this.getCData(exList2.item(i3)) + "\n");
                                    ++i3;
                                }
                            }
                            ++i2;
                        }
                        exception = exceptionList.toArray(new String[exceptionList.size()]);
                    }
                    ++y;
                }
                if (this.additionalProperties.size() > 0) {
                    if (properties == null) {
                        properties = new Hashtable(this.additionalProperties);
                    } else {
                        Iterator i = this.additionalProperties.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry e = i.next();
                            if (properties.containsKey(e.getKey())) continue;
                            properties.put((String)e.getKey(), (String)e.getValue());
                        }
                    }
                }
                LocationInfo info = null;
                info = fileName != null || className != null || methodName != null || lineNumber != null ? new LocationInfo(fileName, className, methodName, lineNumber) : LocationInfo.NA_LOCATION_INFO;
                if (exception == null) {
                    exception = new String[]{""};
                }
                LoggingEvent loggingEvent = new LoggingEvent();
                loggingEvent.setLogger(logger);
                loggingEvent.setTimeStamp(timeStamp);
                loggingEvent.setLevel(level);
                loggingEvent.setThreadName(threadName);
                loggingEvent.setMessage(message);
                loggingEvent.setNDC(ndc);
                loggingEvent.setThrowableInformation(new ThrowableInformation(exception));
                loggingEvent.setLocationInformation(info);
                loggingEvent.setProperties(properties);
                events.add(loggingEvent);
                logger = null;
                timeStamp = 0L;
                level = null;
                threadName = null;
                message = null;
                ndc = null;
                exception = null;
                className = null;
                methodName = null;
                fileName = null;
                lineNumber = null;
                properties = null;
            }
            ++eventIndex;
        }
        return events;
    }

    private String getCData(Node n) {
        StringBuffer buf = new StringBuffer();
        NodeList nl = n.getChildNodes();
        int x = 0;
        while (x < nl.getLength()) {
            Node innerNode = nl.item(x);
            if (innerNode.getNodeType() == 3 || innerNode.getNodeType() == 4) {
                buf.append(innerNode.getNodeValue());
            }
            ++x;
        }
        return buf.toString();
    }
}

