/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.engine.ActionExecutionException;
import org.springframework.webflow.engine.AnnotatedAction;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ActionExecutor {
    private static final Log logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.engine.ActionExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    private ActionExecutor() {
    }

    public static Event execute(Action action, RequestContext context) throws ActionExecutionException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing " + ActionExecutor.getTargetAction(action)));
            }
            Event event = action.execute(context);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Finished executing " + ActionExecutor.getTargetAction(action) + "; result = " + event));
            }
            return event;
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActionExecutionException(context.getActiveFlow().getId(), context.getCurrentState() != null ? context.getCurrentState().getId() : null, action, context.getAttributes(), e);
        }
    }

    private static Action getTargetAction(Action action) {
        if (action instanceof AnnotatedAction) {
            return ActionExecutor.getTargetAction(((AnnotatedAction)action).getTargetAction());
        }
        return action;
    }
}

