/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import java.util.ListIterator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.engine.impl.FlowExecutionImplServicesConfigurer;
import org.springframework.webflow.engine.impl.FlowSessionImpl;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionKeyFactory;
import org.springframework.webflow.execution.repository.support.FlowExecutionStateRestorer;

public class FlowExecutionImplStateRestorer
extends FlowExecutionImplServicesConfigurer
implements FlowExecutionStateRestorer {
    private FlowDefinitionLocator definitionLocator;

    public FlowExecutionImplStateRestorer(FlowDefinitionLocator definitionLocator) {
        Assert.notNull((Object)definitionLocator, (String)"The flow definition locator is required");
        this.definitionLocator = definitionLocator;
    }

    public FlowExecution restoreState(FlowExecution flowExecution, FlowExecutionKey key, MutableAttributeMap conversationScope, FlowExecutionKeyFactory keyFactory) {
        FlowExecutionImpl execution = (FlowExecutionImpl)flowExecution;
        if (execution.getFlowId() == null) {
            throw new IllegalStateException("Cannot restore flow execution impl: the flow id is null");
        }
        if (execution.getFlowSessions() == null) {
            throw new IllegalStateException("Cannot restore flow execution impl: the flowSessions list is null");
        }
        Flow flow = (Flow)this.definitionLocator.getFlowDefinition(execution.getFlowId());
        execution.setFlow(flow);
        if (execution.hasSessions()) {
            FlowSessionImpl rootSession = execution.getRootSession();
            rootSession.setFlow(flow);
            rootSession.setState(flow.getStateInstance(rootSession.getStateId()));
            if (execution.hasSubflowSessions()) {
                ListIterator it = execution.getSubflowSessionIterator();
                while (it.hasNext()) {
                    FlowSessionImpl subflowSession = (FlowSessionImpl)it.next();
                    Flow definition = (Flow)this.definitionLocator.getFlowDefinition(subflowSession.getFlowId());
                    subflowSession.setFlow(definition);
                    subflowSession.setState(definition.getStateInstance(subflowSession.getStateId()));
                }
            }
        }
        execution.setKey(key);
        if (conversationScope == null) {
            conversationScope = new LocalAttributeMap();
        }
        execution.setConversationScope(conversationScope);
        this.configureServices(execution);
        execution.setKeyFactory(keyFactory);
        return execution;
    }
}

