/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractTransitionableStateModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;

public class ActionStateModel
extends AbstractTransitionableStateModel {
    private LinkedList actions;

    public ActionStateModel(String id) {
        this.setId(id);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof ActionStateModel)) {
            return false;
        }
        ActionStateModel state = (ActionStateModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)state.getId());
    }

    public void merge(Model model) {
        ActionStateModel state = (ActionStateModel)model;
        this.setParent(null);
        this.setAttributes(this.merge(this.getAttributes(), state.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), state.getSecured()));
        this.setOnEntryActions(this.merge(this.getOnEntryActions(), state.getOnEntryActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), state.getExceptionHandlers()));
        this.setTransitions(this.merge(this.getTransitions(), state.getTransitions()));
        this.setOnExitActions(this.merge(this.getOnExitActions(), state.getOnExitActions(), false));
        this.setActions(this.merge(this.getActions(), state.getActions(), false));
    }

    public LinkedList getActions() {
        return this.actions;
    }

    public void setActions(LinkedList actions) {
        this.actions = actions;
    }

    public void addAction(AbstractActionModel action) {
        if (action == null) {
            return;
        }
        if (this.actions == null) {
            this.actions = new LinkedList();
        }
        this.actions.add(action);
    }

    public void addAction(LinkedList actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        if (this.actions == null) {
            this.actions = new LinkedList();
        }
        this.actions.addAll(actions);
    }
}

