/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.Model;

public class AttributeModel
extends AbstractModel {
    private String name;
    private String type;
    private String value;

    public AttributeModel(String name, String value) {
        this.setName(name);
        this.setValue(value);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof AttributeModel)) {
            return false;
        }
        AttributeModel attribute = (AttributeModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getName(), (Object)attribute.getName());
    }

    public void merge(Model model) {
        AttributeModel attribute = (AttributeModel)model;
        this.setValue(this.merge(this.getValue(), attribute.getValue()));
        this.setType(this.merge(this.getType(), attribute.getType()));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringUtils.hasText((String)name) ? name : null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = StringUtils.hasText((String)type) ? type : null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = StringUtils.hasText((String)value) ? value : null;
    }
}

