/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractTransitionableStateModel;
import org.springframework.webflow.engine.model.InputModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.OutputModel;
import org.springframework.webflow.engine.model.SecuredModel;

public class SubflowStateModel
extends AbstractTransitionableStateModel {
    private String subflow;
    private String subflowAttributeMapper;
    private LinkedList inputs;
    private LinkedList outputs;

    public SubflowStateModel(String id, String subflow) {
        this.setId(id);
        this.setSubflow(subflow);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof SubflowStateModel)) {
            return false;
        }
        SubflowStateModel state = (SubflowStateModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)state.getId());
    }

    public void merge(Model model) {
        SubflowStateModel state = (SubflowStateModel)model;
        this.setParent(null);
        this.setAttributes(this.merge(this.getAttributes(), state.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), state.getSecured()));
        this.setOnEntryActions(this.merge(this.getOnEntryActions(), state.getOnEntryActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), state.getExceptionHandlers()));
        this.setTransitions(this.merge(this.getTransitions(), state.getTransitions()));
        this.setOnExitActions(this.merge(this.getOnExitActions(), state.getOnExitActions(), false));
        this.setSubflow(this.merge(this.getSubflow(), state.getSubflow()));
        this.setSubflowAttributeMapper(this.merge(this.getSubflowAttributeMapper(), state.getSubflowAttributeMapper()));
        this.setInputs(this.merge(this.getInputs(), state.getInputs()));
        this.setOutputs(this.merge(this.getOutputs(), state.getOutputs()));
    }

    public String getSubflow() {
        return this.subflow;
    }

    public void setSubflow(String subflow) {
        this.subflow = StringUtils.hasText((String)subflow) ? subflow : null;
    }

    public String getSubflowAttributeMapper() {
        return this.subflowAttributeMapper;
    }

    public void setSubflowAttributeMapper(String subflowAttributeMapper) {
        this.subflowAttributeMapper = StringUtils.hasText((String)subflowAttributeMapper) ? subflowAttributeMapper : null;
    }

    public LinkedList getInputs() {
        return this.inputs;
    }

    public void setInputs(LinkedList inputs) {
        this.inputs = inputs;
    }

    public void addInput(InputModel input) {
        if (input == null) {
            return;
        }
        if (this.inputs == null) {
            this.inputs = new LinkedList();
        }
        this.inputs.add(input);
    }

    public void addInputs(LinkedList inputs) {
        if (inputs == null || inputs.isEmpty()) {
            return;
        }
        if (this.inputs == null) {
            this.inputs = new LinkedList();
        }
        this.inputs.addAll(inputs);
    }

    public LinkedList getOutputs() {
        return this.outputs;
    }

    public void setOutputs(LinkedList outputs) {
        this.outputs = outputs;
    }

    public void addOutput(OutputModel output) {
        if (output == null) {
            return;
        }
        if (this.outputs == null) {
            this.outputs = new LinkedList();
        }
        this.outputs.add(output);
    }

    public void addOutputs(LinkedList outputs) {
        if (outputs == null || outputs.isEmpty()) {
            return;
        }
        if (this.outputs == null) {
            this.outputs = new LinkedList();
        }
        this.outputs.addAll(outputs);
    }
}

