/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.AttributeModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;

public class TransitionModel
extends AbstractModel {
    private String on;
    private String onException;
    private String to;
    private String bind;
    private String history;
    private LinkedList attributes;
    private SecuredModel secured;
    private LinkedList actions;

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof TransitionModel)) {
            return false;
        }
        TransitionModel transition = (TransitionModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getOn(), (Object)transition.getOn());
    }

    public void merge(Model model) {
        TransitionModel transition = (TransitionModel)model;
        this.setOnException(this.merge(this.getOnException(), transition.getOnException()));
        this.setTo(this.merge(this.getTo(), transition.getTo()));
        this.setBind(this.merge(this.getBind(), transition.getBind()));
        this.setHistory(this.merge(this.getHistory(), transition.getHistory()));
        this.setAttributes(this.merge(this.getAttributes(), transition.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), transition.getSecured()));
        this.setActions(this.merge(this.getActions(), transition.getActions(), false));
    }

    public String getOn() {
        return this.on;
    }

    public void setOn(String on) {
        this.on = StringUtils.hasText((String)on) ? on : null;
    }

    public String getOnException() {
        return this.onException;
    }

    public void setOnException(String onException) {
        this.onException = StringUtils.hasText((String)onException) ? onException : null;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = StringUtils.hasText((String)to) ? to : null;
    }

    public String getBind() {
        return this.bind;
    }

    public void setBind(String bind) {
        this.bind = StringUtils.hasText((String)bind) ? bind : null;
    }

    public String getHistory() {
        return this.history;
    }

    public void setHistory(String history) {
        this.history = StringUtils.hasText((String)history) ? history : null;
    }

    public LinkedList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedList attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(AttributeModel attribute) {
        if (attribute == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.add(attribute);
    }

    public void addAttributes(LinkedList attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.addAll(attributes);
    }

    public SecuredModel getSecured() {
        return this.secured;
    }

    public void setSecured(SecuredModel secured) {
        this.secured = secured;
    }

    public LinkedList getActions() {
        return this.actions;
    }

    public void setActions(LinkedList actions) {
        this.actions = actions;
    }

    public void addAction(AbstractActionModel action) {
        if (action == null) {
            return;
        }
        if (this.actions == null) {
            this.actions = new LinkedList();
        }
        this.actions.add(action);
    }

    public void addActions(LinkedList actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        if (this.actions == null) {
            this.actions = new LinkedList();
        }
        this.actions.addAll(actions);
    }
}

