/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression;

import java.util.Map;
import ognl.ObjectPropertyAccessor;
import ognl.Ognl;
import ognl.OgnlException;
import ognl.PropertyAccessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.StaticListableBeanFactory;
import org.springframework.binding.collection.MapAdaptable;
import org.springframework.binding.expression.ognl.OgnlExpressionParser;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.AnnotatedAction;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class WebFlowOgnlExpressionParser
extends OgnlExpressionParser {
    private static final Log logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.expression.WebFlowOgnlExpressionParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public WebFlowOgnlExpressionParser() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.springframework.binding.collection.MapAdaptable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addPropertyAccessor(clazz, new MapAdaptablePropertyAccessor(null, null));
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.springframework.webflow.core.collection.MutableAttributeMap");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addPropertyAccessor(clazz2, new MutableAttributeMapPropertyAccessor());
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.springframework.context.MessageSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addPropertyAccessor(clazz3, new MessageSourcePropertyAccessor());
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("org.springframework.webflow.execution.RequestContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addPropertyAccessor(clazz4, new RequestContextPropertyAccessor((PropertyAccessor)new ObjectPropertyAccessor()));
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("org.springframework.webflow.execution.Action");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addPropertyAccessor(clazz5, new ActionPropertyAccessor());
        Class<?> clazz6 = class$6;
        if (clazz6 == null) {
            try {
                clazz6 = class$6 = Class.forName("org.springframework.webflow.execution.Event");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.addPropertyAccessor(clazz6, new EventPropertyAccessor());
    }

    private static class ActionPropertyAccessor
    implements PropertyAccessor {
        private ActionPropertyAccessor() {
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            Action action = (Action)target;
            AnnotatedAction annotated = new AnnotatedAction(action);
            annotated.setMethod(name.toString());
            return annotated;
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            throw new OgnlException("Cannot set properties on a Action instance - operation not allowed");
        }
    }

    private static class EventPropertyAccessor
    implements PropertyAccessor {
        private EventPropertyAccessor() {
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            Event event = (Event)target;
            return event.getAttributes().get(name.toString());
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            throw new OgnlException("Cannot set attributes on an Event instance - operation not allowed");
        }
    }

    private static class MapAdaptablePropertyAccessor
    implements PropertyAccessor {
        private MapAdaptablePropertyAccessor() {
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            return ((MapAdaptable)target).asMap().get(name);
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            throw new UnsupportedOperationException("Cannot mutate immutable attribute collections; operation disallowed");
        }

        /* synthetic */ MapAdaptablePropertyAccessor(MapAdaptablePropertyAccessor mapAdaptablePropertyAccessor, MapAdaptablePropertyAccessor mapAdaptablePropertyAccessor2) {
            this();
        }
    }

    private static class MessageSourcePropertyAccessor
    implements PropertyAccessor {
        private MessageSourcePropertyAccessor() {
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            MessageSource messageSource = (MessageSource)target;
            Object root = Ognl.getRoot((Map)context);
            ExternalContext externalContext = root instanceof RequestContext ? ((RequestContext)root).getExternalContext() : ExternalContextHolder.getExternalContext();
            if (externalContext != null) {
                return messageSource.getMessage(name.toString(), null, null, externalContext.getLocale());
            }
            return messageSource.getMessage(name.toString(), null, null, null);
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            throw new OgnlException("Cannot set properties on a MessageSource instance - operation not allowed");
        }
    }

    private static class MutableAttributeMapPropertyAccessor
    extends MapAdaptablePropertyAccessor {
        private MutableAttributeMapPropertyAccessor() {
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            ((MutableAttributeMap)target).put((String)name, value);
        }
    }

    private static class RequestContextPropertyAccessor
    implements PropertyAccessor {
        private static final BeanFactory EMPTY_BEAN_FACTORY = new StaticListableBeanFactory();
        private PropertyAccessor delegate;

        public RequestContextPropertyAccessor(PropertyAccessor delegate) {
            this.delegate = delegate;
        }

        public Object getProperty(Map context, Object target, Object name) throws OgnlException {
            String property = name.toString();
            RequestContext requestContext = (RequestContext)target;
            if (property.equals("flowRequestContext")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved the current RequestContext under variable '" + property + "'"));
                }
                return requestContext;
            }
            if (property.equals("currentUser")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved implicit flow variable '" + property + "'"));
                }
                return requestContext.getExternalContext().getCurrentUser();
            }
            if (property.equals("resourceBundle")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved implicit flow variable '" + property + "'"));
                }
                return requestContext.getActiveFlow().getApplicationContext();
            }
            if (requestContext.getRequestScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved request scoped variable '" + property + "'"));
                }
                return requestContext.getRequestScope().get(property);
            }
            if (requestContext.getFlashScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved flash scoped variable '" + property + "'"));
                }
                return requestContext.getFlashScope().get(property);
            }
            if (requestContext.inViewState() && requestContext.getViewScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved view scoped variable '" + property + "'"));
                }
                return requestContext.getViewScope().get(property);
            }
            if (requestContext.getFlowScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved flow scoped variable '" + property + "'"));
                }
                return requestContext.getFlowScope().get(property);
            }
            if (requestContext.getConversationScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved conversation scoped variable '" + property + "'"));
                }
                return requestContext.getConversationScope().get(property);
            }
            BeanFactory bf = this.getBeanFactory(requestContext);
            if (bf.containsBean(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved variable '" + property + "' in Spring BeanFactory"));
                }
                return bf.getBean(property);
            }
            return this.delegate.getProperty(context, target, name);
        }

        public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
            String property = name.toString();
            RequestContext requestContext = (RequestContext)target;
            if (property.equals("flowRequestContext")) {
                throw new OgnlException("The 'flowRequestContext' variable is not writeable");
            }
            if (property.equals("currentUser")) {
                throw new OgnlException("The 'currentUser' variable is not writeable");
            }
            if (property.equals("resourceBundle")) {
                throw new OgnlException("The 'resourceBundle' variable is not writeable");
            }
            if (requestContext.getRequestScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved request scoped variable '" + property + "'"));
                }
                requestContext.getRequestScope().put(property, value);
            } else if (requestContext.getFlashScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved flash scoped variable '" + property + "'"));
                }
                requestContext.getFlashScope().put(property, value);
            } else if (requestContext.inViewState() && requestContext.getViewScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved view scoped variable '" + property + "'"));
                }
                requestContext.getViewScope().put(property, value);
            } else if (requestContext.getFlowScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved flow scoped variable '" + property + "'"));
                }
                requestContext.getFlowScope().put(property, value);
            } else if (requestContext.getConversationScope().contains(property)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Successfully resolved conversation scoped variable '" + property + "'"));
                }
                requestContext.getConversationScope().put(property, value);
            } else {
                this.delegate.setProperty(context, target, name, value);
            }
        }

        private BeanFactory getBeanFactory(RequestContext requestContext) {
            ApplicationContext beanFactory = requestContext.getActiveFlow().getApplicationContext();
            return beanFactory != null ? beanFactory : EMPTY_BEAN_FACTORY;
        }
    }
}

