/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.expression.el;

import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;

public class ScopeSearchingELResolver
extends ELResolver {
    private static final Log logger;
    private RequestContext requestContext;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.expression.el.ScopeSearchingELResolver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((Class)clazz);
    }

    public ScopeSearchingELResolver() {
    }

    public ScopeSearchingELResolver(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public Class getCommonPropertyType(ELContext elContext, Object base) {
        if (base == null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz;
        }
        return null;
    }

    public Iterator getFeatureDescriptors(ELContext elContext, Object base) {
        return null;
    }

    public Class getType(ELContext elContext, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return null;
        }
        String attributeName = property.toString();
        if (requestContext.getRequestScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getRequestScope().get(attributeName).getClass();
        }
        if (requestContext.getFlashScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getFlashScope().get(attributeName).getClass();
        }
        if (requestContext.inViewState() && requestContext.getViewScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getViewScope().get(attributeName).getClass();
        }
        if (requestContext.getFlowScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getFlowScope().get(attributeName).getClass();
        }
        if (requestContext.getConversationScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return requestContext.getConversationScope().get(attributeName).getClass();
        }
        return null;
    }

    public Object getValue(ELContext elContext, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return null;
        }
        String attributeName = property.toString();
        if (requestContext.getRequestScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved request scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            return requestContext.getRequestScope().get(attributeName);
        }
        if (requestContext.getFlashScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved flash scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            return requestContext.getFlashScope().get(attributeName);
        }
        if (requestContext.inViewState() && requestContext.getViewScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved view scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            return requestContext.getViewScope().get(attributeName);
        }
        if (requestContext.getFlowScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved flow scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            return requestContext.getFlowScope().get(attributeName);
        }
        if (requestContext.getConversationScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved conversation scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            return requestContext.getConversationScope().get(attributeName);
        }
        return null;
    }

    public boolean isReadOnly(ELContext elContext, Object base, Object property) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return false;
        }
        String attributeName = property.toString();
        if (requestContext.getRequestScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        if (requestContext.getFlashScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        if (requestContext.inViewState() && requestContext.getViewScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        if (requestContext.getFlowScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        if (requestContext.getConversationScope().contains(attributeName)) {
            elContext.setPropertyResolved(true);
            return false;
        }
        return false;
    }

    public void setValue(ELContext elContext, Object base, Object property, Object value) {
        RequestContext requestContext = this.getRequestContext();
        if (base != null || requestContext == null) {
            return;
        }
        String attributeName = property.toString();
        if (requestContext.getRequestScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved request scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            requestContext.getRequestScope().put(attributeName, value);
        } else if (requestContext.getFlashScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved flash scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            requestContext.getFlashScope().put(attributeName, value);
        } else if (requestContext.inViewState() && requestContext.getViewScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved view scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            requestContext.getViewScope().put(attributeName, value);
        } else if (requestContext.getFlowScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved flow scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            requestContext.getFlowScope().put(attributeName, value);
        } else if (requestContext.getConversationScope().contains(attributeName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully resolved conversation scoped variable '" + property + "'"));
            }
            elContext.setPropertyResolved(true);
            requestContext.getConversationScope().put(attributeName, value);
        }
    }

    protected RequestContext getRequestContext() {
        return this.requestContext != null ? this.requestContext : RequestContextHolder.getRequestContext();
    }
}

