/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.builder;

import java.util.Iterator;
import java.util.List;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.mvc.view.FlowViewResolver;

public class DelegatingFlowViewResolver
implements FlowViewResolver {
    private List viewResolvers;

    public DelegatingFlowViewResolver(List viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    public View resolveView(String viewId, RequestContext context) {
        Iterator it = this.viewResolvers.iterator();
        while (it.hasNext()) {
            ViewResolver viewResolver = (ViewResolver)it.next();
            try {
                View view = viewResolver.resolveViewName(viewId, context.getExternalContext().getLocale());
                if (view == null) continue;
                return view;
            }
            catch (Exception e) {
                throw new IllegalStateException("Exception resolving view with name '" + viewId + "'", e);
            }
        }
        return null;
    }

    public String getViewIdByConvention(String viewStateId) {
        return viewStateId;
    }
}

