/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.format.FormatterRegistry;
import org.springframework.web.servlet.View;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.mvc.view.AbstractMvcView;
import org.springframework.webflow.mvc.view.FlowViewResolver;

public abstract class AbstractMvcViewFactory
implements ViewFactory {
    private Expression viewId;
    private FlowViewResolver viewResolver;
    private ExpressionParser expressionParser;
    private FormatterRegistry formatterRegistry;

    public AbstractMvcViewFactory(Expression viewId, FlowViewResolver viewResolver, ExpressionParser expressionParser, FormatterRegistry formatterRegistry) {
        this.viewId = viewId;
        this.viewResolver = viewResolver;
        this.expressionParser = expressionParser;
        this.formatterRegistry = formatterRegistry;
    }

    protected ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    protected FormatterRegistry getFormatterRegistry() {
        return this.formatterRegistry;
    }

    public org.springframework.webflow.execution.View getView(RequestContext context) {
        String viewId = (String)this.viewId.getValue((Object)context);
        View view = this.viewResolver.resolveView(viewId, context);
        return this.createMvcView(view, context);
    }

    protected abstract AbstractMvcView createMvcView(View var1, RequestContext var2);
}

