/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.FlowExecutionOutcome;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.test.MockFlowSession;

public class MockFlowExecutionContext
implements FlowExecutionContext {
    private boolean started;
    private FlowExecutionKey key;
    private FlowDefinition flow;
    private FlowSession activeSession;
    private MutableAttributeMap flashScope = new LocalAttributeMap();
    private MutableAttributeMap conversationScope = new LocalAttributeMap();
    private MutableAttributeMap attributes = new LocalAttributeMap();
    private FlowExecutionOutcome outcome;

    public MockFlowExecutionContext() {
        this.setActiveSession(new MockFlowSession());
        this.flow = this.activeSession.getDefinition();
    }

    public MockFlowExecutionContext(Flow flow) {
        this(new MockFlowSession(flow));
    }

    public MockFlowExecutionContext(FlowSession flowSession) {
        this.setActiveSession(flowSession);
        this.flow = flowSession.getDefinition();
    }

    public FlowExecutionKey getKey() {
        return this.key;
    }

    public String getCaption() {
        return this.flow.getCaption();
    }

    public FlowDefinition getDefinition() {
        return this.flow;
    }

    public boolean hasStarted() {
        return this.started;
    }

    public boolean isActive() {
        return this.activeSession != null;
    }

    public boolean hasEnded() {
        return this.hasStarted() && !this.isActive();
    }

    public FlowSession getActiveSession() throws IllegalStateException {
        if (this.activeSession == null) {
            throw new IllegalStateException("No flow session is active");
        }
        return this.activeSession;
    }

    public MutableAttributeMap getFlashScope() {
        return this.flashScope;
    }

    public MutableAttributeMap getConversationScope() {
        return this.conversationScope;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public FlowExecutionOutcome getOutcome() {
        return this.outcome;
    }

    public Flow getDefinitionInternal() {
        return (Flow)this.getDefinition();
    }

    public void setFlow(FlowDefinition rootFlow) {
        this.flow = rootFlow;
    }

    public void setKey(FlowExecutionKey key) {
        this.key = key;
    }

    public void setActiveSession(FlowSession activeSession) {
        this.activeSession = activeSession;
        if (!this.started && activeSession != null) {
            this.started = true;
        }
    }

    public void setFlashScope(MutableAttributeMap scope) {
        this.flashScope = scope;
    }

    public void setConversationScope(MutableAttributeMap scope) {
        this.conversationScope = scope;
    }

    public void setOutcome(FlowExecutionOutcome outcome) {
        this.outcome = outcome;
    }

    public MockFlowSession getMockActiveSession() {
        return (MockFlowSession)this.activeSession;
    }

    public MutableAttributeMap getAttributeMap() {
        return this.attributes;
    }

    public void putAttribute(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName, attributeValue);
    }
}

