/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import java.io.IOException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.format.FormatterRegistry;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.execution.ViewFactory;

class MockViewFactoryCreator
implements ViewFactoryCreator {
    MockViewFactoryCreator() {
    }

    public ViewFactory createViewFactory(Expression viewId, ExpressionParser expressionParser, FormatterRegistry formatterRegistry) {
        return new MockViewFactory(viewId);
    }

    public String getViewIdByConvention(String viewStateId) {
        return viewStateId;
    }

    static class MockView
    implements View {
        private String viewId;
        private RequestContext context;

        public MockView(String viewId, RequestContext context) {
            this.viewId = viewId;
            this.context = context;
        }

        public String getViewId() {
            return this.viewId;
        }

        public void processUserEvent() {
        }

        public boolean hasFlowEvent() {
            return this.context.getRequestParameters().contains("_eventId");
        }

        public Event getFlowEvent() {
            return new Event(this, this.context.getRequestParameters().get("_eventId"));
        }

        public void render() throws IOException {
            this.context.getExternalContext().getResponseWriter().append(this.viewId);
        }
    }

    static class MockViewFactory
    implements ViewFactory {
        private Expression viewId;

        public MockViewFactory(Expression viewId) {
            this.viewId = viewId;
        }

        public View getView(RequestContext context) {
            String viewId = (String)this.viewId.getValue((Object)context);
            return new MockView(viewId, context);
        }
    }
}

