/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test.execution;

import org.springframework.webflow.config.FlowDefinitionResource;
import org.springframework.webflow.config.FlowDefinitionResourceFactory;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.builder.FlowAssembler;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;
import org.springframework.webflow.test.MockFlowBuilderContext;
import org.springframework.webflow.test.execution.AbstractFlowExecutionTests;

public abstract class AbstractExternalizedFlowExecutionTests
extends AbstractFlowExecutionTests {
    private static Flow cachedFlowDefinition;
    private boolean cacheFlowDefinition = false;
    private FlowDefinitionResourceFactory resourceFactory = new FlowDefinitionResourceFactory();
    private MockFlowBuilderContext flowBuilderContext;

    public AbstractExternalizedFlowExecutionTests() {
    }

    public AbstractExternalizedFlowExecutionTests(String name) {
        super(name);
    }

    private FlowExecutionImplFactory getFlowExecutionImplFactory() {
        return (FlowExecutionImplFactory)this.getFlowExecutionFactory();
    }

    protected boolean isCacheFlowDefinition() {
        return this.cacheFlowDefinition;
    }

    protected void setCacheFlowDefinition(boolean cacheFlowDefinition) {
        this.cacheFlowDefinition = cacheFlowDefinition;
    }

    protected void setFlowExecutionAttributes(AttributeMap executionAttributes) {
        this.getFlowExecutionImplFactory().setExecutionAttributes(executionAttributes);
    }

    protected void setFlowExecutionListener(FlowExecutionListener executionListener) {
        this.getFlowExecutionImplFactory().setExecutionListenerLoader(new StaticFlowExecutionListenerLoader(executionListener));
    }

    protected void setFlowExecutionListeners(FlowExecutionListener[] executionListeners) {
        this.getFlowExecutionImplFactory().setExecutionListenerLoader(new StaticFlowExecutionListenerLoader(executionListeners));
    }

    protected FlowDefinitionResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    protected final FlowDefinition getFlowDefinition() {
        if (this.isCacheFlowDefinition() && cachedFlowDefinition != null) {
            return cachedFlowDefinition;
        }
        Flow flow = this.buildFlow();
        if (this.isCacheFlowDefinition()) {
            cachedFlowDefinition = flow;
        }
        return flow;
    }

    protected final Flow getFlow() {
        return (Flow)this.getFlowDefinition();
    }

    protected final Flow buildFlow() {
        FlowDefinitionResource resource = this.getResource(this.getResourceFactory());
        this.flowBuilderContext = new MockFlowBuilderContext(resource.getId(), resource.getAttributes());
        this.configureFlowBuilderContext(this.flowBuilderContext);
        FlowBuilder builder = this.createFlowBuilder(resource);
        FlowAssembler assembler = new FlowAssembler(builder, this.flowBuilderContext);
        return assembler.assembleFlow();
    }

    protected void configureFlowBuilderContext(MockFlowBuilderContext builderContext) {
    }

    protected FlowDefinitionRegistry getFlowDefinitionRegistry() {
        return (FlowDefinitionRegistry)this.flowBuilderContext.getFlowDefinitionLocator();
    }

    protected abstract FlowDefinitionResource getResource(FlowDefinitionResourceFactory var1);

    protected abstract FlowBuilder createFlowBuilder(FlowDefinitionResource var1);
}

