/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.idgnr.impl;

import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.idgnr.EgovIdGnrService;
import egovframework.rte.fdl.idgnr.EgovIdGnrStrategy;
import egovframework.rte.fdl.idgnr.impl.Base64;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;

@Deprecated
public class EgovUUIdGnrService
implements EgovIdGnrService,
ApplicationContextAware {
    private MessageSource messageSource;
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovUUIdGnrService.class);
    private static final String ERROR_STRING = "address in the configuration should be a valid IP or MAC Address";
    private String mAddressId;
    private String mTimeId;
    private short mLoopCounter = 0;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    @Override
    public BigDecimal getNextBigDecimalId() throws FdlException {
        String newId = this.getNextStringId();
        byte[] bytes = newId.getBytes();
        BigDecimal bd = new BigDecimal(0);
        for (int i = 0; i < bytes.length; ++i) {
            bd = bd.multiply(new BigDecimal(256));
            bd = bd.add(new BigDecimal(bytes[i] & 0xFF));
        }
        return bd;
    }

    @Override
    public byte getNextByteId() throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"Byte"}, null);
    }

    @Override
    public int getNextIntegerId() throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"Integer"}, null);
    }

    @Override
    public long getNextLongId() throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"Long"}, null);
    }

    @Override
    public short getNextShortId() throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"Short"}, null);
    }

    @Override
    public String getNextStringId() throws FdlException {
        return this.getUUId();
    }

    @Override
    public String getNextStringId(EgovIdGnrStrategy strategy) throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"String"}, null);
    }

    @Override
    public String getNextStringId(String strategyId) throws FdlException {
        throw new FdlException(this.messageSource, "error.idgnr.not.supported", (Object[])new String[]{"String"}, null);
    }

    public void setAddress(String address) throws FdlException {
        byte[] addressBytes = new byte[6];
        if (null == address) {
            LOGGER.warn("IDGeneration Service : Using a random number as the base for id's.  This is not the best method for many purposes, but may be adequate in some circumstances. Consider using an IP or ethernet (MAC) address if available. ");
            for (int i = 0; i < 6; ++i) {
                addressBytes[i] = (byte)(255.0 * Math.random());
            }
        } else if (address.indexOf(".") > 0) {
            StringTokenizer stok = new StringTokenizer(address, ".");
            if (stok.countTokens() != 4) {
                throw new FdlException(ERROR_STRING);
            }
            addressBytes[0] = -1;
            addressBytes[1] = -1;
            int i = 2;
            try {
                while (stok.hasMoreTokens()) {
                    addressBytes[i++] = Integer.valueOf(stok.nextToken(), 16).byteValue();
                }
            }
            catch (Exception e) {
                throw new FdlException(ERROR_STRING);
            }
        } else if (address.indexOf(":") > 0) {
            StringTokenizer stok = new StringTokenizer(address, ":");
            if (stok.countTokens() != 6) {
                throw new FdlException(ERROR_STRING);
            }
            int i = 0;
            try {
                while (stok.hasMoreTokens()) {
                    addressBytes[i++] = Integer.valueOf(stok.nextToken(), 16).byteValue();
                }
            }
            catch (Exception e) {
                throw new FdlException(ERROR_STRING);
            }
        } else {
            throw new FdlException(ERROR_STRING);
        }
        this.mAddressId = Base64.encode(addressBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUUId() {
        short counter;
        byte[] bytes6 = new byte[6];
        long timeNow = System.currentTimeMillis();
        timeNow = (int)timeNow & 0xFFFFFFFF;
        byte[] bytes4 = new byte[4];
        this.toFixSizeByteArray(new BigInteger(String.valueOf(timeNow)), bytes4);
        bytes6[0] = bytes4[0];
        bytes6[1] = bytes4[1];
        bytes6[2] = bytes4[2];
        bytes6[3] = bytes4[3];
        EgovUUIdGnrService egovUUIdGnrService = this;
        synchronized (egovUUIdGnrService) {
            counter = this.getLoopCounter();
        }
        byte[] bytes2 = new byte[2];
        this.toFixSizeByteArray(new BigInteger(String.valueOf(counter)), bytes2);
        bytes6[4] = bytes2[0];
        bytes6[5] = bytes2[1];
        this.mTimeId = Base64.encode(bytes6);
        return (this.mAddressId + this.mTimeId).replace('+', '_').replace('/', '@');
    }

    private short getLoopCounter() {
        short s = this.mLoopCounter;
        this.mLoopCounter = (short)(s + 1);
        return s;
    }

    private void toFixSizeByteArray(BigInteger bigInt, byte[] destination) {
        for (int i = 0; i < destination.length; ++i) {
            destination[i] = 0;
        }
        byte[] source = bigInt.toByteArray();
        if (source.length <= destination.length) {
            for (int i = 0; i < source.length; ++i) {
                destination[destination.length - source.length + i] = source[i];
            }
        } else {
            for (int i = 0; i < destination.length; ++i) {
                destination[i] = source[source.length - destination.length + i];
            }
        }
    }
}

