/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.excel.impl;

import com.ibatis.sqlmap.client.SqlMapClient;
import egovframework.rte.fdl.cmmn.exception.BaseException;
import egovframework.rte.fdl.excel.EgovExcelMapping;
import egovframework.rte.fdl.excel.EgovExcelService;
import egovframework.rte.fdl.excel.impl.EgovExcelServiceDAO;
import egovframework.rte.fdl.filehandling.EgovFileUtil;
import egovframework.rte.fdl.string.EgovObjectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

public class EgovExcelServiceImpl
implements EgovExcelService {
    private EgovExcelServiceDAO dao;
    protected Log log = LogFactory.getLog(this.getClass());
    private MessageSource messageSource;
    private String propertyPath;
    private String mapClass;
    private SqlMapClient sqlMapClient;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }

    protected MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setPropertyPath(String path) throws BaseException {
        this.propertyPath = path;
        this.log.debug((Object)("setPropertyPath : " + path));
    }

    public void setSqlMapClient(SqlMapClient sqlMapClient) throws Exception {
        this.sqlMapClient = sqlMapClient;
        this.dao = new EgovExcelServiceDAO(this.sqlMapClient);
    }

    public void setMapClass(String mapClass) throws BaseException {
        this.mapClass = mapClass;
        this.log.debug((Object)("mapClass : " + mapClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HSSFWorkbook loadExcelTemplate(String templateName) throws BaseException, FileNotFoundException, IOException {
        FileInputStream fileIn = new FileInputStream(templateName);
        HSSFWorkbook wb = null;
        this.log.debug((Object)("EgovExcelServiceImpl.loadExcelTemplate : templatePath is " + templateName));
        try {
            this.log.debug((Object)"ExcelServiceImpl loadExcelTemplate ...");
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)fileIn);
            wb = new HSSFWorkbook(fs);
        }
        catch (Exception e) {
            this.log.error((Object)this.getMessageSource().getMessage("error.excel.runtime.error", new Object[]{"EgovExcelServiceImpl loadExcelTemplate"}, Locale.getDefault()), (Throwable)e);
        }
        finally {
            this.log.debug((Object)"ExcelServiceImpl loadExcelTemplate end...");
            fileIn.close();
        }
        return wb;
    }

    public HSSFWorkbook loadWorkbook(String filepath) throws BaseException, FileNotFoundException, IOException {
        FileInputStream fileIn = new FileInputStream(filepath);
        HSSFWorkbook wb = this.loadWorkbook(fileIn);
        fileIn.close();
        return wb;
    }

    public HSSFWorkbook loadWorkbook(InputStream fileIn) throws BaseException {
        HSSFWorkbook wb = new HSSFWorkbook();
        try {
            this.log.debug((Object)"ExcelServiceImpl loadWorkbook ...");
            POIFSFileSystem fs = new POIFSFileSystem(fileIn);
            wb = new HSSFWorkbook(fs);
        }
        catch (Exception e) {
            this.log.error((Object)this.getMessageSource().getMessage("error.excel.runtime.error", new Object[]{"Roles and Url"}, Locale.getDefault()), (Throwable)e);
        }
        return wb;
    }

    public void writeWorkbook(HSSFWorkbook workbook) throws BaseException, IOException {
        workbook.write(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HSSFWorkbook createWorkbook(HSSFWorkbook wb, String filepath) throws BaseException, FileNotFoundException, IOException {
        String fullFileName = filepath;
        this.log.debug((Object)("EgovExcelServiceImpl.createWorkbook : templatePath is " + FilenameUtils.getFullPath((String)fullFileName)));
        if (!EgovFileUtil.isExistsFile((String)FilenameUtils.getFullPath((String)fullFileName))) {
            this.log.debug((Object)("make dir " + FilenameUtils.getFullPath((String)fullFileName)));
            try {
                FileUtils.forceMkdir((File)new File(FilenameUtils.getFullPath((String)fullFileName)));
            }
            catch (IOException e) {
                throw new IOException("Cannot create directory for path: " + FilenameUtils.getFullPath((String)fullFileName));
            }
        }
        FileOutputStream fileOut = new FileOutputStream(fullFileName);
        this.log.debug((Object)("EgovExcelServiceImpl.createWorkbook : templatePath is " + fullFileName));
        try {
            this.log.debug((Object)"ExcelServiceImpl loadExcelObject ...");
            wb.write((OutputStream)fileOut);
        }
        catch (Exception e) {
            this.log.error((Object)this.getMessageSource().getMessage("error.excel.runtime.error", new Object[]{"Roles and Url"}, Locale.getDefault()), (Throwable)e);
        }
        finally {
            this.log.debug((Object)"ExcelServiceImpl loadExcelObject end...");
            fileOut.close();
        }
        return wb;
    }

    public Integer uploadExcel(String queryId, HSSFSheet sheet, int start, long commitCnt) throws BaseException, Exception {
        this.log.debug((Object)("sheet.getPhysicalNumberOfRows() : " + sheet.getPhysicalNumberOfRows()));
        Integer rowsAffected = 0;
        try {
            long rowCnt = sheet.getPhysicalNumberOfRows();
            long cnt = commitCnt == 0L ? rowCnt : commitCnt;
            this.log.debug((Object)("Runtime.getRuntime().totalMemory() : " + Runtime.getRuntime().totalMemory()));
            this.log.debug((Object)("Runtime.getRuntime().freeMemory() : " + Runtime.getRuntime().freeMemory()));
            long startTime = System.currentTimeMillis();
            int idx = start;
            int i = start;
            while ((long)idx < rowCnt) {
                ArrayList<Object> list = new ArrayList<Object>();
                this.log.debug((Object)("before Runtime.getRuntime().freeMemory() : " + Runtime.getRuntime().freeMemory()));
                EgovExcelMapping mapping = (EgovExcelMapping)EgovObjectUtil.instantiate((String)this.mapClass);
                i = idx;
                while ((long)i < rowCnt && (long)i < cnt + (long)idx) {
                    HSSFRow row = sheet.getRow(i);
                    list.add(mapping.mappingColumn(row));
                    ++i;
                }
                rowsAffected = rowsAffected + this.dao.batchInsert(queryId, list);
                this.log.debug((Object)("after Runtime.getRuntime().freeMemory() : " + Runtime.getRuntime().freeMemory()));
                this.log.debug((Object)("\n\n\n" + rowsAffected));
                idx = i;
            }
            this.log.debug((Object)("batchInsert time is " + (System.currentTimeMillis() - startTime)));
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        this.log.debug((Object)("uploadExcel result count is " + rowsAffected));
        return rowsAffected;
    }

    public Integer uploadExcel(String queryId, HSSFSheet sheet, int start) throws BaseException, Exception {
        return this.uploadExcel(queryId, sheet, start, 0L);
    }

    public Integer uploadExcel(String queryId, HSSFSheet sheet, long commitCnt) throws BaseException, Exception {
        return this.uploadExcel(queryId, sheet, 0, commitCnt);
    }

    public Integer uploadExcel(String queryId, HSSFSheet sheet) throws BaseException, Exception {
        return this.uploadExcel(queryId, sheet, 0, 0L);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, int start, long commitCnt) throws BaseException, Exception {
        HSSFWorkbook wb = this.loadWorkbook(fileIn);
        HSSFSheet sheet = wb.getSheetAt(0);
        return this.uploadExcel(queryId, sheet, start, commitCnt);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, int start) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, start, 0L);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, long commitCnt) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, 0, commitCnt);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, 0, 0L);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, short sheetIndex, int start, long commitCnt) throws BaseException, Exception {
        HSSFWorkbook wb = this.loadWorkbook(fileIn);
        HSSFSheet sheet = wb.getSheetAt((int)sheetIndex);
        return this.uploadExcel(queryId, sheet, start, commitCnt);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, short sheetIndex, int start) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, sheetIndex, start, 0L);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, short sheetIndex, long commitCnt) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, sheetIndex, 0, commitCnt);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, short sheetIndex) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, sheetIndex, 0, 0L);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, String sheetName, int start, long commitCnt) throws BaseException, Exception {
        HSSFWorkbook wb = this.loadWorkbook(fileIn);
        HSSFSheet sheet = wb.getSheet(sheetName);
        return this.uploadExcel(queryId, sheet, start, commitCnt);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, String sheetName, int start) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, sheetName, start, 0L);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, String sheetName, long commitCnt) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, sheetName, 0, commitCnt);
    }

    public Integer uploadExcel(String queryId, InputStream fileIn, String sheetName) throws BaseException, Exception {
        return this.uploadExcel(queryId, fileIn, sheetName, 0, 0L);
    }
}

