/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.webflow.config.FlowElementAttribute;
import org.w3c.dom.Element;

class FlowExecutorBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    static /* synthetic */ Class class$0;

    FlowExecutorBeanDefinitionParser() {
    }

    protected Class getBeanClass(Element element) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.webflow.config.FlowExecutorFactoryBean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        definitionBuilder.addPropertyReference("flowDefinitionLocator", this.getFlowRegistry(element, parserContext));
        this.addFlowExecutionRepositoryProperties(element, definitionBuilder, parserContext);
        definitionBuilder.addPropertyValue("flowExecutionAttributes", (Object)this.parseFlowExecutionAttributes(element));
        this.addFlowExecutionListenerLoader(element, parserContext, definitionBuilder);
    }

    private String getFlowRegistry(Element element, ParserContext parserContext) {
        String registry = element.getAttribute("flow-registry");
        if (!StringUtils.hasText((String)registry)) {
            return "flowRegistry";
        }
        return registry;
    }

    private void addFlowExecutionRepositoryProperties(Element element, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        Element repositoryElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-execution-repository");
        if (repositoryElement != null) {
            this.addMaxExecutions(repositoryElement, definitionBuilder, parserContext);
            this.addMaxSnapshots(repositoryElement, definitionBuilder, parserContext);
        }
    }

    private void addMaxExecutions(Element element, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        String maxConversations = element.getAttribute("max-executions");
        if (StringUtils.hasText((String)maxConversations)) {
            definitionBuilder.addPropertyValue("maxFlowExecutions", (Object)maxConversations);
        }
    }

    private void addMaxSnapshots(Element element, BeanDefinitionBuilder definitionBuilder, ParserContext parserContext) {
        String maxSnapshots = element.getAttribute("max-execution-snapshots");
        if (StringUtils.hasText((String)maxSnapshots)) {
            definitionBuilder.addPropertyValue("maxFlowExecutionSnapshots", (Object)maxSnapshots);
        }
    }

    private Set parseFlowExecutionAttributes(Element element) {
        Element executionAttributesElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-execution-attributes");
        if (executionAttributesElement != null) {
            HashSet<FlowElementAttribute> attributes = new HashSet<FlowElementAttribute>();
            Element redirectElement = DomUtils.getChildElementByTagName((Element)executionAttributesElement, (String)"always-redirect-on-pause");
            if (redirectElement != null) {
                String value = redirectElement.getAttribute("value");
                attributes.add(new FlowElementAttribute("alwaysRedirectOnPause", value, "boolean"));
            }
            List attributeElements = DomUtils.getChildElementsByTagName((Element)executionAttributesElement, (String)"attribute");
            Iterator it = attributeElements.iterator();
            while (it.hasNext()) {
                Element attributeElement = (Element)it.next();
                String name = attributeElement.getAttribute("name");
                String value = attributeElement.getAttribute("value");
                String type = attributeElement.getAttribute("type");
                attributes.add(new FlowElementAttribute(name, value, type));
            }
            return attributes;
        }
        return null;
    }

    private void addFlowExecutionListenerLoader(Element element, ParserContext parserContext, BeanDefinitionBuilder definitionBuilder) {
        Element listenersElement = DomUtils.getChildElementByTagName((Element)element, (String)"flow-execution-listeners");
        if (listenersElement != null) {
            definitionBuilder.addPropertyValue("flowExecutionListenerLoader", (Object)parserContext.getDelegate().parseCustomElement(listenersElement, (BeanDefinition)definitionBuilder.getBeanDefinition()));
        }
    }
}

