/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import org.springframework.webflow.engine.AnnotatedObject;
import org.springframework.webflow.engine.VariableValueFactory;
import org.springframework.webflow.execution.RequestContext;

public class ViewVariable
extends AnnotatedObject {
    private String name;
    private VariableValueFactory valueFactory;

    public ViewVariable(String name, VariableValueFactory valueFactory) {
        this.name = name;
        this.valueFactory = valueFactory;
    }

    public String getName() {
        return this.name;
    }

    public VariableValueFactory getValueFactory() {
        return this.valueFactory;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ViewVariable)) {
            return false;
        }
        ViewVariable other = (ViewVariable)o;
        return this.name.equals(other.name) && this.valueFactory.equals(other.valueFactory);
    }

    public int hashCode() {
        return this.name.hashCode() + this.valueFactory.hashCode();
    }

    public void create(RequestContext context) {
        Object value = this.valueFactory.createInitialValue(context);
        context.getViewScope().put(this.name, value);
    }

    public void restore(RequestContext context) {
        Object value = context.getViewScope().get(this.name);
        this.valueFactory.restoreReferences(value, context);
    }

    public Object destroy(RequestContext context) {
        return context.getViewScope().remove(this.name);
    }
}

