/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.impl;

import org.springframework.binding.message.DefaultMessageContextFactory;
import org.springframework.binding.message.MessageContextFactory;
import org.springframework.context.MessageSource;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.engine.impl.FlowExecutionImpl;
import org.springframework.webflow.execution.factory.FlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.StaticFlowExecutionListenerLoader;

abstract class FlowExecutionImplServicesConfigurer {
    private AttributeMap executionAttributes = CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    private FlowExecutionListenerLoader executionListenerLoader = StaticFlowExecutionListenerLoader.EMPTY_INSTANCE;

    FlowExecutionImplServicesConfigurer() {
    }

    public void setExecutionAttributes(AttributeMap executionAttributes) {
        Assert.notNull((Object)executionAttributes, (String)"The execution attributes map is required");
        this.executionAttributes = executionAttributes;
    }

    public void setExecutionListenerLoader(FlowExecutionListenerLoader executionListenerLoader) {
        Assert.notNull((Object)executionListenerLoader, (String)"The execution listener loader is required");
        this.executionListenerLoader = executionListenerLoader;
    }

    protected void configureServices(FlowExecutionImpl execution) {
        execution.setAttributes(this.executionAttributes);
        execution.setListeners(this.executionListenerLoader.getListeners(execution.getDefinition()));
        execution.setMessageContextFactory((MessageContextFactory)new DefaultMessageContextFactory((MessageSource)execution.getDefinition().getApplicationContext()));
    }
}

