/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.springframework.webflow.engine.model.Model;

public abstract class AbstractModel
implements Model {
    protected Object merge(Object child, Object parent) {
        if (child == null) {
            return parent;
        }
        return child;
    }

    protected String merge(String child, String parent) {
        return (String)this.merge((Object)child, (Object)parent);
    }

    protected Model merge(Model child, Model parent) {
        if (child == null) {
            return parent;
        }
        if (parent == null) {
            return child;
        }
        child.merge(parent);
        return child;
    }

    protected LinkedList merge(LinkedList child, LinkedList parent) {
        return this.merge(child, parent, true);
    }

    protected LinkedList merge(LinkedList child, LinkedList parent, boolean addAtEnd) {
        if (child == null) {
            return parent;
        }
        if (parent == null) {
            return child;
        }
        if (!addAtEnd) {
            parent = new LinkedList(parent);
            Collections.reverse(parent);
        }
        Iterator parentIt = parent.iterator();
        while (parentIt.hasNext()) {
            Model parentElement = (Model)parentIt.next();
            boolean matchFound = false;
            Iterator childIt = child.iterator();
            while (!matchFound && childIt.hasNext()) {
                Model childElement = (Model)childIt.next();
                if (!childElement.isMergeableWith(parentElement)) continue;
                matchFound = true;
                childElement.merge(parentElement);
            }
            if (matchFound) continue;
            if (addAtEnd) {
                child.addLast(parentElement);
                continue;
            }
            child.addFirst(parentElement);
        }
        return child;
    }
}

