/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractModel;
import org.springframework.webflow.engine.model.AttributeModel;
import org.springframework.webflow.engine.model.ExceptionHandlerModel;
import org.springframework.webflow.engine.model.SecuredModel;

public abstract class AbstractStateModel
extends AbstractModel {
    private String id;
    private String parent;
    private LinkedList attributes;
    private SecuredModel secured;
    private LinkedList onEntryActions;
    private LinkedList exceptionHandlers;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = StringUtils.hasText((String)id) ? id : null;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = StringUtils.hasText((String)parent) ? parent : null;
    }

    public LinkedList getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LinkedList attributes) {
        this.attributes = attributes;
    }

    public void addAttribute(AttributeModel attribute) {
        if (attribute == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.add(attribute);
    }

    public void addAttributes(LinkedList attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new LinkedList();
        }
        this.attributes.addAll(attributes);
    }

    public SecuredModel getSecured() {
        return this.secured;
    }

    public void setSecured(SecuredModel secured) {
        this.secured = secured;
    }

    public LinkedList getOnEntryActions() {
        return this.onEntryActions;
    }

    public void setOnEntryActions(LinkedList onEntryActions) {
        this.onEntryActions = onEntryActions;
    }

    public void addOnEntryAction(AbstractActionModel onEntryAction) {
        if (onEntryAction == null) {
            return;
        }
        if (this.onEntryActions == null) {
            this.onEntryActions = new LinkedList();
        }
        this.onEntryActions.add(onEntryAction);
    }

    public void addOnEntryActions(LinkedList onEntryActions) {
        if (onEntryActions == null || onEntryActions.isEmpty()) {
            return;
        }
        if (this.onEntryActions == null) {
            this.onEntryActions = new LinkedList();
        }
        this.onEntryActions.addAll(onEntryActions);
    }

    public LinkedList getExceptionHandlers() {
        return this.exceptionHandlers;
    }

    public void setExceptionHandlers(LinkedList exceptionHandlers) {
        this.exceptionHandlers = exceptionHandlers;
    }

    public void addExceptionHandler(ExceptionHandlerModel exceptionHandler) {
        if (exceptionHandler == null) {
            return;
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new LinkedList();
        }
        this.exceptionHandlers.add(exceptionHandler);
    }

    public void addExceptionHandlers(LinkedList exceptionHandlers) {
        if (exceptionHandlers == null || exceptionHandlers.isEmpty()) {
            return;
        }
        if (this.exceptionHandlers == null) {
            this.exceptionHandlers = new LinkedList();
        }
        this.exceptionHandlers.addAll(exceptionHandlers);
    }
}

