/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.model;

import java.util.LinkedList;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.engine.model.AbstractActionModel;
import org.springframework.webflow.engine.model.AbstractTransitionableStateModel;
import org.springframework.webflow.engine.model.Model;
import org.springframework.webflow.engine.model.SecuredModel;
import org.springframework.webflow.engine.model.VarModel;

public class ViewStateModel
extends AbstractTransitionableStateModel {
    private String view;
    private String redirect;
    private String popup;
    private String model;
    private LinkedList vars;
    private LinkedList onRenderActions;

    public ViewStateModel(String id) {
        this.setId(id);
    }

    public boolean isMergeableWith(Model model) {
        if (!(model instanceof ViewStateModel)) {
            return false;
        }
        ViewStateModel state = (ViewStateModel)model;
        return ObjectUtils.nullSafeEquals((Object)this.getId(), (Object)state.getId());
    }

    public void merge(Model model) {
        ViewStateModel state = (ViewStateModel)model;
        this.setParent(null);
        this.setAttributes(this.merge(this.getAttributes(), state.getAttributes()));
        this.setSecured((SecuredModel)this.merge(this.getSecured(), state.getSecured()));
        this.setOnEntryActions(this.merge(this.getOnEntryActions(), state.getOnEntryActions(), false));
        this.setExceptionHandlers(this.merge(this.getExceptionHandlers(), state.getExceptionHandlers()));
        this.setTransitions(this.merge(this.getTransitions(), state.getTransitions()));
        this.setOnExitActions(this.merge(this.getOnExitActions(), state.getOnExitActions(), false));
        this.setView(this.merge(this.getView(), state.getView()));
        this.setRedirect(this.merge(this.getRedirect(), state.getRedirect()));
        this.setPopup(this.merge(this.getPopup(), state.getPopup()));
        this.setModel(this.merge(this.getModel(), state.getModel()));
        this.setVars(this.merge(this.getVars(), state.getVars(), false));
        this.setOnRenderActions(this.merge(this.getOnRenderActions(), state.getOnRenderActions(), false));
    }

    public String getView() {
        return this.view;
    }

    public void setView(String view) {
        this.view = StringUtils.hasText((String)view) ? view : null;
    }

    public String getRedirect() {
        return this.redirect;
    }

    public void setRedirect(String redirect) {
        this.redirect = StringUtils.hasText((String)redirect) ? redirect : null;
    }

    public String getPopup() {
        return this.popup;
    }

    public void setPopup(String popup) {
        this.popup = StringUtils.hasText((String)popup) ? popup : null;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = StringUtils.hasText((String)model) ? model : null;
    }

    public LinkedList getVars() {
        return this.vars;
    }

    public void setVars(LinkedList vars) {
        this.vars = vars;
    }

    public void addVar(VarModel var) {
        if (var == null) {
            return;
        }
        if (this.vars == null) {
            this.vars = new LinkedList();
        }
        this.vars.add(var);
    }

    public void addVars(LinkedList vars) {
        if (vars == null || vars.isEmpty()) {
            return;
        }
        if (this.vars == null) {
            this.vars = new LinkedList();
        }
        this.vars.addAll(vars);
    }

    public LinkedList getOnRenderActions() {
        return this.onRenderActions;
    }

    public void setOnRenderActions(LinkedList onRenderActions) {
        this.onRenderActions = onRenderActions;
    }

    public void addOnRenderAction(AbstractActionModel onRenderAction) {
        if (onRenderAction == null) {
            return;
        }
        if (this.onRenderActions == null) {
            this.onRenderActions = new LinkedList();
        }
        this.onRenderActions.add(onRenderAction);
    }

    public void addOnRenderActions(LinkedList onRenderActions) {
        if (onRenderActions == null || onRenderActions.isEmpty()) {
            return;
        }
        if (this.onRenderActions == null) {
            this.onRenderActions = new LinkedList();
        }
        this.onRenderActions.addAll(onRenderActions);
    }
}

