/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.snapshot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.springframework.util.FileCopyUtils;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshot;
import org.springframework.webflow.execution.repository.snapshot.SnapshotCreationException;
import org.springframework.webflow.execution.repository.snapshot.SnapshotUnmarshalException;

class SerializedFlowExecutionSnapshot
extends FlowExecutionSnapshot
implements Externalizable {
    private byte[] flowExecutionData;
    private boolean compressed;

    public SerializedFlowExecutionSnapshot() {
    }

    public SerializedFlowExecutionSnapshot(FlowExecution flowExecution, boolean compress) throws SnapshotCreationException {
        try {
            this.flowExecutionData = this.serialize(flowExecution);
            if (compress) {
                this.flowExecutionData = this.compress(this.flowExecutionData);
            }
        }
        catch (NotSerializableException e) {
            throw new SnapshotCreationException(flowExecution, "Could not serialize flow execution; make sure all objects stored in flow or flash scope are serializable", e);
        }
        catch (IOException e) {
            throw new SnapshotCreationException(flowExecution, "IOException thrown serializing flow execution -- this should not happen!", e);
        }
        this.compressed = compress;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    public FlowExecution unmarshal() throws SnapshotUnmarshalException {
        try {
            return this.deserialize(this.getFlowExecutionData());
        }
        catch (IOException e) {
            throw new SnapshotUnmarshalException("IOException thrown deserializing the flow execution stored in this snapshot -- this should not happen!", e);
        }
        catch (ClassNotFoundException e) {
            throw new SnapshotUnmarshalException("ClassNotFoundException thrown deserializing the flow execution stored in this snapshot -- This should not happen! Make sure there are no classloader issues. For example, perhaps the Web Flow system is being loaded by a classloader that is a parent of the classloader loading application classes?", e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.flowExecutionData.length + 40);
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(this);
                oos.flush();
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                oos.close();
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            oos.close();
            return baos.toByteArray();
        }
        catch (IOException iOException) {
            throw new IllegalStateException();
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof SerializedFlowExecutionSnapshot)) {
            return false;
        }
        SerializedFlowExecutionSnapshot c = (SerializedFlowExecutionSnapshot)o;
        return Arrays.equals(this.flowExecutionData, c.flowExecutionData);
    }

    public int hashCode() {
        int hashCode = 0;
        int i = 0;
        while (i < this.flowExecutionData.length) {
            hashCode += this.flowExecutionData[i];
            ++i;
        }
        return hashCode;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.flowExecutionData.length);
        out.write(this.flowExecutionData);
        out.writeBoolean(this.compressed);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int length = in.readInt();
        this.flowExecutionData = new byte[length];
        in.readFully(this.flowExecutionData);
        this.compressed = in.readBoolean();
    }

    protected byte[] getFlowExecutionData() throws IOException {
        if (this.isCompressed()) {
            return this.decompress(this.flowExecutionData);
        }
        return this.flowExecutionData;
    }

    protected byte[] serialize(FlowExecution flowExecution) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(flowExecution);
            oos.flush();
            byArray = baos.toByteArray();
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            oos.close();
            throw throwable;
        }
        oos.close();
        return byArray;
    }

    protected FlowExecution deserialize(byte[] data) throws IOException, ClassNotFoundException {
        FlowExecution flowExecution;
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            flowExecution = (FlowExecution)ois.readObject();
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ois.close();
            throw throwable;
        }
        ois.close();
        return flowExecution;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] compress(byte[] dataToCompress) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipos = new GZIPOutputStream(baos);
        try {
            gzipos.write(dataToCompress);
            gzipos.flush();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            gzipos.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        gzipos.close();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] decompress(byte[] dataToDecompress) throws IOException {
        GZIPInputStream gzipin = new GZIPInputStream(new ByteArrayInputStream(dataToDecompress));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            FileCopyUtils.copy((InputStream)gzipin, (OutputStream)baos);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            gzipin.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        gzipin.close();
        return baos.toByteArray();
    }
}

