/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.builder;

import org.springframework.context.ApplicationContext;
import org.springframework.core.enums.StaticLabeledEnum;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.portlet.context.ConfigurablePortletApplicationContext;

public class MvcEnvironment
extends StaticLabeledEnum {
    public static final MvcEnvironment SERVLET = new MvcEnvironment(0, "servlet");
    public static final MvcEnvironment PORTLET = new MvcEnvironment(1, "portlet");

    private MvcEnvironment(int code, String label) {
        super(code, label);
    }

    public static MvcEnvironment environmentFor(ApplicationContext applicationContext) {
        if (ClassUtils.isPresent((String)"javax.portlet.PortletContext") && applicationContext instanceof ConfigurablePortletApplicationContext) {
            return PORTLET;
        }
        if (applicationContext instanceof WebApplicationContext) {
            return SERVLET;
        }
        return null;
    }
}

