/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.builder;

import java.util.List;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.format.FormatterRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.webflow.engine.builder.ViewFactoryCreator;
import org.springframework.webflow.execution.ViewFactory;
import org.springframework.webflow.mvc.builder.DelegatingFlowViewResolver;
import org.springframework.webflow.mvc.builder.FlowResourceFlowViewResolver;
import org.springframework.webflow.mvc.builder.MvcEnvironment;
import org.springframework.webflow.mvc.portlet.PortletMvcViewFactory;
import org.springframework.webflow.mvc.servlet.ServletMvcViewFactory;
import org.springframework.webflow.mvc.view.FlowViewResolver;

public class MvcViewFactoryCreator
implements ViewFactoryCreator,
ApplicationContextAware {
    private MvcEnvironment environment;
    private FlowViewResolver flowViewResolver = new FlowResourceFlowViewResolver();

    public MvcEnvironment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(MvcEnvironment environment) {
        this.environment = environment;
    }

    public void setDefaultViewSuffix(String defaultViewSuffix) {
        FlowResourceFlowViewResolver internalResourceResolver = new FlowResourceFlowViewResolver();
        internalResourceResolver.setDefaultViewSuffix(defaultViewSuffix);
        this.flowViewResolver = internalResourceResolver;
    }

    public void setViewResolvers(List viewResolvers) {
        this.flowViewResolver = new DelegatingFlowViewResolver(viewResolvers);
    }

    public void setFlowViewResolver(FlowViewResolver flowViewResolver) {
        this.flowViewResolver = flowViewResolver;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.environment = MvcEnvironment.environmentFor(applicationContext);
    }

    public ViewFactory createViewFactory(Expression viewId, ExpressionParser expressionParser, FormatterRegistry formatterRegistry) {
        if (this.environment == MvcEnvironment.SERVLET) {
            return new ServletMvcViewFactory(viewId, this.flowViewResolver, expressionParser, formatterRegistry);
        }
        if (this.environment == MvcEnvironment.PORTLET) {
            return new PortletMvcViewFactory(viewId, this.flowViewResolver, expressionParser, formatterRegistry);
        }
        throw new IllegalStateException("Web MVC Environment " + (Object)((Object)this.environment) + " not supported ");
    }

    public String getViewIdByConvention(String viewStateId) {
        return this.flowViewResolver.getViewIdByConvention(viewStateId);
    }
}

