/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.cmmn;

import egovframework.rte.fdl.cmmn.exception.EgovBizException;
import egovframework.rte.fdl.cmmn.trace.LeaveaTrace;
import java.util.Locale;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public abstract class EgovAbstractServiceImpl {
    protected Logger egovLogger = LoggerFactory.getLogger(EgovAbstractServiceImpl.class);
    @Resource(name="messageSource")
    private MessageSource messageSource;
    @Resource(name="leaveaTrace")
    private LeaveaTrace traceObj;

    protected Exception processException(String msgKey) {
        return this.processException(msgKey, new String[0]);
    }

    protected Exception processException(String msgKey, Exception e) {
        return this.processException(msgKey, new String[0], e);
    }

    protected Exception processException(String msgKey, String[] msgArgs) {
        return this.processException(msgKey, msgArgs, null);
    }

    protected Exception processException(String msgKey, String[] msgArgs, Exception e) {
        return this.processException(msgKey, msgArgs, e, LocaleContextHolder.getLocale());
    }

    protected Exception processException(String msgKey, String[] msgArgs, Exception e, Locale locale) {
        return this.processException(msgKey, msgArgs, e, locale, null);
    }

    protected Exception processException(final String msgKey, final String[] msgArgs, final Exception e, final Locale locale, ExceptionCreator exceptionCreator) {
        ExceptionCreator eC = null;
        if (exceptionCreator == null) {
            eC = new ExceptionCreator(){

                @Override
                public Exception createBizException(MessageSource messageSource) {
                    return new EgovBizException(messageSource, msgKey, (Object[])msgArgs, locale, e);
                }
            };
        }
        return eC.createBizException(this.messageSource);
    }

    protected void leaveaTrace(String msgKey) {
        this.leaveaTrace(msgKey, new String[0]);
    }

    protected void leaveaTrace(String msgKey, String[] msgArgs) {
        this.leaveaTrace(msgKey, msgArgs, null);
    }

    protected void leaveaTrace(String msgKey, String[] msgArgs, Locale locale) {
        this.traceObj.trace(this.getClass(), this.messageSource, msgKey, msgArgs, locale, this.egovLogger);
    }

    protected static interface ExceptionCreator {
        public Exception createBizException(MessageSource var1);
    }
}

