/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.util;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sf.jxls.parser.Cell;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.RowCollection;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFooter;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;

public final class Util {
    protected static Log log = LogFactory.getLog((Class)(class$net$sf$jxls$util$Util == null ? (class$net$sf$jxls$util$Util = Util.class$("net.sf.jxls.util.Util")) : class$net$sf$jxls$util$Util));
    private static final String[][] ENTITY_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}, {"apos", "39"}};
    private static Map xmlEntities = new HashMap();
    protected static final String regexCellRef = "[a-zA-Z]+[0-9]+";
    protected static final Pattern regexCellRefPattern;
    protected static final String regexCellCharPart = "[0-9]+";
    protected static final String regexCellDigitPart = "[a-zA-Z]+";
    protected static String cellRangeSeparator;
    static /* synthetic */ Class class$net$sf$jxls$util$Util;

    public static void removeRowCollectionPropertiesFromRow(RowCollection rowCollection) {
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        for (int i = 0; i <= rowCollection.getDependentRowNumber(); ++i) {
            HSSFRow hssfRow = sheet.getRow(startRow + i);
            for (int j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); ++j) {
                HSSFCell cell = hssfRow.getCell(j);
                Util.removeRowCollectionPropertyFromCell(cell, rowCollection.getCollectionProperty().getFullCollectionName());
            }
        }
    }

    private static void removeRowCollectionPropertyFromCell(HSSFCell cell, String collectionName) {
        String regex = "[-+*/().A-Za-z_0-9\\s]*";
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getRichStringCellValue().getString();
            String strToReplace = "\\$\\{" + regex + collectionName.replaceAll("\\.", "\\\\.") + "\\." + regex + "\\}";
            cell.setCellValue((RichTextString)new HSSFRichTextString(cellValue.replaceAll(strToReplace, "")));
        }
    }

    public static void removeMergedRegion(HSSFSheet sheet, CellRangeAddress region) {
        int index = Util.getMergedRegionIndex(sheet, region);
        if (index >= 0) {
            sheet.removeMergedRegion(index);
        }
    }

    private static int getMergedRegionIndex(HSSFSheet sheet, CellRangeAddress mergedRegion) {
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress region = Util.getMergedRegion(sheet, i);
            if (!Util.areRegionsEqual(region, mergedRegion)) continue;
            return i;
        }
        return -1;
    }

    public static boolean areRegionsEqual(CellRangeAddress region1, CellRangeAddress region2) {
        if (region1 == null && region2 != null || region1 != null && region2 == null) {
            return false;
        }
        if (region1 == null && region2 == null) {
            return true;
        }
        return region1.getFirstColumn() == region2.getFirstColumn() && region1.getLastColumn() == region2.getLastColumn() && region1.getFirstRow() == region2.getFirstRow() && region2.getLastRow() == region2.getLastRow();
    }

    private static CellRangeAddress getMergedRegion(HSSFSheet sheet, int i) {
        CellRangeAddress region = sheet.getMergedRegion(i);
        return region;
    }

    protected static boolean isNewMergedRegion(CellRangeAddress region, Collection mergedRegions) {
        Iterator iterator = mergedRegions.iterator();
        while (iterator.hasNext()) {
            CellRangeAddress cellRangeAddress = (CellRangeAddress)iterator.next();
            if (!Util.areRegionsEqual(cellRangeAddress, region)) continue;
            return false;
        }
        return true;
    }

    public static CellRangeAddress getMergedRegion(HSSFSheet sheet, int rowNum, int cellNum) {
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress merged = Util.getMergedRegion(sheet, i);
            if (!Util.isRangeContainsCell(merged, rowNum, cellNum)) continue;
            return merged;
        }
        return null;
    }

    public static boolean isRangeContainsCell(CellRangeAddress range, int row, int col) {
        return range.getFirstRow() <= row && range.getLastRow() >= row && range.getFirstColumn() <= col && range.getLastColumn() >= col;
    }

    public static boolean removeMergedRegion(HSSFSheet sheet, int rowNum, int cellNum) {
        TreeSet<Integer> mergedRegionNumbersToRemove = new TreeSet<Integer>();
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress merged = Util.getMergedRegion(sheet, i);
            if (!Util.isRangeContainsCell(merged, rowNum, cellNum)) continue;
            mergedRegionNumbersToRemove.add(new Integer(i));
        }
        Iterator iterator = mergedRegionNumbersToRemove.iterator();
        while (iterator.hasNext()) {
            Integer regionNumber = (Integer)iterator.next();
            sheet.removeMergedRegion(regionNumber.intValue());
        }
        return !mergedRegionNumbersToRemove.isEmpty();
    }

    public static void prepareCollectionPropertyInRowForDuplication(RowCollection rowCollection, String collectionItemName) {
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        for (int i = 0; i <= rowCollection.getDependentRowNumber(); ++i) {
            HSSFRow hssfRow = sheet.getRow(startRow + i);
            for (int j = hssfRow.getFirstCellNum(); j <= hssfRow.getLastCellNum(); ++j) {
                HSSFCell cell = hssfRow.getCell(j);
                Util.prepareCollectionPropertyInCellForDuplication(cell, rowCollection.getCollectionProperty().getFullCollectionName(), collectionItemName);
            }
        }
    }

    private static void prepareCollectionPropertyInCellForDuplication(HSSFCell cell, String collectionName, String collectionItemName) {
        if (cell != null && cell.getCellType() == 1) {
            String cellValue = cell.getRichStringCellValue().getString();
            String newValue = Util.replaceCollectionProperty(cellValue, collectionName, collectionItemName);
            cell.setCellValue((RichTextString)new HSSFRichTextString(newValue));
        }
    }

    private static String replaceCollectionProperty(String property, String collectionName, String newValue) {
        return property.replaceAll(collectionName, newValue);
    }

    public static void prepareCollectionPropertyInRowForContentDuplication(RowCollection rowCollection) {
        for (int i = 0; i < rowCollection.getCells().size(); ++i) {
            Cell cell = (Cell)rowCollection.getCells().get(i);
            Util.prepareCollectionPropertyInCellForDuplication(cell.getHssfCell(), rowCollection.getCollectionProperty().getFullCollectionName(), rowCollection.getCollectionItemName());
        }
    }

    public static void duplicateRowCollectionProperty(RowCollection rowCollection) {
        Collection collection = rowCollection.getCollectionProperty().getCollection();
        int rowNum = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFRow srcRow = rowCollection.getParentRow().getHssfRow();
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        if (collection.size() > 1) {
            for (int i = 1; i < collection.size(); ++i) {
                HSSFRow destRow = sheet.getRow(rowNum + i);
                for (int j = 0; j < rowCollection.getCells().size(); ++j) {
                    Cell cell = (Cell)rowCollection.getCells().get(j);
                    if (cell.isEmpty()) continue;
                    HSSFCell destCell = destRow.getCell(cell.getHssfCell().getColumnIndex());
                    if (destCell == null) {
                        destCell = destRow.createCell(cell.getHssfCell().getColumnIndex());
                    }
                    Util.copyCell(srcRow.getCell(cell.getHssfCell().getColumnIndex()), destCell, false);
                }
            }
        }
    }

    public static int duplicateRow(RowCollection rowCollection) {
        Collection collection = rowCollection.getCollectionProperty().getCollection();
        int row = rowCollection.getParentRow().getHssfRow().getRowNum();
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        if (collection.size() > 1) {
            if (rowCollection.getDependentRowNumber() == 0) {
                Util.shiftRows(sheet, row + 1, sheet.getLastRowNum(), collection.size() - 1);
                Util.duplicateStyle(rowCollection, row, row + 1, collection.size() - 1);
                Util.shiftUncoupledCellsUp(rowCollection);
            } else {
                for (int i = 0; i < collection.size() - 1; ++i) {
                    Util.shiftCopyRowCollection(rowCollection);
                }
                Util.shiftUncoupledCellsUp(rowCollection);
            }
        }
        return (collection.size() - 1) * (rowCollection.getDependentRowNumber() + 1);
    }

    private static void shiftCopyRowCollection(RowCollection rowCollection) {
        HSSFSheet hssfSheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        int startRow = rowCollection.getParentRow().getHssfRow().getRowNum();
        int num = rowCollection.getDependentRowNumber();
        Util.shiftRows(hssfSheet, startRow + num + 1, hssfSheet.getLastRowNum(), num + 1);
        Util.copyRowCollection(rowCollection);
    }

    private static void copyRowCollection(RowCollection rowCollection) {
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        int from = rowCollection.getParentRow().getHssfRow().getRowNum();
        int num = rowCollection.getDependentRowNumber() + 1;
        int to = from + num;
        HashSet<CellRangeAddress> mergedRegions = new HashSet<CellRangeAddress>();
        for (int i = from; i < from + num; ++i) {
            HSSFRow srcRow = sheet.getRow(i);
            HSSFRow destRow = sheet.getRow(to + i - from);
            if (destRow == null) {
                destRow = sheet.createRow(to + i - from);
            }
            if (srcRow.getHeight() >= 0) {
                destRow.setHeight(srcRow.getHeight());
            }
            for (int j = srcRow.getFirstCellNum(); j <= srcRow.getLastCellNum(); ++j) {
                CellRangeAddress newMergedRegion;
                HSSFCell srcCell = srcRow.getCell(j);
                if (srcCell == null) continue;
                HSSFCell destCell = destRow.createCell(j);
                Util.copyCell(srcCell, destCell, true);
                CellRangeAddress mergedRegion = Util.getMergedRegion(sheet, i, j);
                if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(to - from + mergedRegion.getFirstRow(), to - from + mergedRegion.getLastRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) continue;
                mergedRegions.add(newMergedRegion);
            }
        }
        Iterator iterator = mergedRegions.iterator();
        while (iterator.hasNext()) {
            CellRangeAddress region = (CellRangeAddress)iterator.next();
            sheet.addMergedRegion(region);
        }
    }

    private static void shiftUncoupledCellsUp(RowCollection rowCollection) {
        Row row = rowCollection.getParentRow();
        if (row.getCells().size() > rowCollection.getCells().size()) {
            for (int i = 0; i < row.getCells().size(); ++i) {
                Cell cell = (Cell)row.getCells().get(i);
                if (rowCollection.containsCell(cell)) continue;
                Util.shiftColumnUp(cell, row.getHssfRow().getRowNum() + rowCollection.getCollectionProperty().getCollection().size(), rowCollection.getCollectionProperty().getCollection().size() - 1);
            }
        }
    }

    private static void shiftColumnUp(Cell cell, int startRow, int shiftNumber) {
        int i;
        CellRangeAddress region;
        int i2;
        HSSFSheet sheet = cell.getRow().getSheet().getHssfSheet();
        int cellNum = cell.getHssfCell().getColumnIndex();
        ArrayList<CellRangeAddress> hssfMergedRegions = new ArrayList<CellRangeAddress>();
        for (i2 = startRow; i2 <= sheet.getLastRowNum(); ++i2) {
            region = Util.getMergedRegion(sheet, i2, cellNum);
            if (region == null || !Util.isNewMergedRegion(region, hssfMergedRegions)) continue;
            hssfMergedRegions.add(region);
        }
        for (i2 = startRow; i2 <= sheet.getLastRowNum(); ++i2) {
            if (sheet.getRow(i2).getCell(cellNum) == null) continue;
            HSSFCell destCell = sheet.getRow(i2 - shiftNumber).getCell(cellNum);
            if (destCell == null) {
                destCell = sheet.getRow(i2 - shiftNumber).createCell(cellNum);
            }
            Util.moveCell(sheet.getRow(i2).getCell(cellNum), destCell);
        }
        Iterator iterator = hssfMergedRegions.iterator();
        while (iterator.hasNext()) {
            Util.removeMergedRegion(sheet, (CellRangeAddress)iterator.next());
        }
        iterator = hssfMergedRegions.iterator();
        while (iterator.hasNext()) {
            region = (CellRangeAddress)iterator.next();
            CellRangeAddress newRegion = new CellRangeAddress(region.getFirstRow() - shiftNumber, region.getLastRow() - shiftNumber, region.getFirstColumn(), region.getLastColumn());
            sheet.addMergedRegion(newRegion);
        }
        for (i = sheet.getLastRowNum(); sheet.getRow(i).getCell(cellNum) == null && i >= startRow; --i) {
        }
        for (int j = 0; j < shiftNumber && i >= startRow; ++j, --i) {
            if (sheet.getRow(i).getCell(cellNum) == null) continue;
            sheet.getRow(i).removeCell((org.apache.poi.ss.usermodel.Cell)sheet.getRow(i).getCell(cellNum));
        }
    }

    private static void moveCell(HSSFCell srcCell, HSSFCell destCell) {
        destCell.setCellStyle(srcCell.getCellStyle());
        switch (srcCell.getCellType()) {
            case 1: {
                destCell.setCellValue((RichTextString)srcCell.getRichStringCellValue());
                break;
            }
            case 0: {
                destCell.setCellValue(srcCell.getNumericCellValue());
                break;
            }
            case 3: {
                destCell.setCellType(3);
                break;
            }
            case 4: {
                destCell.setCellValue(srcCell.getBooleanCellValue());
                break;
            }
            case 5: {
                destCell.setCellErrorValue(srcCell.getErrorCellValue());
                break;
            }
            case 2: {
                break;
            }
        }
        srcCell.setCellType(3);
    }

    private static void duplicateStyle(RowCollection rowCollection, int rowToCopy, int startRow, int num) {
        HSSFSheet sheet = rowCollection.getParentRow().getSheet().getHssfSheet();
        HashSet<CellRangeAddress> mergedRegions = new HashSet<CellRangeAddress>();
        HSSFRow srcRow = sheet.getRow(rowToCopy);
        for (int i = startRow; i < startRow + num; ++i) {
            HSSFRow destRow = sheet.getRow(i);
            if (destRow == null) {
                destRow = sheet.createRow(i);
            }
            if (srcRow.getHeight() >= 0) {
                destRow.setHeight(srcRow.getHeight());
            }
            for (int j = 0; j < rowCollection.getCells().size(); ++j) {
                CellRangeAddress newMergedRegion;
                Cell cell = (Cell)rowCollection.getCells().get(j);
                HSSFCell hssfCell = cell.getHssfCell();
                if (hssfCell == null) continue;
                HSSFCell newCell = destRow.createCell(hssfCell.getColumnIndex());
                Util.copyCell(hssfCell, newCell, true);
                CellRangeAddress mergedRegion = Util.getMergedRegion(sheet, rowToCopy, hssfCell.getColumnIndex());
                if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(i, i + mergedRegion.getLastRow() - mergedRegion.getFirstRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) continue;
                mergedRegions.add(newMergedRegion);
                sheet.addMergedRegion(newMergedRegion);
            }
        }
    }

    public static void copyRow(HSSFSheet sheet, HSSFRow oldRow, HSSFRow newRow) {
        HashSet<CellRangeAddress> mergedRegions = new HashSet<CellRangeAddress>();
        if (oldRow.getHeight() >= 0) {
            newRow.setHeight(oldRow.getHeight());
        }
        for (int j = oldRow.getFirstCellNum(); j <= oldRow.getLastCellNum(); ++j) {
            CellRangeAddress newMergedRegion;
            HSSFCell oldCell = oldRow.getCell(j);
            HSSFCell newCell = newRow.getCell(j);
            if (oldCell == null) continue;
            if (newCell == null) {
                newCell = newRow.createCell(j);
            }
            Util.copyCell(oldCell, newCell, true);
            CellRangeAddress mergedRegion = Util.getMergedRegion(sheet, oldRow.getRowNum(), oldCell.getColumnIndex());
            if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(newRow.getRowNum(), newRow.getRowNum() + mergedRegion.getLastRow() - mergedRegion.getFirstRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) continue;
            mergedRegions.add(newMergedRegion);
            sheet.addMergedRegion(newMergedRegion);
        }
    }

    public static void copyRow(HSSFSheet srcSheet, HSSFSheet destSheet, HSSFRow srcRow, HSSFRow destRow) {
        TreeSet<CellRangeAddress> mergedRegions = new TreeSet<CellRangeAddress>();
        if (srcRow.getHeight() >= 0) {
            destRow.setHeight(srcRow.getHeight());
        }
        for (int j = srcRow.getFirstCellNum(); j <= srcRow.getLastCellNum(); ++j) {
            CellRangeAddress newMergedRegion;
            HSSFCell oldCell = srcRow.getCell(j);
            HSSFCell newCell = destRow.getCell(j);
            if (oldCell == null) continue;
            if (newCell == null) {
                newCell = destRow.createCell(j);
            }
            Util.copyCell(oldCell, newCell, true);
            CellRangeAddress mergedRegion = Util.getMergedRegion(srcSheet, srcRow.getRowNum(), oldCell.getColumnIndex());
            if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(mergedRegion.getFirstRow(), mergedRegion.getLastRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) continue;
            mergedRegions.add(newMergedRegion);
            destSheet.addMergedRegion(newMergedRegion);
        }
    }

    public static void copyRow(HSSFSheet srcSheet, HSSFSheet destSheet, HSSFRow srcRow, HSSFRow destRow, String expressionToReplace, String expressionReplacement) {
        HashSet<CellRangeAddress> mergedRegions = new HashSet<CellRangeAddress>();
        if (srcRow.getHeight() >= 0) {
            destRow.setHeight(srcRow.getHeight());
        }
        for (int j = srcRow.getFirstCellNum(); j <= srcRow.getLastCellNum(); ++j) {
            CellRangeAddress newMergedRegion;
            HSSFCell oldCell = srcRow.getCell(j);
            HSSFCell newCell = destRow.getCell(j);
            if (oldCell == null) continue;
            if (newCell == null) {
                newCell = destRow.createCell(j);
            }
            Util.copyCell(oldCell, newCell, true, expressionToReplace, expressionReplacement);
            CellRangeAddress mergedRegion = Util.getMergedRegion(srcSheet, srcRow.getRowNum(), oldCell.getColumnIndex());
            if (mergedRegion == null || !Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(mergedRegion.getFirstRow(), mergedRegion.getLastRow(), mergedRegion.getFirstColumn(), mergedRegion.getLastColumn()), mergedRegions)) continue;
            mergedRegions.add(newMergedRegion);
            destSheet.addMergedRegion(newMergedRegion);
        }
    }

    public static void copySheets(HSSFSheet newSheet, HSSFSheet sheet) {
        int i;
        int maxColumnNum = 0;
        for (i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            HSSFRow srcRow = sheet.getRow(i);
            HSSFRow destRow = newSheet.createRow(i);
            if (srcRow == null) continue;
            Util.copyRow(sheet, newSheet, srcRow, destRow);
            if (srcRow.getLastCellNum() <= maxColumnNum) continue;
            maxColumnNum = srcRow.getLastCellNum();
        }
        for (i = 0; i <= maxColumnNum; ++i) {
            newSheet.setColumnWidth(i, sheet.getColumnWidth(i));
        }
    }

    public static void copySheets(HSSFSheet newSheet, HSSFSheet sheet, String expressionToReplace, String expressionReplacement) {
        int i;
        int maxColumnNum = 0;
        for (i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
            HSSFRow srcRow = sheet.getRow(i);
            HSSFRow destRow = newSheet.createRow(i);
            if (srcRow == null) continue;
            Util.copyRow(sheet, newSheet, srcRow, destRow, expressionToReplace, expressionReplacement);
            if (srcRow.getLastCellNum() <= maxColumnNum) continue;
            maxColumnNum = srcRow.getLastCellNum();
        }
        for (i = 0; i <= maxColumnNum; ++i) {
            newSheet.setColumnWidth(i, sheet.getColumnWidth(i));
        }
    }

    public static void copyCell(HSSFCell oldCell, HSSFCell newCell, boolean copyStyle) {
        if (copyStyle) {
            newCell.setCellStyle(oldCell.getCellStyle());
        }
        switch (oldCell.getCellType()) {
            case 1: {
                newCell.setCellValue((RichTextString)oldCell.getRichStringCellValue());
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case 2: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
        }
    }

    public static void copyCell(HSSFCell oldCell, HSSFCell newCell, boolean copyStyle, String expressionToReplace, String expressionReplacement) {
        if (copyStyle) {
            newCell.setCellStyle(oldCell.getCellStyle());
        }
        switch (oldCell.getCellType()) {
            case 1: {
                String oldValue = oldCell.getRichStringCellValue().getString();
                newCell.setCellValue((RichTextString)new HSSFRichTextString(oldValue.replaceAll(expressionToReplace, expressionReplacement)));
                break;
            }
            case 0: {
                newCell.setCellValue(oldCell.getNumericCellValue());
                break;
            }
            case 3: {
                newCell.setCellType(3);
                break;
            }
            case 4: {
                newCell.setCellValue(oldCell.getBooleanCellValue());
                break;
            }
            case 5: {
                newCell.setCellErrorValue(oldCell.getErrorCellValue());
                break;
            }
            case 2: {
                newCell.setCellFormula(oldCell.getCellFormula());
                break;
            }
        }
    }

    public static Object getProperty(Object bean, String propertyName) {
        Object value = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("getting property=" + propertyName + " for bean=" + bean.getClass().getName()));
            }
            value = PropertyUtils.getProperty((Object)bean, (String)propertyName);
        }
        catch (IllegalAccessException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.warn((Object)("Can't get property " + propertyName + " in the bean " + bean), (Throwable)e);
        }
        return value;
    }

    public static void writeToFile(String fileName, HSSFWorkbook workbook) {
        try {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(fileName));
            workbook.write((OutputStream)os);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static HSSFCellStyle duplicateStyle(HSSFWorkbook workbook, HSSFCellStyle style) {
        HSSFCellStyle newStyle = workbook.createCellStyle();
        newStyle.setAlignment(style.getAlignment());
        newStyle.setBorderBottom(style.getBorderBottom());
        newStyle.setBorderLeft(style.getBorderLeft());
        newStyle.setBorderRight(style.getBorderRight());
        newStyle.setBorderTop(style.getBorderTop());
        newStyle.setBottomBorderColor(style.getBottomBorderColor());
        newStyle.setDataFormat(style.getDataFormat());
        newStyle.setFillBackgroundColor(style.getFillBackgroundColor());
        newStyle.setFillForegroundColor(style.getFillForegroundColor());
        newStyle.setFillPattern(style.getFillPattern());
        newStyle.setFont(workbook.getFontAt(style.getFontIndex()));
        newStyle.setHidden(style.getHidden());
        newStyle.setIndention(style.getIndention());
        newStyle.setLeftBorderColor(style.getLeftBorderColor());
        newStyle.setLocked(style.getLocked());
        newStyle.setRightBorderColor(style.getRightBorderColor());
        newStyle.setTopBorderColor(style.getTopBorderColor());
        newStyle.setVerticalAlignment(style.getVerticalAlignment());
        newStyle.setWrapText(style.getWrapText());
        return newStyle;
    }

    public static String escapeAttributes(String tag) {
        if (tag == null) {
            return tag;
        }
        StringBuffer sb = new StringBuffer("");
        StringBuffer attrValue = new StringBuffer("");
        int expressionClosingSymbol = 125;
        int expressionStartSymbol = 123;
        boolean isAttrValue = false;
        int exprCount = 0;
        for (int i = 0; i < tag.length(); ++i) {
            if (!isAttrValue) {
                sb.append(tag.charAt(i));
                if (tag.charAt(i) != '\"') continue;
                isAttrValue = true;
                attrValue = new StringBuffer("");
                continue;
            }
            if (tag.charAt(i) == '\"') {
                if (exprCount != 0) {
                    attrValue.append(tag.charAt(i));
                    continue;
                }
                sb.append(Util.escapeXml(attrValue.toString()));
                sb.append(tag.charAt(i));
                isAttrValue = false;
                continue;
            }
            attrValue.append(tag.charAt(i));
            if (tag.charAt(i) == '}') {
                --exprCount;
                continue;
            }
            if (tag.charAt(i) != '{') continue;
            ++exprCount;
        }
        if (isAttrValue) {
            log.warn((Object)("Can't parse ambiguous quot in " + tag));
        }
        return sb.toString();
    }

    private static String escapeXml(String str) {
        if (str == null) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entityName = Util.getEntityName(ch);
            if (entityName == null) {
                if (ch > '\u007f') {
                    buf.append("&#");
                    buf.append((int)ch);
                    buf.append(';');
                    continue;
                }
                buf.append(ch);
                continue;
            }
            buf.append('&');
            buf.append(entityName);
            buf.append(';');
        }
        return buf.toString();
    }

    private static String getEntityName(char ch) {
        return (String)xmlEntities.get(Integer.toString(ch));
    }

    protected static void updateMergedRegionInRow(HSSFSheet sheet, Set mergedRegions, int rowNum, int cellNum, int destCellNum, boolean removeSourceMergedRegion) {
        CellRangeAddress newMergedRegion;
        CellRangeAddress mergedRegion = Util.getMergedRegion(sheet, rowNum, cellNum);
        if (mergedRegion != null && Util.isNewMergedRegion(mergedRegion, mergedRegions) && Util.isNewMergedRegion(newMergedRegion = new CellRangeAddress(mergedRegion.getFirstRow(), mergedRegion.getLastRow(), mergedRegion.getFirstColumn() + destCellNum - cellNum, mergedRegion.getLastColumn() + destCellNum - cellNum), mergedRegions)) {
            mergedRegions.add(newMergedRegion);
            sheet.addMergedRegion(newMergedRegion);
            if (removeSourceMergedRegion) {
                Util.removeMergedRegion(sheet, mergedRegion);
            }
        }
    }

    public static void shiftCellsLeft(HSSFSheet sheet, int startRow, int startCol, int endRow, int endCol, int shiftNumber, boolean removeSourceMergedRegion) {
        HashSet mergedRegions = new HashSet();
        for (int rowNum = startRow; rowNum <= endRow; ++rowNum) {
            boolean doSetWidth = true;
            HSSFRow row = sheet.getRow(rowNum);
            if (row == null) continue;
            for (int colNum = startCol; colNum <= endCol; ++colNum) {
                int destColNum;
                HSSFCell destCell;
                HSSFCell cell = row.getCell(colNum);
                if (cell == null) {
                    cell = row.createCell(colNum);
                    doSetWidth = false;
                }
                if ((destCell = row.getCell(destColNum = colNum - shiftNumber)) == null) {
                    destCell = row.createCell(destColNum);
                }
                Util.copyCell(cell, destCell, true);
                Util.updateMergedRegionInRow(sheet, mergedRegions, rowNum, colNum, destColNum, removeSourceMergedRegion);
                if (!doSetWidth) continue;
                sheet.setColumnWidth(destCell.getColumnIndex(), Util.getWidth(sheet, cell.getColumnIndex()));
            }
        }
    }

    static int getWidth(HSSFSheet sheet, int col) {
        int width = sheet.getColumnWidth(col);
        if (width == sheet.getDefaultColumnWidth()) {
            width *= 256;
        }
        return width;
    }

    public static void shiftCellsRight(HSSFSheet sheet, int startRow, int endRow, int startCol, int shiftNumber, boolean removeSourceMergedRegion) {
        HashSet mergedRegions = new HashSet();
        for (int rowNum = startRow; rowNum <= endRow; ++rowNum) {
            int lastCellNum;
            HSSFRow row = sheet.getRow(rowNum);
            if (row == null) continue;
            for (int colNum = lastCellNum = row.getLastCellNum(); colNum >= startCol; --colNum) {
                HSSFCell cell;
                int destColNum = colNum + shiftNumber;
                HSSFCell destCell = row.getCell(destColNum);
                if (destCell == null) {
                    destCell = row.createCell(destColNum);
                }
                if ((cell = row.getCell(colNum)) == null) {
                    cell = row.createCell(colNum);
                }
                Util.copyCell(cell, destCell, true);
                Util.updateMergedRegionInRow(sheet, mergedRegions, rowNum, colNum, destColNum, removeSourceMergedRegion);
            }
        }
    }

    public static void updateCellValue(HSSFSheet sheet, int rowNum, int colNum, String cellValue) {
        HSSFRow hssfRow = sheet.getRow(rowNum);
        HSSFCell hssfCell = hssfRow.getCell(colNum);
        hssfCell.setCellValue((RichTextString)new HSSFRichTextString(cellValue));
    }

    public static void copyPageSetup(HSSFSheet destSheet, HSSFSheet srcSheet) {
        HSSFHeader header = srcSheet.getHeader();
        HSSFFooter footer = srcSheet.getFooter();
        if (footer != null) {
            destSheet.getFooter().setLeft(footer.getLeft());
            destSheet.getFooter().setCenter(footer.getCenter());
            destSheet.getFooter().setRight(footer.getRight());
        }
        if (header != null) {
            destSheet.getHeader().setLeft(header.getLeft());
            destSheet.getHeader().setCenter(header.getCenter());
            destSheet.getHeader().setRight(header.getRight());
        }
    }

    public static void copyPrintSetup(HSSFSheet destSheet, HSSFSheet srcSheet) {
        HSSFPrintSetup setup = srcSheet.getPrintSetup();
        if (setup != null) {
            destSheet.getPrintSetup().setLandscape(setup.getLandscape());
            destSheet.getPrintSetup().setPaperSize(setup.getPaperSize());
            destSheet.getPrintSetup().setScale(setup.getScale());
            destSheet.getPrintSetup().setFitWidth(setup.getFitWidth());
            destSheet.getPrintSetup().setFitHeight(setup.getFitHeight());
            destSheet.getPrintSetup().setFooterMargin(setup.getFooterMargin());
            destSheet.getPrintSetup().setHeaderMargin(setup.getHeaderMargin());
            destSheet.getPrintSetup().setPaperSize(setup.getPaperSize());
            destSheet.getPrintSetup().setPageStart(setup.getPageStart());
        }
    }

    public static void setPrintArea(HSSFWorkbook resultWorkbook, int sheetNum) {
        int maxColumnNum = 0;
        for (int j = resultWorkbook.getSheetAt(sheetNum).getFirstRowNum(); j <= resultWorkbook.getSheetAt(sheetNum).getLastRowNum(); ++j) {
            HSSFRow row = resultWorkbook.getSheetAt(sheetNum).getRow(j);
            if (row == null) continue;
            maxColumnNum = row.getLastCellNum();
        }
        resultWorkbook.setPrintArea(sheetNum, 0, maxColumnNum, 0, resultWorkbook.getSheetAt(sheetNum).getLastRowNum());
    }

    public static boolean isColumnRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isColumnRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellCharPart = firstCell.split(regexCellCharPart)[0];
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            int cellNumber = Integer.parseInt(firstCellDigitPart);
            for (int i = 1; i < cells.size() && isColumnRange; ++i) {
                String nextCell = (String)cells.get(i);
                String cellCharPart = nextCell.split(regexCellCharPart)[0];
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                if (firstCellCharPart.equalsIgnoreCase(cellCharPart) && Integer.parseInt(cellDigitPart) == ++cellNumber) continue;
                isColumnRange = false;
            }
        }
        return isColumnRange;
    }

    public static boolean isRowRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isRowRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            CellReference cellRef = new CellReference(firstCell);
            int cellNumber = cellRef.getCol();
            for (int i = 1; i < cells.size() && isRowRange; ++i) {
                String nextCell = (String)cells.get(i);
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                cellRef = new CellReference(nextCell);
                if (firstCellDigitPart.equalsIgnoreCase(cellDigitPart) && cellRef.getCol() == ++cellNumber) continue;
                isRowRange = false;
            }
        }
        return isRowRange;
    }

    public static String buildCommaSeparatedListOfCells(String refSheetName, List cells) {
        String listOfCells = "";
        for (int i = 0; i < cells.size() - 1; ++i) {
            String cell = (String)cells.get(i);
            listOfCells = listOfCells + Util.getRefCellName(refSheetName, cell) + ",";
        }
        listOfCells = listOfCells + Util.getRefCellName(refSheetName, (String)cells.get(cells.size() - 1));
        return listOfCells;
    }

    public static String detectCellRange(String refSheetName, List cells) {
        String firstCell;
        if (cells == null || cells.isEmpty()) {
            return "";
        }
        String range = firstCell = (String)cells.get(0);
        if (firstCell != null && firstCell.length() > 0) {
            if (Util.isRowRange(cells) || Util.isColumnRange(cells)) {
                String lastCell = (String)cells.get(cells.size() - 1);
                range = Util.getRefCellName(refSheetName, firstCell) + cellRangeSeparator + lastCell.toUpperCase();
            } else {
                range = Util.buildCommaSeparatedListOfCells(refSheetName, cells);
            }
        }
        return range;
    }

    public static String getRefCellName(String refSheetName, String cellName) {
        if (refSheetName == null) {
            return cellName.toUpperCase();
        }
        return refSheetName + "!" + cellName.toUpperCase();
    }

    public static void shiftRows(HSSFSheet sheet, int startRow, int endRow, int shiftNum) {
        if (startRow <= endRow) {
            short[] rowHeights = Util.getRowHeights(sheet, startRow, endRow);
            sheet.shiftRows(startRow, endRow, shiftNum, false, false);
            Util.copyPositiveRowHeight(sheet, startRow, endRow, shiftNum, rowHeights);
        }
    }

    private static short[] getRowHeights(HSSFSheet sheet, int startRow, int endRow) {
        if (endRow - startRow + 1 < 0) {
            return new short[0];
        }
        short[] rowHeights = new short[endRow - startRow + 1];
        for (int i = startRow; i <= endRow; ++i) {
            HSSFRow row = sheet.getRow(i);
            rowHeights[i - startRow] = row != null ? row.getHeight() : (short)-1;
        }
        return rowHeights;
    }

    static void copyPositiveRowHeight(HSSFSheet sheet, int startRow, int endRow, int shiftNum, short[] rowHeights) {
        for (int i = startRow; i <= endRow; ++i) {
            HSSFRow destRow = sheet.getRow(i + shiftNum);
            if (destRow == null || rowHeights[i - startRow] < 0) continue;
            destRow.setHeight(rowHeights[i - startRow]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < ENTITY_ARRAY.length; ++i) {
            xmlEntities.put(ENTITY_ARRAY[i][1], ENTITY_ARRAY[i][0]);
        }
        regexCellRefPattern = Pattern.compile(regexCellRef);
        cellRangeSeparator = ":";
    }
}

