/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.nt;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class NTEventLogAppender
extends AppenderSkeleton {
    private static final int FATAL = Level.FATAL.toInt();
    private static final int ERROR = Level.ERROR.toInt();
    private static final int WARN = Level.WARN.toInt();
    private static final int INFO = Level.INFO.toInt();
    private static final int DEBUG = Level.DEBUG.toInt();
    private int _handle = 0;
    private boolean dirty = true;
    private String source = null;
    private String server = null;

    public NTEventLogAppender() {
        this(null, null, null);
    }

    public NTEventLogAppender(String source) {
        this(null, source, null);
    }

    public NTEventLogAppender(String server, String source) {
        this(server, source, null);
    }

    public NTEventLogAppender(Layout layout) {
        this(null, null, layout);
    }

    public NTEventLogAppender(String source, Layout layout) {
        this(null, source, layout);
    }

    public NTEventLogAppender(String server, String source, Layout layout) {
        super(false);
        this.server = server;
        if (source == null) {
            this.source = "Log4j";
        }
        this.layout = layout == null ? new PatternLayout("%d [%t] %p %c %x %m%n") : layout;
        this.activateOptions();
    }

    public void close() {
    }

    public void activateOptions() {
        if (this.dirty && this.source != null) {
            this.dirty = false;
            if (this._handle != 0) {
                try {
                    this.deregisterEventSource(this._handle);
                }
                catch (Exception e) {
                    this.getLogger().error((Object)"Could not deregister event source.", e);
                }
            }
            try {
                this._handle = this.registerEventSource(this.server, this.source);
                super.activateOptions();
            }
            catch (Exception e) {
                this.getLogger().error((Object)"Could not register event source.", e);
                this._handle = 0;
            }
        }
    }

    public void append(LoggingEvent event) {
        String[] s;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            int len = s.length;
            int i = 0;
            while (i < len) {
                sbuf.append(s[i]);
                ++i;
            }
        }
        int nt_category = event.getLevel().toInt();
        this.reportEvent(this._handle, sbuf.toString(), nt_category);
    }

    public void finalize() {
        this.deregisterEventSource(this._handle);
        this._handle = 0;
    }

    public void setSource(String source) {
        this.source = source.trim();
        this.dirty = true;
    }

    public String getSource() {
        return this.source;
    }

    public boolean requiresLayout() {
        return true;
    }

    private native int registerEventSource(String var1, String var2);

    private native void reportEvent(int var1, String var2, int var3);

    private native void deregisterEventSource(int var1);

    static {
        System.loadLibrary("NTEventLogAppender");
    }
}

