/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Stack;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class LikeRule
extends AbstractRule {
    static final long serialVersionUID = -3375458885595683156L;
    private static final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private transient Pattern pattern;
    private transient Perl5Matcher matcher = new Perl5Matcher();
    private transient String field;

    private LikeRule(String field, Pattern pattern) {
        if (!resolver.isField(field)) {
            throw new IllegalArgumentException("Invalid LIKE rule - " + field + " is not a supported field");
        }
        this.field = field;
        this.pattern = pattern;
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid LIKE rule - expected two parameters but received " + stack.size());
        }
        String p2 = stack.pop().toString();
        String p1 = stack.pop().toString();
        return LikeRule.getRule(p1, p2);
    }

    public static Rule getRule(String field, String pattern) {
        Perl5Compiler compiler = new Perl5Compiler();
        Pattern pattern1 = null;
        try {
            pattern1 = compiler.compile(pattern, 1);
        }
        catch (MalformedPatternException e) {
            throw new IllegalArgumentException("Invalid LIKE rule - " + e.getMessage());
        }
        return new LikeRule(field, pattern1);
    }

    public boolean evaluate(LoggingEvent event) {
        Object input = resolver.getValue(this.field, event);
        return input != null && this.pattern != null && this.matcher.matches(input.toString(), this.pattern);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.field = (String)in.readObject();
            String patternString = (String)in.readObject();
            Perl5Compiler compiler = new Perl5Compiler();
            this.matcher = new Perl5Matcher();
            this.pattern = compiler.compile(patternString, 1);
        }
        catch (MalformedPatternException e) {
            throw new IOException("Invalid LIKE rule - " + e.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.field);
        out.writeObject(this.pattern.getPattern());
    }
}

