/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.formula;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.formula.FormulaPart;
import org.apache.poi.hssf.util.CellReference;

public class CellRef {
    protected static String leftReplacementMarker = "{";
    protected static String rightReplacementMarker = "}";
    protected static String regexReplacementMarker = "\\" + leftReplacementMarker + "[(),a-zA-Z0-9_ :*+/.-]+" + "\\" + rightReplacementMarker;
    protected static final String regexCellCharPart = "[0-9]+";
    protected static final String regexCellDigitPart = "[a-zA-Z]+";
    String cellRef;
    String baseCellRef;
    FormulaPart parentFormula;
    int rowNum;
    short colNum;
    String sheetName;
    Integer cellIndex;
    List rangeFormulaParts = new ArrayList();
    protected String cellRangeSeparator = ":";

    private CellRef(String cellRef) {
        this.cellRef = cellRef;
        this.baseCellRef = cellRef;
        CellReference cellReference = new CellReference(cellRef);
        this.rowNum = cellReference.getRow();
        this.colNum = cellReference.getCol();
        this.sheetName = cellReference.getSheetName();
    }

    public CellRef(String cellRef, FormulaPart parentFormula) {
        this(cellRef);
        this.parentFormula = parentFormula;
    }

    public String getSheetName() {
        String name = this.sheetName;
        if (this.sheetName != null && this.sheetName.indexOf(32) >= 0) {
            name = "'" + this.sheetName + "'";
        }
        return name;
    }

    public int getRowNum() {
        return this.rowNum;
    }

    public short getColNum() {
        return this.colNum;
    }

    public Integer getCellIndex() {
        return this.cellIndex;
    }

    public void setCellIndex(Integer cellIndex) {
        this.cellIndex = cellIndex;
    }

    public void update(String newCellRef) {
        this.cellRef = newCellRef;
        CellReference cellReference = new CellReference(this.cellRef);
        this.rowNum = cellReference.getRow();
        this.colNum = cellReference.getCol();
        this.sheetName = cellReference.getSheetName();
    }

    public void update(List newCellRefs) {
        String refSheetName = this.extractRefSheetName(this.cellRef);
        String newCell = this.detectCellRange(refSheetName, newCellRefs);
        if (!this.rangeFormulaParts.isEmpty()) {
            this.parentFormula.replaceCellRef(this, this.rangeFormulaParts);
        } else {
            this.update(newCell);
        }
    }

    boolean containsSheetRef() {
        return this.cellRef != null && this.cellRef.indexOf("!") >= 0;
    }

    String detectCellRange(String refSheetName, List cells) {
        String firstCell;
        this.rangeFormulaParts.clear();
        this.cutSheetRefFromCells(cells);
        String range = firstCell = (String)cells.get(0);
        if (firstCell != null && firstCell.length() > 0) {
            if (this.isRowRange(cells) || this.isColumnRange(cells)) {
                String lastCell = (String)cells.get(cells.size() - 1);
                String refCellName = this.getRefCellName(refSheetName, firstCell);
                range = refCellName + this.cellRangeSeparator + lastCell.toUpperCase();
                this.rangeFormulaParts.add(new CellRef(refCellName, this.parentFormula));
                this.rangeFormulaParts.add(this.cellRangeSeparator);
                CellRef lastCellRef = new CellRef(lastCell.toUpperCase(), this.parentFormula);
                lastCellRef.sheetName = refSheetName;
                this.rangeFormulaParts.add(lastCellRef);
            } else {
                range = this.buildCommaSeparatedListOfCells(refSheetName, cells);
            }
        }
        return range;
    }

    private void cutSheetRefFromCells(List cells) {
        for (int i = 0; i < cells.size(); ++i) {
            String cell = (String)cells.get(i);
            cells.set(i, this.extractCellName(cell));
        }
    }

    String buildCommaSeparatedListOfCells(String refSheetName, List cells) {
        String listOfCells = "";
        for (int i = 0; i < cells.size() - 1; ++i) {
            String cell = (String)cells.get(i);
            String refCellName = this.getRefCellName(refSheetName, cell);
            listOfCells = listOfCells + refCellName + ",";
            this.rangeFormulaParts.add(new CellRef(refCellName, this.parentFormula));
            this.rangeFormulaParts.add(",");
        }
        String refCellName = this.getRefCellName(refSheetName, (String)cells.get(cells.size() - 1));
        listOfCells = listOfCells + refCellName;
        this.rangeFormulaParts.add(new CellRef(refCellName, this.parentFormula));
        return listOfCells;
    }

    String getRefCellName(String refSheetName, String cellName) {
        if (refSheetName == null) {
            return cellName.toUpperCase();
        }
        return refSheetName + "!" + cellName.toUpperCase();
    }

    boolean isColumnRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isColumnRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellCharPart = firstCell.split(regexCellCharPart)[0];
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            int cellNumber = Integer.parseInt(firstCellDigitPart);
            for (int i = 1; i < cells.size() && isColumnRange; ++i) {
                String nextCell = (String)cells.get(i);
                String cellCharPart = nextCell.split(regexCellCharPart)[0];
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                if (firstCellCharPart.equalsIgnoreCase(cellCharPart) && Integer.parseInt(cellDigitPart) == ++cellNumber) continue;
                isColumnRange = false;
            }
        }
        return isColumnRange;
    }

    boolean isRowRange(List cells) {
        String firstCell = (String)cells.get(0);
        boolean isRowRange = true;
        if (firstCell != null && firstCell.length() > 0) {
            String firstCellDigitPart = firstCell.split(regexCellDigitPart)[1];
            CellReference cellReference = new CellReference(firstCell);
            int cellNumber = cellReference.getCol();
            for (int i = 1; i < cells.size() && isRowRange; ++i) {
                String nextCell = (String)cells.get(i);
                String cellDigitPart = nextCell.split(regexCellDigitPart)[1];
                cellReference = new CellReference(nextCell);
                if (firstCellDigitPart.equalsIgnoreCase(cellDigitPart) && cellReference.getCol() == ++cellNumber) continue;
                isRowRange = false;
            }
        }
        return isRowRange;
    }

    private String extractRefSheetName(String refCell) {
        if (refCell != null) {
            if (refCell.indexOf("!") < 0) {
                return null;
            }
            return refCell.substring(0, refCell.indexOf("!"));
        }
        return null;
    }

    private String extractCellName(String refCell) {
        if (refCell != null) {
            if (refCell.indexOf("!") < 0) {
                return refCell;
            }
            return refCell.substring(refCell.indexOf("!") + 1);
        }
        return null;
    }

    public static String replaceFormulaPart(String formulaPart, String refCell, String newCell) {
        String replacedFormulaPart = "";
        String[] parts = formulaPart.split(regexReplacementMarker, 2);
        while (parts.length == 2) {
            replacedFormulaPart = replacedFormulaPart + parts[0].replaceAll(refCell, leftReplacementMarker + newCell + rightReplacementMarker);
            int secondPartIndex = parts[1].length() != 0 ? formulaPart.indexOf(parts[1], parts[0].length()) : formulaPart.length();
            replacedFormulaPart = replacedFormulaPart + formulaPart.substring(parts[0].length(), secondPartIndex);
            formulaPart = parts[1];
            parts = formulaPart.split(regexReplacementMarker, 2);
        }
        replacedFormulaPart = replacedFormulaPart + parts[0].replaceAll(refCell, leftReplacementMarker + newCell + rightReplacementMarker);
        return replacedFormulaPart;
    }

    public String toString() {
        return this.cellRef;
    }
}

