/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.js.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class ResourceServlet
extends HttpServlet {
    private static final String HTTP_CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String HTTP_LAST_MODIFIED_HEADER = "Last-Modified";
    private static final String HTTP_EXPIRES_HEADER = "Expires";
    private static final String HTTP_CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String GZIP_ENABLED_PARAM = "gzipEnabled";
    private static final Log log;
    private final String protectedPath = "/?WEB-INF/.*";
    private boolean gzipEnabled = true;
    private Map defaultMimeTypes = new HashMap();
    private Set compressedMimeTypes;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.springframework.js.resource.ResourceServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public ResourceServlet() {
        this.defaultMimeTypes.put(".css", "text/css");
        this.defaultMimeTypes.put(".gif", "image/gif");
        this.defaultMimeTypes.put(".ico", "image/vnd.microsoft.icon");
        this.defaultMimeTypes.put(".jpeg", "image/jpeg");
        this.defaultMimeTypes.put(".jpg", "image/jpeg");
        this.defaultMimeTypes.put(".js", "text/javascript");
        this.defaultMimeTypes.put(".png", "image/png");
        this.compressedMimeTypes = new HashSet();
        this.compressedMimeTypes.add("text/css");
        this.compressedMimeTypes.add("text/javascript");
    }

    public void init() throws ServletException {
        String gzipEnabledParamValue = this.getServletConfig().getInitParameter(GZIP_ENABLED_PARAM);
        if (StringUtils.hasText((String)gzipEnabledParamValue)) {
            this.gzipEnabled = Boolean.valueOf(gzipEnabledParamValue);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        URL[] resources;
        String rawResourcePath = request.getPathInfo();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to GET resource: " + rawResourcePath));
        }
        if ((resources = this.getRequestResourceURLs(request)) == null || resources.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resource not found: " + rawResourcePath));
            }
            response.setStatus(404);
            return;
        }
        this.prepareResponse(response, resources, rawResourcePath);
        OutputStream out = this.selectOutputStream(request, response);
        try {
            int i = 0;
            while (i < resources.length) {
                Object var11_11;
                URLConnection resourceConn = resources[i].openConnection();
                InputStream in = resourceConn.getInputStream();
                try {
                    byte[] buffer = new byte[1024];
                    while (in.available() > 0) {
                        int len = in.read(buffer);
                        out.write(buffer, 0, len);
                    }
                }
                catch (Throwable throwable) {
                    var11_11 = null;
                    in.close();
                    throw throwable;
                }
                {
                    var11_11 = null;
                }
                in.close();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            out.close();
            throw throwable;
        }
        {
            Object var13_15 = null;
        }
        out.close();
    }

    private OutputStream selectOutputStream(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String acceptEncoding = request.getHeader("Accept-Encoding");
        String mimeType = response.getContentType();
        if (this.gzipEnabled && StringUtils.hasText((String)acceptEncoding) && acceptEncoding.contains("gzip") && this.compressedMimeTypes.contains(mimeType)) {
            log.debug((Object)"Enabling GZIP compression for the current response.");
            return new GZIPResponseStream(response);
        }
        return response.getOutputStream();
    }

    private void prepareResponse(HttpServletResponse response, URL[] resources, String rawResourcePath) throws IOException {
        long lastModified = -1L;
        int contentLength = 0;
        String mimeType = null;
        int i = 0;
        while (i < resources.length) {
            String currentMimeType;
            URLConnection resourceConn = resources[i].openConnection();
            if (resourceConn.getLastModified() > lastModified) {
                lastModified = resourceConn.getLastModified();
            }
            if ((currentMimeType = this.getServletContext().getMimeType(resources[i].getPath())) == null) {
                String extension = resources[i].getPath().substring(resources[i].getPath().lastIndexOf(46));
                currentMimeType = (String)this.defaultMimeTypes.get(extension);
            }
            if (mimeType == null) {
                mimeType = currentMimeType;
            } else if (!mimeType.equals(currentMimeType)) {
                throw new MalformedURLException("Combined resource path: " + rawResourcePath + " is invalid. All resources in a combined resource path must be of the same mime type.");
            }
            contentLength += resourceConn.getContentLength();
            ++i;
        }
        response.setContentType(mimeType);
        response.setHeader(HTTP_CONTENT_LENGTH_HEADER, Long.toString(contentLength));
        response.setDateHeader(HTTP_LAST_MODIFIED_HEADER, lastModified);
        this.configureCaching(response, 31556926);
    }

    protected long getLastModified(HttpServletRequest request) {
        URL[] resources;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Checking last modified of resource: " + request.getPathInfo()));
        }
        try {
            resources = this.getRequestResourceURLs(request);
        }
        catch (MalformedURLException malformedURLException) {
            return -1L;
        }
        if (resources == null || resources.length == 0) {
            return -1L;
        }
        long lastModified = -1L;
        int i = 0;
        while (i < resources.length) {
            URLConnection resourceConn;
            try {
                resourceConn = resources[i].openConnection();
            }
            catch (IOException iOException) {
                return -1L;
            }
            if (resourceConn.getLastModified() > lastModified) {
                lastModified = resourceConn.getLastModified();
            }
            ++i;
        }
        return lastModified;
    }

    private URL[] getRequestResourceURLs(HttpServletRequest request) throws MalformedURLException {
        String rawResourcePath = request.getPathInfo();
        String appendedPaths = request.getParameter("appended");
        if (StringUtils.hasText((String)appendedPaths)) {
            rawResourcePath = String.valueOf(rawResourcePath) + "," + appendedPaths;
        }
        String[] localResourcePaths = StringUtils.delimitedListToStringArray((String)rawResourcePath, (String)",");
        URL[] resources = new URL[localResourcePaths.length];
        int i = 0;
        while (i < localResourcePaths.length) {
            String localResourcePath = localResourcePaths[i];
            if (localResourcePath.matches("/?WEB-INF/.*")) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("An attempt to access a protected resource at " + localResourcePath + " was disallowed."));
                }
                return null;
            }
            URL resource = this.getServletContext().getResource(localResourcePath);
            if (resource == null) {
                String jarResourcePath = "META-INF" + localResourcePath;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Searching classpath for resource: " + jarResourcePath));
                }
                resource = ClassUtils.getDefaultClassLoader().getResource(jarResourcePath);
            }
            if (resource == null) {
                if (resources.length > 1) {
                    log.debug((Object)("Combined resource not found: " + localResourcePath));
                }
                return null;
            }
            resources[i] = resource;
            ++i;
        }
        return resources;
    }

    private void configureCaching(HttpServletResponse response, int seconds) {
        response.setDateHeader(HTTP_EXPIRES_HEADER, System.currentTimeMillis() + (long)seconds * 1000L);
        response.setHeader(HTTP_CACHE_CONTROL_HEADER, "max-age=" + seconds);
    }

    private class GZIPResponseStream
    extends ServletOutputStream {
        private ByteArrayOutputStream byteStream = null;
        private GZIPOutputStream gzipStream = null;
        private boolean closed = false;
        private HttpServletResponse response = null;
        private ServletOutputStream servletStream = null;

        public GZIPResponseStream(HttpServletResponse response) throws IOException {
            this.response = response;
            this.servletStream = response.getOutputStream();
            this.byteStream = new ByteArrayOutputStream();
            this.gzipStream = new GZIPOutputStream(this.byteStream);
        }

        public void close() throws IOException {
            if (this.closed) {
                throw new IOException("This output stream has already been closed");
            }
            this.gzipStream.finish();
            byte[] bytes = this.byteStream.toByteArray();
            this.response.setContentLength(bytes.length);
            this.response.addHeader("Content-Encoding", "gzip");
            this.servletStream.write(bytes);
            this.servletStream.flush();
            this.servletStream.close();
            this.closed = true;
        }

        public void flush() throws IOException {
            if (this.closed) {
                throw new IOException("Cannot flush a closed output stream");
            }
            this.gzipStream.flush();
        }

        public void write(int b) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed output stream");
            }
            this.gzipStream.write((byte)b);
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Cannot write to a closed output stream");
            }
            this.gzipStream.write(b, off, len);
        }

        public boolean closed() {
            return this.closed;
        }

        public void reset() {
        }
    }
}

