/*
 * Decompiled with CFR 0.152.
 */
package egovframework.brte.core.item.file.transform;

import java.util.ArrayList;
import java.util.List;
import org.springframework.batch.item.file.transform.ExtractorLineAggregator;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EgovFixedLengthLineAggregator<T>
extends ExtractorLineAggregator<T> {
    private int[] fieldRanges;
    private List<String> paddingList;
    private int paddingListSize = 100;
    private char padding = (char)32;

    public void setPadding(char padding) {
        this.padding = padding;
    }

    public void setFieldRanges(int[] fieldRanges) {
        this.fieldRanges = fieldRanges;
    }

    protected String doAggregate(Object[] fields) {
        if (this.paddingList == null) {
            this.createPaddingList();
        }
        Assert.notNull((Object)this.fieldRanges);
        return this.aggregateFixedLength(this.obtainFieldValueLength(fields), fields);
    }

    private String aggregateFixedLength(int[] fieldValueLength, Object[] fields) {
        int fieldsLength = fields.length;
        if (fieldsLength != this.fieldRanges.length) {
            Assert.state((fieldsLength == this.fieldRanges.length ? 1 : 0) != 0, (String)("The number of field's ranges: " + this.fieldRanges.length + " is must match the number of field: " + fieldsLength));
        }
        StringBuilder value = new StringBuilder();
        int k = 0;
        while (k < fieldsLength) {
            if (this.fieldRanges[k] >= fieldValueLength[k]) {
                value.append(fields[k].toString());
                if (this.fieldRanges[k] > fieldValueLength[k]) {
                    int needPaddingSize = this.fieldRanges[k] - fieldValueLength[k];
                    if (needPaddingSize <= this.paddingListSize) {
                        value.append(this.paddingList.get(needPaddingSize - 1));
                    } else {
                        int addMaxPaddingCount = needPaddingSize / this.paddingListSize;
                        int remainderPaddingSize = needPaddingSize % this.paddingListSize;
                        int i = 0;
                        while (i < addMaxPaddingCount) {
                            value.append(this.paddingList.get(this.paddingListSize - 1));
                            ++i;
                        }
                        if (remainderPaddingSize != 0) {
                            value.append(this.paddingList.get(remainderPaddingSize - 1));
                        }
                    }
                }
            } else {
                Assert.state((this.fieldRanges[k] >= fieldValueLength[k] ? 1 : 0) != 0, (String)("Supplied text: " + fields[k] + " is longer than defined length: " + this.fieldRanges[k]));
            }
            ++k;
        }
        return value.toString();
    }

    private void createPaddingList() {
        this.paddingList = new ArrayList<String>(this.paddingListSize);
        StringBuilder paddingBuilder = new StringBuilder();
        int i = 1;
        while (i <= this.paddingListSize) {
            paddingBuilder.append(this.padding);
            if (paddingBuilder.length() == i) {
                this.paddingList.add(paddingBuilder.toString());
            }
            ++i;
        }
    }

    private int[] obtainFieldValueLength(Object[] fields) {
        int[] fieldValueLength = new int[fields.length];
        int i = 0;
        while (i < fields.length) {
            fieldValueLength[i] = fields[i].toString().length();
            ++i;
        }
        return fieldValueLength;
    }
}

