/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.retry.interceptor.MethodArgumentsKeyGenerator;

public class JmsMethodArgumentsKeyGenerator
implements MethodArgumentsKeyGenerator {
    public Object getKey(Object[] items) {
        for (Object item : items) {
            if (!(item instanceof Message)) continue;
            try {
                return ((Message)item).getJMSMessageID();
            }
            catch (JMSException e) {
                throw new UnexpectedInputException("Could not extract message ID", e);
            }
        }
        if (items.length == 0) {
            throw new IllegalArgumentException("Method parameters are empty.  The key generator cannot determine a unique key.");
        }
        return items[0];
    }
}

