/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public class StringRecord
extends Record {
    public static final short sid = 519;
    private int field_1_string_length;
    private byte field_2_unicode_flag;
    private String field_3_string;

    public StringRecord() {
    }

    public StringRecord(RecordInputStream in) {
        this.field_1_string_length = in.readShort();
        this.field_2_unicode_flag = in.readByte();
        byte[] data = in.readRemainder();
        this.field_3_string = this.isUnCompressedUnicode() ? StringUtil.getFromUnicodeLE(data, 0, this.field_1_string_length) : StringUtil.getFromCompressedUnicode(data, 0, this.field_1_string_length);
    }

    public void processContinueRecord(byte[] data) {
        this.field_3_string = this.isUnCompressedUnicode() ? this.field_3_string + StringUtil.getFromUnicodeLE(data, 0, this.field_1_string_length - this.field_3_string.length()) : this.field_3_string + StringUtil.getFromCompressedUnicode(data, 0, this.field_1_string_length - this.field_3_string.length());
    }

    private int getStringByteLength() {
        return this.isUnCompressedUnicode() ? this.field_1_string_length * 2 : this.field_1_string_length;
    }

    public int getRecordSize() {
        return 7 + this.getStringByteLength();
    }

    public boolean isUnCompressedUnicode() {
        return this.field_2_unicode_flag == 1;
    }

    public int serialize(int offset, byte[] data) {
        LittleEndian.putUShort(data, 0 + offset, 519);
        LittleEndian.putUShort(data, 2 + offset, 3 + this.getStringByteLength());
        LittleEndian.putUShort(data, 4 + offset, this.field_1_string_length);
        data[6 + offset] = this.field_2_unicode_flag;
        if (this.isUnCompressedUnicode()) {
            StringUtil.putUnicodeLE(this.field_3_string, data, 7 + offset);
        } else {
            StringUtil.putCompressedUnicode(this.field_3_string, data, 7 + offset);
        }
        return this.getRecordSize();
    }

    public short getSid() {
        return 519;
    }

    public String getString() {
        return this.field_3_string;
    }

    public void setCompressedFlag(byte unicode_flag) {
        this.field_2_unicode_flag = unicode_flag;
    }

    public void setString(String string) {
        this.field_1_string_length = string.length();
        this.field_3_string = string;
        this.setCompressedFlag(StringUtil.hasMultibyte(string) ? (byte)1 : 0);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[STRING]\n");
        buffer.append("    .string            = ").append(this.field_3_string).append("\n");
        buffer.append("[/STRING]\n");
        return buffer.toString();
    }

    public Object clone() {
        StringRecord rec = new StringRecord();
        rec.field_1_string_length = this.field_1_string_length;
        rec.field_2_unicode_flag = this.field_2_unicode_flag;
        rec.field_3_string = this.field_3_string;
        return rec;
    }
}

