/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.integration.type;

import egovframework.rte.itl.integration.type.Type;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractType
implements Type {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractType.class);
    protected String id;
    protected String name;
    protected List<Class<?>> assignableClasses;

    protected AbstractType() {
    }

    protected AbstractType(String id, String name, Class<?>[] assignableClasses) {
        this(id, name, Arrays.asList(assignableClasses));
    }

    protected AbstractType(String id, String name, List<Class<?>> assignableClasses) {
        if (!StringUtils.hasText((String)id)) {
            LOGGER.error("id does not have a text (id = \"{}\")", (Object)id);
            throw new IllegalArgumentException();
        }
        if (!StringUtils.hasText((String)name)) {
            LOGGER.error("name does not have a text (name = \"{}\")", (Object)name);
            throw new IllegalArgumentException();
        }
        if (assignableClasses == null || assignableClasses.size() == 0) {
            LOGGER.error("assignableClasses is null or empty (assignableClasses = {})", assignableClasses);
            throw new IllegalArgumentException();
        }
        this.id = id;
        this.name = name;
        this.assignableClasses = assignableClasses;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        if (!StringUtils.hasText((String)id)) {
            LOGGER.error("id does not have a text (id = \"{}\")", (Object)id);
            throw new IllegalArgumentException();
        }
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!StringUtils.hasText((String)name)) {
            LOGGER.error("name does not have a text (name = \"{}\")", (Object)name);
            throw new IllegalArgumentException();
        }
        this.name = name;
    }

    public List<Class<?>> getAssignableClasses() {
        return this.assignableClasses;
    }

    public void setAssignableClasses(List<Class<?>> assignableClasses) {
        if (assignableClasses == null || assignableClasses.size() == 0) {
            LOGGER.error("assignableClasses is null or empty (assignableClasses = {})", assignableClasses);
            throw new IllegalArgumentException();
        }
        this.assignableClasses = assignableClasses;
    }

    @Override
    public boolean isAssignableFrom(Class<?> clazz) {
        if (clazz == null) {
            LOGGER.error("Argument 'clazz' is null");
            throw new IllegalArgumentException();
        }
        for (Class<?> assignableClass : this.assignableClasses) {
            if (!assignableClass.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return StringUtils.hasText((String)this.id) && StringUtils.hasText((String)this.name) && this.assignableClasses != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractType other = (AbstractType)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getClass().getName() + " {id = " + StringUtils.quote((String)this.id) + "}";
    }
}

