/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.data;

import egovframework.rte.itl.integration.metadata.ServiceDefinition;
import egovframework.rte.itl.integration.util.Validatable;
import egovframework.rte.itl.webservice.data.MappingInfo;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.util.StringUtils;

public class WebServiceClientDefinition
implements Validatable {
    private String key;
    private ServiceDefinition serviceDefinition;
    private String namespace;
    private String wsdlAddress;
    private String serviceName;
    private String portName;
    private String operationName;
    private Map<String, MappingInfo> requestMappingInfos;
    private Map<String, MappingInfo> responseMappingInfos;
    private boolean valid = false;
    private AtomicBoolean statusChanged = new AtomicBoolean(false);

    public WebServiceClientDefinition() {
    }

    public WebServiceClientDefinition(String key, ServiceDefinition serviceDefinition, String namespace, String wsdlAddress, String serviceName, String portName, String operationName, Map<String, MappingInfo> requestMappingInfos, Map<String, MappingInfo> responseMappingInfos) {
        this.key = key;
        this.serviceDefinition = serviceDefinition;
        this.namespace = namespace;
        this.wsdlAddress = wsdlAddress;
        this.serviceName = serviceName;
        this.portName = portName;
        this.operationName = operationName;
        this.requestMappingInfos = requestMappingInfos;
        this.responseMappingInfos = responseMappingInfos;
        this.statusChanged.set(true);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
        this.statusChanged.set(true);
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public void setServiceDefinition(ServiceDefinition serviceDefinition) {
        this.serviceDefinition = serviceDefinition;
        this.statusChanged.set(true);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.statusChanged.set(true);
    }

    public String getWsdlAddress() {
        return this.wsdlAddress;
    }

    public void setWsdlAddress(String wsdlAddress) {
        this.wsdlAddress = wsdlAddress;
        this.statusChanged.set(true);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
        this.statusChanged.set(true);
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
        this.statusChanged.set(true);
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
        this.statusChanged.set(true);
    }

    public Map<String, MappingInfo> getRequestMappingInfos() {
        return this.requestMappingInfos;
    }

    public void setRequestMappingInfos(Map<String, MappingInfo> requestMappingInfos) {
        this.requestMappingInfos = requestMappingInfos;
        this.statusChanged.set(true);
    }

    public Map<String, MappingInfo> getResponseMappingInfos() {
        return this.responseMappingInfos;
    }

    public void setResponseMappingInfos(Map<String, MappingInfo> responseMappingInfos) {
        this.responseMappingInfos = responseMappingInfos;
        this.statusChanged.set(true);
    }

    public boolean isValid() {
        if (this.statusChanged.getAndSet(false)) {
            boolean bl = this.valid = StringUtils.hasText((String)this.key) && this.serviceDefinition != null && StringUtils.hasText((String)this.namespace) && StringUtils.hasText((String)this.wsdlAddress) && StringUtils.hasText((String)this.serviceName) && StringUtils.hasText((String)this.portName) && StringUtils.hasText((String)this.operationName);
            if (this.serviceDefinition != null) {
                boolean bl2 = this.valid = this.valid && this.serviceDefinition.isValid();
            }
            if (this.requestMappingInfos != null) {
                for (MappingInfo mappingInfo : this.requestMappingInfos.values()) {
                    this.valid = this.valid && mappingInfo.isValid();
                }
            }
            if (this.responseMappingInfos != null) {
                for (MappingInfo mappingInfo : this.responseMappingInfos.values()) {
                    this.valid = this.valid && mappingInfo.isValid();
                }
            }
        }
        return this.valid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(" {").append("\n\tkey = ").append(StringUtils.quote((String)this.key)).append("\n\tserviceDefinition = ").append(this.serviceDefinition).append("\n\tnamespace = ").append(StringUtils.quote((String)this.namespace)).append("\n\twsdlAddress = ").append(StringUtils.quote((String)this.wsdlAddress)).append("\n\tserviceName = ").append(StringUtils.quote((String)this.serviceName)).append("\n\tportName = ").append(StringUtils.quote((String)this.portName)).append("\n\toperationName = ").append(StringUtils.quote((String)this.operationName));
        if (this.requestMappingInfos == null) {
            sb.append("\n\trequestMappingInfos = null");
        } else {
            sb.append("\n\trequestMappingInfos = {");
            for (Map.Entry<String, MappingInfo> entry : this.requestMappingInfos.entrySet()) {
                sb.append("\n\t\t<key = ").append(StringUtils.quote((String)entry.getKey())).append(", value = ").append(entry.getValue()).append(">");
            }
            sb.append("\n\t}");
        }
        if (this.responseMappingInfos == null) {
            sb.append("\n\tresponseMappingInfos = null");
        } else {
            sb.append("\n\tresponseMappingInfos = {");
            for (Map.Entry<String, MappingInfo> entry : this.responseMappingInfos.entrySet()) {
                sb.append("\n\t\t<key = ").append(StringUtils.quote((String)entry.getKey())).append(", value = ").append(entry.getValue()).append(">");
            }
            sb.append("\n\t}");
        }
        sb.append("\n}");
        return sb.toString();
    }
}

