/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.service.impl;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationMessageHeader;
import egovframework.rte.itl.webservice.EgovWebServiceMessage;
import egovframework.rte.itl.webservice.EgovWebServiceMessageHeader;
import egovframework.rte.itl.webservice.service.EgovWebServiceClassLoader;
import egovframework.rte.itl.webservice.service.EgovWebServiceClient;
import egovframework.rte.itl.webservice.service.MessageConverter;
import egovframework.rte.itl.webservice.service.ServiceEndpointInterfaceInfo;
import egovframework.rte.itl.webservice.service.ServiceParamInfo;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import javax.xml.ws.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EgovWebServiceClientImpl
implements EgovWebServiceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovWebServiceClientImpl.class);
    protected ServiceEndpointInterfaceInfo serviceEndpointInterfaceInfo;
    protected MessageConverter messageConverter;
    protected Class<?> serviceEndpointInterfaceClass;
    protected URL wsdlURL;
    protected QName serviceName;
    protected QName portName;
    protected Service service;
    protected Method method;
    protected Object client;
    protected boolean initialized = false;
    protected Object initializedLock = new Object();

    public EgovWebServiceClientImpl(EgovWebServiceClassLoader classLoader, ServiceEndpointInterfaceInfo serviceEndpointInterfaceInfo, MessageConverter messageConverter) throws ClassNotFoundException, SecurityException, NoSuchMethodException, MalformedURLException {
        LOGGER.debug("Create EgovWebServiceClient");
        if (classLoader == null) {
            LOGGER.error("Argument 'classLoader' is null");
            throw new IllegalArgumentException();
        }
        if (serviceEndpointInterfaceInfo == null) {
            LOGGER.error("Argument 'serviceEndpointInterfaeInfo' is null");
            throw new IllegalArgumentException();
        }
        if (messageConverter == null) {
            LOGGER.error("Argument 'messageConverter' is null");
            throw new IllegalArgumentException();
        }
        this.serviceEndpointInterfaceInfo = serviceEndpointInterfaceInfo;
        this.messageConverter = messageConverter;
        this.serviceEndpointInterfaceClass = classLoader.loadClass(serviceEndpointInterfaceInfo);
        LOGGER.debug("serviceEndpointInterfaceClass = {}", this.serviceEndpointInterfaceClass);
        this.wsdlURL = new URL(serviceEndpointInterfaceInfo.getWsdlAddress());
        LOGGER.debug("wsdlURL = {}", (Object)this.wsdlURL);
        this.serviceName = new QName(serviceEndpointInterfaceInfo.getNamespace(), serviceEndpointInterfaceInfo.getServiceName());
        LOGGER.debug("serviceName = {}", (Object)this.serviceName);
        this.portName = new QName(serviceEndpointInterfaceInfo.getNamespace(), serviceEndpointInterfaceInfo.getPortName());
        LOGGER.debug("portName = {}", (Object)this.portName);
        ArrayList paramClasses = new ArrayList();
        for (ServiceParamInfo paramInfo : serviceEndpointInterfaceInfo.getParamInfos()) {
            if (paramInfo.getMode().equals((Object)WebParam.Mode.OUT) || paramInfo.getMode().equals((Object)WebParam.Mode.INOUT)) {
                paramClasses.add(Holder.class);
                continue;
            }
            paramClasses.add(classLoader.loadClass(paramInfo.getType()));
        }
        this.method = this.serviceEndpointInterfaceClass.getMethod(serviceEndpointInterfaceInfo.getOperationName(), paramClasses.toArray(new Class[0]));
        LOGGER.debug("method = {}", (Object)this.method);
        LOGGER.debug("Finish to creating EgovWebServiceClient");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EgovIntegrationMessage service(EgovIntegrationMessage requestMessage) {
        LOGGER.debug("EgovWebServiceClient service (requestMesage = {})", (Object)requestMessage);
        Object object = this.initializedLock;
        synchronized (object) {
            if (!this.initialized) {
                LOGGER.debug("Initialize Client");
                try {
                    this.service = Service.create((URL)this.wsdlURL, (QName)this.serviceName);
                    this.client = this.service.getPort(this.portName, this.serviceEndpointInterfaceClass);
                    this.initialized = true;
                }
                catch (Throwable e) {
                    LOGGER.error("Cannot create web service port {}", e);
                    this.initialized = false;
                    return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(requestMessage.getHeader()){
                        {
                            this.setResultCode(EgovIntegrationMessageHeader.ResultCode.FAIL_IN_INITIALIZING);
                        }
                    });
                }
            }
        }
        LOGGER.debug("Create Request Message");
        ArrayList<Object> params = new ArrayList<Object>();
        boolean succeed = false;
        try {
            Map requestBody = requestMessage.getBody();
            for (ServiceParamInfo paramInfo : this.serviceEndpointInterfaceInfo.getParamInfos()) {
                if (paramInfo.getMode().equals((Object)WebParam.Mode.IN) || paramInfo.getMode().equals((Object)WebParam.Mode.INOUT)) {
                    Object valueObject = null;
                    if (paramInfo.getType() == EgovWebServiceMessageHeader.TYPE) {
                        LOGGER.debug("Insert Message Header");
                        LOGGER.debug("value = {}", (Object)requestMessage.getHeader());
                        valueObject = requestMessage.getHeader();
                    } else {
                        LOGGER.debug("Insert Param \"{}\"", (Object)paramInfo.getName());
                        Object typedObject = requestBody.get(paramInfo.getName());
                        valueObject = this.messageConverter.convertToValueObject(typedObject, paramInfo.getType());
                        LOGGER.debug("value = {}", valueObject);
                    }
                    if (paramInfo.getMode().equals((Object)WebParam.Mode.INOUT)) {
                        LOGGER.debug("Wrapping Holder");
                        valueObject = new Holder(valueObject);
                    }
                    params.add(valueObject);
                    continue;
                }
                params.add(new Holder());
            }
            succeed = true;
        }
        catch (Throwable e) {
            LOGGER.error("Cannot Create Request Message {}", e);
        }
        if (!succeed) {
            return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(requestMessage.getHeader()){
                {
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.FAIL_IN_CREATING_REQUEST_MESSAGE);
                }
            });
        }
        LOGGER.debug("Invoke method");
        Object[] paramArray = params.toArray();
        succeed = false;
        try {
            this.method.invoke(this.client, paramArray);
            succeed = true;
        }
        catch (Throwable e) {
            LOGGER.error("Fail to invoke method {}", e);
        }
        if (!succeed) {
            return new EgovWebServiceMessage(new EgovWebServiceMessageHeader(requestMessage.getHeader()){
                {
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.FAIL_IN_SENDING_REQUEST);
                }
            });
        }
        LOGGER.debug("Parse Response Message");
        EgovWebServiceMessageHeader responseHeader = null;
        succeed = true;
        HashMap<String, Object> responseBody = new HashMap<String, Object>();
        int i = 0;
        for (ServiceParamInfo paramInfo : this.serviceEndpointInterfaceInfo.getParamInfos()) {
            if (paramInfo.getMode().equals((Object)WebParam.Mode.OUT) || paramInfo.getMode().equals((Object)WebParam.Mode.INOUT)) {
                Object valueObject = ((Holder)paramArray[i]).value;
                if (paramInfo.getType() == EgovWebServiceMessageHeader.TYPE) {
                    responseHeader = (EgovWebServiceMessageHeader)valueObject;
                } else {
                    try {
                        Object typedObject = this.messageConverter.convertToTypedObject(valueObject, paramInfo.getType());
                        responseBody.put(paramInfo.getName(), typedObject);
                    }
                    catch (Throwable e) {
                        LOGGER.error("Cannot parse response message {}", e);
                        succeed = false;
                    }
                }
            }
            ++i;
        }
        if (succeed) {
            if (responseHeader == null) {
                responseHeader = new EgovWebServiceMessageHeader(requestMessage.getHeader());
            }
            return new EgovWebServiceMessage(responseHeader, responseBody);
        }
        if (responseHeader == null) {
            responseHeader = new EgovWebServiceMessageHeader(requestMessage.getHeader());
        }
        responseHeader.setResultCode(EgovIntegrationMessageHeader.ResultCode.FAIL_IN_PARSING_RESPONSE_MESSAGE);
        return new EgovWebServiceMessage(responseHeader, responseBody);
    }
}

