/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.itl.webservice.service.impl;

import egovframework.rte.itl.integration.EgovIntegrationMessage;
import egovframework.rte.itl.integration.EgovIntegrationMessageHeader;
import egovframework.rte.itl.integration.EgovIntegrationServiceProvider;
import egovframework.rte.itl.webservice.EgovWebServiceMessage;
import egovframework.rte.itl.webservice.EgovWebServiceMessageHeader;
import egovframework.rte.itl.webservice.service.MessageConverter;
import egovframework.rte.itl.webservice.service.ServiceBridge;
import egovframework.rte.itl.webservice.service.ServiceEndpointInfo;
import egovframework.rte.itl.webservice.service.ServiceParamInfo;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.jws.WebParam;
import javax.xml.ws.Holder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBridgeImpl
implements ServiceBridge {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceBridgeImpl.class);
    private EgovIntegrationServiceProvider provider;
    private ServiceEndpointInfo serviceEndpointInfo;
    private MessageConverter messageConverter;

    public ServiceBridgeImpl(EgovIntegrationServiceProvider provider, ServiceEndpointInfo serviceEndpointInfo, MessageConverter messageConverter) {
        if (provider == null) {
            LOGGER.error("Argument 'provider' is null");
            throw new IllegalArgumentException();
        }
        if (serviceEndpointInfo == null) {
            LOGGER.error("Argument 'serviceEndpointInfo' is null");
            throw new IllegalArgumentException();
        }
        if (messageConverter == null) {
            LOGGER.error("Argument 'messageConverter' is null");
            throw new IllegalArgumentException();
        }
        this.provider = provider;
        this.serviceEndpointInfo = serviceEndpointInfo;
        this.messageConverter = messageConverter;
    }

    @Override
    public Object doService(Map<String, Object> params) {
        LOGGER.debug("ServiceBridge's doService");
        LOGGER.debug("Parse Request Message");
        EgovWebServiceMessageHeader requestHeader = null;
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        boolean succeed = true;
        for (ServiceParamInfo paramInfo : this.serviceEndpointInfo.getParamInfos()) {
            if (!paramInfo.getMode().equals((Object)WebParam.Mode.IN) && !paramInfo.getMode().equals((Object)WebParam.Mode.INOUT)) continue;
            Object valueObject = params.get(paramInfo.getName());
            if (paramInfo.getMode().equals((Object)WebParam.Mode.INOUT)) {
                valueObject = ((Holder)valueObject).value;
            }
            if (paramInfo.getType() == EgovWebServiceMessageHeader.TYPE) {
                requestHeader = (EgovWebServiceMessageHeader)valueObject;
                continue;
            }
            try {
                Object typedObject = this.messageConverter.convertToTypedObject(valueObject, paramInfo.getType());
                requestBody.put(paramInfo.getName(), typedObject);
            }
            catch (Throwable e) {
                LOGGER.error("Cannot parse request message {}", e);
                succeed = false;
            }
        }
        final Calendar now = Calendar.getInstance();
        EgovWebServiceMessage responseMessage = null;
        if (!succeed) {
            LOGGER.error("Fail to parse request message");
            EgovWebServiceMessageHeader responseHeader = null;
            responseHeader = requestHeader == null ? new EgovWebServiceMessageHeader() : new EgovWebServiceMessageHeader(requestHeader);
            responseHeader.setRequestReceiveTime(now);
            responseHeader.setResultCode(EgovIntegrationMessageHeader.ResultCode.FAIL_IN_PARSING_REQUEST_MESSAGE);
            responseMessage = new EgovWebServiceMessage(responseHeader);
        } else if (requestHeader == null) {
            LOGGER.error("No MessageHeader in request message");
            responseMessage = new EgovWebServiceMessage(new EgovWebServiceMessageHeader(){
                {
                    this.setRequestReceiveTime(now);
                    this.setResultCode(EgovIntegrationMessageHeader.ResultCode.NO_MESSAGE_HEADER_IN_REQUEST);
                }
            });
        } else {
            requestHeader.setRequestReceiveTime(Calendar.getInstance());
            EgovWebServiceMessage requestMessage = new EgovWebServiceMessage(requestHeader, requestBody);
            responseMessage = new EgovWebServiceMessage(new EgovWebServiceMessageHeader(requestHeader));
            LOGGER.debug("Call Provider's service");
            succeed = true;
            try {
                this.provider.service((EgovIntegrationMessage)requestMessage, (EgovIntegrationMessage)responseMessage);
            }
            catch (Throwable e) {
                LOGGER.error("Fail to call provider's service {}", e);
                responseMessage = new EgovWebServiceMessage(new EgovWebServiceMessageHeader(requestHeader){
                    {
                        this.setResultCode(EgovIntegrationMessageHeader.ResultCode.FAIL_TO_CALL_SERVICE_PROVIDER);
                    }
                });
                succeed = false;
            }
        }
        LOGGER.debug("Create Response Message");
        if (succeed) {
            try {
                Map responseBody = responseMessage.getBody();
                for (ServiceParamInfo paramInfo : this.serviceEndpointInfo.getParamInfos()) {
                    if (!paramInfo.getMode().equals((Object)WebParam.Mode.OUT) && !paramInfo.getMode().equals((Object)WebParam.Mode.INOUT)) continue;
                    Object valueObject = null;
                    if (paramInfo.getType() == EgovWebServiceMessageHeader.TYPE) {
                        valueObject = responseMessage.getHeader();
                    } else {
                        Object typedObject = responseBody.get(paramInfo.getName());
                        valueObject = this.messageConverter.convertToValueObject(typedObject, paramInfo.getType());
                    }
                    ((Holder)params.get((Object)paramInfo.getName())).value = valueObject;
                }
                responseMessage.getHeader().setResponseSendTime(Calendar.getInstance());
                return null;
            }
            catch (Throwable e) {
                LOGGER.error("Cannot create response message {}", e);
                responseMessage = new EgovWebServiceMessage(new EgovWebServiceMessageHeader(requestHeader){
                    {
                        this.setResultCode(EgovIntegrationMessageHeader.ResultCode.FAIL_IN_CREATING_RESPONSE_MESSAGE);
                    }
                });
                succeed = false;
            }
        }
        ServiceParamInfo headerParamInfo = null;
        for (ServiceParamInfo paramInfo : this.serviceEndpointInfo.getParamInfos()) {
            if (paramInfo.getType() != EgovWebServiceMessageHeader.TYPE) continue;
            headerParamInfo = paramInfo;
        }
        if (headerParamInfo == null) {
            LOGGER.error("No Header ParamInfo");
        } else if (headerParamInfo.getMode().equals((Object)WebParam.Mode.IN)) {
            LOGGER.error("Header ParamInfo's Mode must be IN or INOUT");
        } else {
            ((Holder)params.get((Object)headerParamInfo.getName())).value = responseMessage.getHeader();
            responseMessage.getHeader().setResponseSendTime(Calendar.getInstance());
        }
        return null;
    }
}

