/*
 * Copyright 2008-2009 MOPAS(Ministry of Public Administration and Security).
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package egovframework.rte.ptl.mvc.tags.ui;

import java.io.IOException;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;

import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

import egovframework.rte.ptl.mvc.tags.ui.pagination.DefaultPaginationManager;
import egovframework.rte.ptl.mvc.tags.ui.pagination.PaginationInfo;
import egovframework.rte.ptl.mvc.tags.ui.pagination.PaginationManager;
import egovframework.rte.ptl.mvc.tags.ui.pagination.PaginationRenderer;

/**
 *PaginationTag.java
 *<p><b>NOTE:</b><pre> 페이징을 위한 Tag class .
 * 실제 페이징을 위한 작업은 PaginationRenderer에게 위임한다.
 * 어떤 PaginationRenderer를 사용할지는 PaginationManager에게 위임하는데, PaginationManager는 빈설정 파일의 정보와
 * 태그의 type 속성값을 비교하여 PaginationRenderer을 결정한다. 
 * </pre>
 * @author 실행환경 개발팀 함철
 * @since 2009.06.01
 * @version 1.0
 * @see
 *
 * <pre>
 * << 개정이력(Modification Information) >>
 *   
 *   수정일      수정자           수정내용
 *  -------    --------    ---------------------------
 *   2009.05.30  함철            최초 생성
 *
 * </pre>
 */
public class PaginationTag extends TagSupport {
	
	private static final long serialVersionUID = 1L;
	
	private PaginationInfo paginationInfo;
	private String type;
	private String jsFunction;
	
	public int doEndTag() throws JspException{
		
		try {
			
			JspWriter out = pageContext.getOut();
			
			PaginationManager paginationManager;
			
            // WebApplicationContext에 id 'paginationManager'로 정의된 해당 Manager를 찾는다.
            WebApplicationContext ctx = RequestContextUtils.getWebApplicationContext(pageContext.getRequest(), pageContext.getServletContext());
            
            if(ctx.containsBean("paginationManager")){
            	paginationManager = (PaginationManager) ctx.getBean("paginationManager");
            }else{
            	//bean 정의가 없다면 DefaultPaginationManager를 사용. 빈설정이 없으면 기본 적인 페이징 리스트라도 보여주기 위함.
            	paginationManager = new DefaultPaginationManager();
            }
            
            PaginationRenderer paginationRenderer = paginationManager.getRendererType(type);
            
            String contents = paginationRenderer.renderPagination(paginationInfo, jsFunction);
            
            out.println(contents);
            
            return EVAL_PAGE;
            
        } catch (IOException e) {
            throw new JspException();
        }
	}
			
	public void setJsFunction(String jsFunction) {
		this.jsFunction = jsFunction;
	}

	public void setPaginationInfo(PaginationInfo paginationInfo) {
		this.paginationInfo = paginationInfo;
	}
	
	public void setType(String type){
		this.type = type;
	}
}
