/*==============================================================*/
/* MBean Table 테이블 :19                      								  */
/*==============================================================*/

/* 1. GC 테이블 */

DROP TABLE OE2TNGCINFO;

DROP SEQUENCE SQ_OE2TNGCINFO_GC_SN;

CREATE SEQUENCE SQ_OE2TNGCINFO_GC_SN
  START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNGCINFO (
		SN NUMERIC(10 , 0) NOT NULL,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		CUR_TIME DATE,
		MNR_GC_CO NUMERIC(10 , 0),
		MNR_GC_TM NUMERIC(15 , 0),
		MJR_GC_CO NUMERIC(15 , 0),
		MJR_GC_TM NUMERIC(10 , 0)
	);
	
CREATE INDEX OE2TNGCINFOCNTNRSN ON OE2TNGCINFO(SN,CNTNR_SN,CUR_TIME);


/* 2. JBoss JDBC테이블 */

DROP TABLE OE2TNJBSSJDBCINFO;

DROP SEQUENCE SQ_OE2TNJBSSJDBCINFO_SN;

CREATE SEQUENCE SQ_OE2TNJBSSJDBCINFO_SN
  START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNJBSSJDBCINFO
(
  SN                NUMERIC(10)   CONSTRAINT OE2TNTMCTJDBCINFO_PK PRIMARY KEY NOT NULL,
  CUR_TIME          DATE,
  CNTNR_SN          NUMERIC(10)                  NOT NULL,
  JDBC_NM           VARCHAR(50 ),
  IDL_CO            NUMERIC(5),
  ALLC_CO           NUMERIC(5),
  CUR_CO            NUMERIC(5),
  MXMM_CNNC_USE_CO  NUMERIC(5),
  CNNC_CREAT_CO     NUMERIC(5),
  CNNC_DESTRC_CO    NUMERIC(5),
  AVBL_CNNC_CO      NUMERIC(5)
);

CREATE INDEX OE2TNJBSSJDBCINFOCNTNRSN ON OE2TNJBSSJDBCINFO(SN,CNTNR_SN,CUR_TIME);

/* 3. JBoss Session 테이블 */ 

DROP TABLE OE2TNJBSSSESIONINFO;

DROP SEQUENCE SQ_OE2TNJBSSSESIONINFO_SN;

CREATE SEQUENCE SQ_OE2TNJBSSSESIONINFO_SN
  START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNJBSSSESIONINFO
(
  SN                      NUMERIC(10) CONSTRAINT OE2TNJBSSSESIONINFO_PK PRIMARY KEY NOT NULL,
  CUR_TIME                DATE,
  CNTNR_SN                NUMERIC(10)            NOT NULL,
  ACTIVE_SESION           NUMERIC(5),
  SESION_CO               NUMERIC(5),
  MXMM_ACTIVE             NUMERIC(5),
  SESION_MXMM_BEING_TIME  NUMERIC(10),
  SESION_AVRG_BEING_TIME  NUMERIC(10),
  REJECT_SESION           NUMERIC(5),
  EXPRTN_SESION           NUMERIC(5),
  WAIT_QUEUE_CO           NUMERIC(5)
);

CREATE INDEX OE2TNJBSSSESIONINFOCNTNRSN ON OE2TNJBSSSESIONINFO(SN,CNTNR_SN,CUR_TIME);

/* 4. JBoss Thread 테이블	   */

DROP TABLE OE2TNJBSSTHREADINFO;

DROP SEQUENCE SQ_OE2TNJBSSTHREADINFO_SN;

CREATE SEQUENCE SQ_OE2TNJBSSTHREADINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNJBSSTHREADINFO
(
  SN                  NUMERIC(10)  CONSTRAINT OE2TNJBSSTHREADINFO_PK PRIMARY KEY  NOT NULL,
  CUR_TIME            DATE,
  CNTNR_SN            NUMERIC(10)                NOT NULL,
  CUR_THREAD_CO       NUMERIC(5),
  ALIVE_CO            NUMERIC(5),
  MXMM_THREAD_CO      NUMERIC(5),
  CUR_THREAD_BUSY_CO  NUMERIC(5)
);

CREATE INDEX OE2TNJBSSTHREADINFOCNTNRSN ON OE2TNJBSSTHREADINFO(SN,CNTNR_SN,CUR_TIME);
/* 5. JEUS JDBC 테이블	   */	  

DROP TABLE OE2TNJEUSJDBCINFO;

DROP SEQUENCE SQ_OE2TNJEUSJDBCINFO_SN;

CREATE SEQUENCE SQ_OE2TNJEUSJDBCINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNJEUSJDBCINFO
(
  SN        NUMERIC(10)    CONSTRAINT OE2TNJEUSJDBCINFO_PK PRIMARY KEY NOT NULL,
  CUR_TIME  DATE,
  CNTNR_SN  NUMERIC(10)                          NOT NULL,
  JDBC_NM   VARCHAR(50 ),
  IDL_CO    NUMERIC(5),
  CUR_CO    NUMERIC(5),
  TOT_CO    NUMERIC(5)
);

CREATE INDEX OE2TNJEUSJDBCINFOCNTNRSN ON OE2TNJEUSJDBCINFO(SN,CNTNR_SN,CUR_TIME);

/* 6. JEUS Session 테이블	   */	  

DROP TABLE OE2TNJEUSSESIONINFO;

DROP SEQUENCE SQ_OE2TNJEUSSESIONINFO_SN;

CREATE SEQUENCE SQ_OE2TNJEUSSESIONINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNJEUSSESIONINFO
(
  SN              NUMERIC(10)  CONSTRAINT OE2TNJEUSSESIONINFO_PK PRIMARY KEY NOT NULL,
  CUR_TIME        DATE,
  CNTNR_SN        NUMERIC(10)                    NOT NULL,
  CUR_THREAD_CO   NUMERIC(5),
  MXMM_THREAD_CO  NUMERIC(5),
  WAIT_QUEUE_CO   NUMERIC(5)
);


CREATE INDEX OE2TNJEUSSESIONINFOCNTNRSN ON OE2TNJEUSSESIONINFO(SN,CNTNR_SN,CUR_TIME);

/* 7. JEUS Thread 테이블	   */		  	  

DROP TABLE OE2TNJEUSTHREADINFO;

DROP SEQUENCE SQ_OE2TNJEUSTHREADINFO_SN;

CREATE SEQUENCE SQ_OE2TNJEUSTHREADINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNJEUSTHREADINFO
(
  SN                    NUMERIC(10) CONSTRAINT OE2TNJEUSTHREADINFO_PK PRIMARY KEY NOT NULL,
  CUR_TIME              DATE,
  CNTNR_SN              NUMERIC(10)              NOT NULL,
  THREAD_SIZE           NUMERIC(5),
  THREAD_CORE_SIZE      NUMERIC(5),
  THREAD_MXMM_SIZE      NUMERIC(5),
  THREAD_EXC_TIME_CO    NUMERIC(5),
  THREAD_EXC_MUMM_TIME  NUMERIC(5),
  THREAD_EXC_MXMM_TIME  NUMERIC(5),
  QUEUE_TIME            NUMERIC(10),
  QUEUE_MUMM_TIME       NUMERIC(10),
  QUEUE_MXMM_TIME       NUMERIC(10),
  QUEUE_CUR_SIZE        NUMERIC(5),
  QUEUE_MUMM_SIZE       NUMERIC(5),
  QUEUE_MXMM_SIZE       NUMERIC(5)
);

CREATE INDEX OE2TNJEUSTHREADINFOCNTNRSN ON OE2TNJEUSTHREADINFO(SN,CNTNR_SN,CUR_TIME);

/* 8. LOADED CLASS 테이블	  */

DROP TABLE OE2TNLOADCLASSINFO;

DROP SEQUENCE SQ_OE2TNLOADCLASSINFO_CLASS_SN;

CREATE SEQUENCE SQ_OE2TNLOADCLASSINFO_CLASS_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNLOADCLASSINFO
(
  SN               NUMERIC(10) CONSTRAINT OE2TNLOADCLASS_PK PRIMARY KEY  NOT NULL,
  CNTNR_SN         NUMERIC(10)                   NOT NULL,
  CUR_TIME         DATE,
  LOAD_CLASS_CO    NUMERIC(10),
  TOT_CLASS_CO     NUMERIC(10),
  UNLDNG_CLASS_CO  NUMERIC(10)
);


CREATE INDEX OE2TNLOADCLASSINFOCNTNRSN ON OE2TNLOADCLASSINFO(SN,CNTNR_SN,CUR_TIME);

/* 9. 모델 클래스 정보 */

DROP TABLE OE2TNMODELCLASSINFO;

DROP SEQUENCE SQ_OE2TNMODELCLASSINFO_SN;

CREATE SEQUENCE SQ_OE2TNMODELCLASSINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNMODELCLASSINFO
(
  SN            NUMERIC(10)    CONSTRAINT OE2TNMODELCLASS_PK PRIMARY KEY  NOT NULL,
  CNTNR_SN      NUMERIC(10)                      NOT NULL,
  CUR_TIME      DATE,
  CLASS_COLCT   CLOB,
  INTRFC_COLCT  CLOB
);


CREATE INDEX OE2TNMODELCLASSINFOCNTNRSN ON OE2TNMODELCLASSINFO(CNTNR_SN);

/* 10. MEMORY 테이블	*/	  

DROP TABLE OE2TNMORYINFO;

DROP SEQUENCE SQ_OE2TNMORYINFO_MORY_SN;

CREATE SEQUENCE SQ_OE2TNMORYINFO_MORY_SN
  START WITH 1
  MAXVALUE 9999999999
  MINVALUE 0
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNMORYINFO
(
  SN                         NUMERIC(10) CONSTRAINT OE2TNMEMORYINFO_PK PRIMARY KEY  NOT NULL,
  HPMORY_USAGE               NUMERIC(20),
  NNHPMORY_USAGE             NUMERIC(20),
  CODECACHE_PEAK_USAGE       NUMERIC(20),
  CODECACHE_USAGE            NUMERIC(20),
  EDENSPACE_PEAK_USAGE       NUMERIC(20),
  EDENSPACE_USAGE            NUMERIC(20),
  PERMGEN_PEAK_USAGE         NUMERIC(20),
  PERMGEN_USAGE              NUMERIC(20),
  SURVIVORSPACE_PEAK_USAGE   NUMERIC(20),
  SURVIVORSPACE_USAGE        NUMERIC(20),
  TENUREDGEN_PEAK_USAGE      NUMERIC(20),
  TENUREDGEN_USAGE           NUMERIC(20),
  PERMGENRO_PEAK_USAGE       NUMERIC(20),
  PERMGENRO_USAGE            NUMERIC(20),
  PERMGENRW_PEAK_USAGE       NUMERIC(20),
  PERMGENRW_USAGE            NUMERIC(20),
  APP_NAME                   VARCHAR(20 ),
  CNTNR_SN                   NUMERIC(10)         NOT NULL,
  CUR_TIME                   DATE,
  HPMORY_CONFM_USAGE         NUMERIC(20),
  HPMORY_MXMM_USAGE          NUMERIC(20),
  NNHPMORY_CONFM_USAGE       NUMERIC(20),
  NNHPMORY_MXMM_USAGE        NUMERIC(20),
  CODECACHE_CONFM_USAGE      NUMERIC(20),
  CODECACHE_MXMM_USAGE       NUMERIC(20),
  EDENSPACE_CONFM_USAGE      NUMERIC(20),
  EDENSPACE_MXMM_USAGE       NUMERIC(20),
  PERMGEN_CONFM_USAGE        NUMERIC(20),
  PERMGEN_MXMM_USAGE         NUMERIC(20),
  PERMGENRO_CONFM_USAGE      NUMERIC(20),
  PERMGENRO_MXMM_USAGE       NUMERIC(20),
  PERMGENRW_CONFM_USAGE      NUMERIC(20),
  PERMGENRW_MXMM_USAGE       NUMERIC(20),
  SURVIVORSPACE_CONFM_USAGE  NUMERIC(20),
  SURVIVORSPACE_MXMM_USAGE   NUMERIC(20),
  TENUREDGEN_CONFM_USAGE     NUMERIC(20),
  TENUREDGEN_MXMM_USAGE      NUMERIC(20),
  WAS_KND                    CHAR(2 )
);


CREATE INDEX OE2TNMORYINFOCNTNRSN ON OE2TNMORYINFO(SN,CNTNR_SN,CUR_TIME);

/* 11. OS 및 CPU 테이블 */

DROP TABLE OE2TNOSCPUINFO;

DROP SEQUENCE SQ_OE2TNOSCPUINFO_SN;

CREATE SEQUENCE SQ_OE2TNOSCPUINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNOSCPUINFO
(
  SN          NUMERIC(10)  CONSTRAINT OE2TNOSCPUINFO_PK PRIMARY KEY  NOT NULL,
  CNTNR_SN    NUMERIC(10)                        NOT NULL,
  CUR_TIME    DATE,
  ORMPM       NUMERIC(10),
  CPU_USGQTY  NUMERIC(7,2)
);


CREATE INDEX OE2TNOSCPUINFOCNTNRSN ON OE2TNOSCPUINFO(SN,CNTNR_SN,CUR_TIME);

/* 12. OS 및 런타임 테이블 */

DROP TABLE OE2TNOSRUNTIMEINFO;

DROP SEQUENCE SQ_OE2TNOSRUNTIMEINFO_SN;

CREATE SEQUENCE SQ_OE2TNOSRUNTIMEINFO_SN
  START WITH 1
  MAXVALUE 999999
  MINVALUE 1
  CYCLE
  CACHE 20;

  
CREATE TABLE OE2TNOSRUNTIMEINFO
(
  SN            NUMERIC(10)    CONSTRAINT OE2TNOSRUNTIMEINFO_SN_PK PRIMARY KEY   NOT NULL,
  CNTNR_SN      NUMERIC(10)                      NOT NULL,
  ARCHTC        VARCHAR(10 ),
  AVBL_PRCSR    NUMERIC(3),
  OPERSYSM_NM   VARCHAR(50 ),
  OPERSYSM_VER  VARCHAR(40 ),
  JVM_NM        VARCHAR(50 ),
  JVM_VENDOR    VARCHAR(50 ),
  JIT_NM        VARCHAR(50 ),
  JVM_VER       VARCHAR(100 )
);

CREATE INDEX OE2TNOSRUNTIMEINFOCNTNRSN ON OE2TNOSRUNTIMEINFO(SN,CNTNR_SN);



/* 13. SCHEDULE 테이블 */

DROP TABLE OE2TNSCHDULINFO;

DROP SEQUENCE SQ_OE2TNSCHDULINFO_SN;

CREATE SEQUENCE SQ_OE2TNSCHDULINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNSCHDULINFO
(
  SN                NUMERIC(10)   CONSTRAINT OE2TNSCHEDULEINFO_PK PRIMARY KEY NOT NULL,
  CNTNR_SN          NUMERIC(10)                  NOT NULL,
  SCHDUL_NM         VARCHAR(50 ),
  GROUP_NM          VARCHAR(60 ),
  JOB_NM            VARCHAR(50 ),
  CLASS_NM          VARCHAR(255 ),
  SCHDUL_CYCLE      VARCHAR(20 ),
  APLCTN_NM         VARCHAR(20 ),
  OPERT_CN          CLOB,
  TIME_OF_FST_EXEC  NUMERIC(5),
  TIME_OF_LST_EXEC  NUMERIC(5),
  CUR_TIME          DATE,
  TRIGR_KND         VARCHAR(20 )
);

CREATE INDEX OE2TNSCHDULINFOCNTNRSN ON OE2TNSCHDULINFO(SN,CNTNR_SN,CUR_TIME);

/* 14. TOMCAT SESSION 테이블 */

DROP TABLE OE2TNTMCTSESIONINFO;

DROP SEQUENCE SQ_OE2TNTMCTSESIONINFO_SN;

CREATE SEQUENCE SQ_OE2TNTMCTSESIONINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNTMCTSESIONINFO
(
  SN                      NUMERIC(10)   CONSTRAINT OE2TNTMCTSESIONINFO_PK PRIMARY KEY  NOT NULL,
  CUR_TIME                DATE,
  CNTNR_SN                NUMERIC(10)            NOT NULL,
  ACTIVE_SESION           NUMERIC(5),
  SESION_CO               NUMERIC(5),
  MXMM_ACTIVE             NUMERIC(5),
  SESION_MXMM_BEING_TIME  NUMERIC(10),
  SESION_AVRG_BEING_TIME  NUMERIC(10),
  REJECT_SESION           NUMERIC(5),
  EXPRTN_SESION           NUMERIC(5),
  WAIT_QUEUE_CO           NUMERIC(5)
);


CREATE INDEX OE2TNTMCTSESIONINFOCNTNRSN ON OE2TNTMCTSESIONINFO(SN,CNTNR_SN,CUR_TIME);
	  
/* 15. TOMCAT THREAD 테이블 */

DROP TABLE OE2TNTMCTTHREADINFO;

DROP SEQUENCE SQ_OE2TNTMCTTHREADINFO_SN;

CREATE SEQUENCE SQ_OE2TNTMCTTHREADINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNTMCTTHREADINFO
(
  SN                  NUMERIC(10) CONSTRAINT OE2TNTMCTTHREADINFO_PK PRIMARY KEY NOT NULL,
  CUR_TIME            DATE,
  CNTNR_SN            NUMERIC(10)                NOT NULL,
  CUR_THREAD_CO       NUMERIC(5),
  ALIVE_CO            NUMERIC(5),
  MXMM_THREAD_CO      NUMERIC(5),
  CUR_THREAD_BUSY_CO  NUMERIC(5)
);

CREATE INDEX OE2TNTMCTTHREADINFOCNTNRSN ON OE2TNTMCTTHREADINFO(SN,CNTNR_SN,CUR_TIME);

/* 16.WEBLOGIC JDBC 테이블 */

DROP TABLE OE2TNWBLGJDBCINFO;

DROP SEQUENCE SQ_OE2TNWBLGJDBCINFO_SN;

CREATE SEQUENCE SQ_OE2TNWBLGJDBCINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNWBLGJDBCINFO
(
  SN                   NUMERIC(10)   CONSTRAINT OE2TNWBLGJDBCINFO_PK PRIMARY KEY NOT NULL,
  CUR_TIME             DATE,
  CNTNR_SN             NUMERIC(10)               NOT NULL,
  JDBC_NM              VARCHAR(50 ),
  CNNC_AVRG_CO         NUMERIC(5),
  CNNC_CUR_CO          NUMERIC(5),
  CNNC_HGH_CO          NUMERIC(5),
  CNNC_DELAY_TM        NUMERIC(5),
  CNNC_TOT_CO          NUMERIC(5),
  CUR_CPCTY            NUMERIC(5),
  CUR_CPCTY_HGH_CO     NUMERIC(5),
  LKGE_CNNC_CO         NUMERIC(5),
  NO_AVBL              NUMERIC(5),
  NO_UNAVBL            INTEGER,
  STATMNT              VARCHAR(30 ),
  WAIT_CNNC_CUR_CO     NUMERIC(5),
  WAIT_CNNC_FAILR_TOT  NUMERIC(5),
  WAIT_CNNC_HGH_CO     NUMERIC(5),
  WAIT_CNNC_TOT        NUMERIC(5),
  WAIT_SECND_HGH_CO    NUMERIC(5)
);

CREATE INDEX OE2TNWBLGJDBCINFOCNTNRSN ON OE2TNWBLGJDBCINFO(SN,CNTNR_SN,CUR_TIME);

/* 17. WEBLOGIC THREAD 테이블 */

DROP TABLE OE2TNWBLGTHREADINFO;

DROP SEQUENCE SQ_OE2TNWBLGTHREADINFO_SN;

CREATE SEQUENCE SQ_OE2TNWBLGTHREADINFO_SN
   START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;
  
CREATE TABLE OE2TNWBLGTHREADINFO
(
  SN                     NUMERIC(10)  CONSTRAINT OE2TNWBLGTHREADINFO_PK PRIMARY KEY  NOT NULL,
  CUR_TIME               DATE,
  CNTNR_SN               NUMERIC(10)             NOT NULL,
  COMPET_RQEST_CO        NUMERIC(10),
  THREAD_IDL_CO          NUMERIC(10),
  THREAD_CO              NUMERIC(10),
  THREAD_TOT_CO          NUMERIC(10),
  HEALTH_STTUS           VARCHAR(50 ),
  HGH_POSSESN_THREAD_CO  NUMERIC(5),
  QUEUE_LT               NUMERIC(5),
  QUEUE_MXMM_LT          NUMERIC(5),
  STABLE_THREAD_CO       NUMERIC(5),
  THROUGHPUT             FLOAT(5)
);

CREATE INDEX OE2TNWBLGTHREADINFOCNTNRSN ON OE2TNWBLGTHREADINFO(SN,CNTNR_SN,CUR_TIME);

/* 18. JDBC JOB 테이블 */

DROP TABLE OE2TNJDBCJOBMAPNGINFO;

CREATE TABLE OE2TNJDBCJOBMAPNGINFO
(
  WAS_KND                VARCHAR(2) NOT NULL,
  JDBC_NM                VARCHAR(50) NOT NULL,
  JDBC_JOB_NM            VARCHAR(150),
  DB_AT                  CHAR(1),
  CONSTRAINT OE2TNJDBCJOBMAPNGINFO_PK PRIMARY KEY (WAS_KND,JDBC_NM)
);
	
	 
/* 19.스케줄 엄무명 정보 테이블 */


DROP TABLE OE2TNSCHDULJOBINFO;

CREATE TABLE OE2TNSCHDULJOBINFO (
		JOB_ENG_NM VARCHAR(1024)CONSTRAINT OE2TNSCHDULJOBINFO_PK PRIMARY KEY NOT NULL,
		JOB_KOREAN_NM VARCHAR(1024)
	);
	
	  
/*==============================================================*/
/* Admin Table 테이블 : 11			                                */
/*==============================================================*/

/* MBean Client 설정 테이블 삭제 */
DROP TABLE OE2TNMBCLIENT;

/* 어플리케이션 정보 테이블 삭제 */

DROP TABLE OE2TNAPLCTNINFO;

/* 컨테이너정보 테이블 삭제*/

DROP TABLE OE2TNCNTNRINFO;




/* 1.모니터링 서버 테이블 */

DROP TABLE OE2TNMNTRGSERVERINFO;

CREATE TABLE OE2TNMNTRGSERVERINFO
(
    SERVER_ID               CHAR(20) CONSTRAINT OE2TNMNTRGSERVERINFO_PK PRIMARY KEY NOT NULL,
    SERVER_NM               VARCHAR(60),
    SERVER_KND              CHAR(2),
    WAS_VER                 VARCHAR(20),
    SERVER_MNGR_ID          VARCHAR(20),
    SERVER_MNGR_PASSWORD    VARCHAR(20),
    SERVER_IP               VARCHAR(23),
    HST_NM                  VARCHAR(20),
    OPERSYSM_INFO           VARCHAR(2000),
    CPU_INFO                VARCHAR(2000),
    MORY_INFO               VARCHAR(2000),
    DISK_INFO               VARCHAR(2000),
    USE_AT                  CHAR(1)
)
	

/* 2.컨테이너정보 테이블 생성*/

CREATE TABLE OE2TNCNTNRINFO
(
    CNTNR_SN        NUMERIC(10) CONSTRAINT OE2TNCNTNRINFO_PK PRIMARY KEY NOT NULL,
    SERVER_ID       CHAR(20) CONSTRAINT OE2TNCNTNRINFO_FK1 REFERENCES OE2TNMNTRGSERVERINFO (SERVER_ID) NOT NULL,
    CNTNR_NM        VARCHAR(255),
    CNTNR_DC        VARCHAR(2000),
    RMI_PORT        VARCHAR(20),
    MBSC_CNNC_TIME  NUMERIC(10),
    CNTNR_STTUS     NUMERIC(10),
    CNNC_MXMM_CO    NUMERIC(10),
    JNDI_PORT       VARCHAR(20)
)


CREATE INDEX OE2TNCNTNRINFO_FK1
ON OE2TNCNTNRINFO
(SERVER_ID)

/* 3.어플리케이션 정보 테이블 */

CREATE TABLE OE2TNAPLCTNINFO
(
    CNTNR_SN            NUMERIC(10) CONSTRAINT OE2TNAPLCTNINFO_FK1 REFERENCES OE2TNCNTNRINFO (CNTNR_SN) NOT NULL,
    APLCTN_NM           VARCHAR(255) NOT NULL,
    APLCTN_DC           VARCHAR(2000),
    MNTRNG_AT           VARCHAR(1) FIXED,
    CALL_TRACE_AT       VARCHAR(1) FIXED,
    ERROR_MNTRNG_AT     VARCHAR(1) FIXED,
    JDBC_MNTRNG_AT      VARCHAR(1) FIXED,
    RMI_PORT            VARCHAR(20),
    SETUP_FILE_LC       VARCHAR(255),
    LWET_THRHLD         NUMERIC(10),
    USER_MNTRNG_AT      VARCHAR(1) FIXED,
    TRANSMIS_CYCLE      NUMERIC(10),
    APLCTN_KOREAN_NM    VARCHAR(1024),
    CONSTRAINT OE2TNAPLCTNINFO_PK PRIMARY KEY (CNTNR_SN,APLCTN_NM)
)


CREATE INDEX OE2TNAPLCTNINFO_FK1
ON OE2TNAPLCTNINFO
(CNTNR_SN)

/* 4.MBean Client 설정 테이블 생성 */

CREATE TABLE OE2TNMBCLIENT
(
  SN                     NUMERIC(10)  CONSTRAINT OE2TNMBCLIENT_PK PRIMARY KEY NOT NULL,
  CNTNR_SN               NUMERIC(10)             NOT NULL,
  MODEL_MNTRNG           VARCHAR(1 ),
  MODEL_MNTRNG_CYCLE     NUMERIC(10),
  SCHDUL_MNTRNG          VARCHAR(1 ),
  SCHDUL_MNTRNG_CYCLE    NUMERIC(10),
  OPERSYSM_MNTRNG        VARCHAR(1 ),
  OPERSYSM_MNTRNG_CYCLE  NUMERIC(10),
  MEMORY_MNTRNG          VARCHAR(1 ),
  MEMORY_MNTRNG_CYCLE    NUMERIC(10),
  CLASS_MNTRNG           VARCHAR(1 ),
  CLASS_MNTRNG_CYCLE     NUMERIC(10),
  THREAD_MNTRNG          VARCHAR(1 ),
  THREAD_MNTRNG_CYCLE    NUMERIC(10),
  JDBCPOOL_MNTRNG        VARCHAR(1 ),
  JDBCPOOL_MNTRNG_CYCLE  NUMERIC(10),
  SESION_MNTRNG          VARCHAR(1 ),
  SESION_MNTRNG_CYCLE    NUMERIC(10),
  START_TIME             VARCHAR(20 )      NOT NULL,
  END_TIME               VARCHAR(20 ),
  CPU_THRHLD             NUMERIC(5),
  HPMORY_THRHLD          NUMERIC(5),
  NNHPMORY_THRHLD        NUMERIC(5),
  SESION_THRHLD          NUMERIC(5),
  THREAD_THRHLD          NUMERIC(5),
  JDBC_THRHLD            NUMERIC(5)
);


CREATE INDEX OE2TNMBCLIENTCNTNRSN ON OE2TNMBCLIENT(SN, CNTNR_SN);

ALTER TABLE OE2TNMBCLIENT ADD CONSTRAINT OE2TNMBCLIENT_CNTNR_FK  FOREIGN KEY (CNTNR_SN)  REFERENCES OE2TNCNTNRINFO (CNTNR_SN) ;	

/* 5.사용자 정보 테이블 */

DROP TABLE OE2TNUSERINFO;

CREATE TABLE OE2TNUSERINFO
(
    USID                    VARCHAR(20) CONSTRAINT OE2TNUSERINFO_PK PRIMARY KEY NOT NULL,
    USER_NM                 VARCHAR(60),
    EMAIL_ADRES				VARCHAR(50),
    MBTLNUM 				VARCHAR(20),
    PASSWORD                VARCHAR(2000),
    MONITORING_USER_ROLE    VARCHAR(2) FIXED
);


/* 6.DB서비스 정보 테이블 */

DROP TABLE OE2TNDBINFO;

CREATE TABLE OE2TNDBINFO
(
    SYS_DB_ID           VARCHAR(20) CONSTRAINT OE2TNDBINFO_PK PRIMARY KEY NOT NULL,
    SERVER_NM           VARCHAR(60),
    DATA_SOURC_NM       VARCHAR(60),
    DBMS_KIND           VARCHAR(2) FIXED,
    CNNC_URL            VARCHAR(250),
    USER_ID             VARCHAR(20),
    PASSWORD            VARCHAR(250),
    CECK_SQL            VARCHAR(250),
    SVC_STTUS           VARCHAR(2) FIXED,
    ETC_DC              VARCHAR(1000),
    USE_AT              CHAR(1),
    FRST_REGISTER_PNTTM DATE DEFAULT SYSDATE,
    FRST_REGISTER_ID    VARCHAR(20),
    LAST_UPDUSR_PNTTM   DATE,
    LAST_UPDUSR_ID      VARCHAR(20)
);

/* 7.HTTP 서비스 정보 테이블 */

DROP TABLE OE2TNHTTPINFO;

CREATE TABLE OE2TNHTTPINFO
(
    SYS_HTTP_ID         VARCHAR(20) CONSTRAINT OE2TNHTTPINFO_PK PRIMARY KEY NOT NULL,
    SERVER_NM           VARCHAR(60),
    SVC_NM              VARCHAR(60),
    SVC_URL             VARCHAR(250),
    SVC_KIND            VARCHAR(2) FIXED,
    SVC_STTUS           VARCHAR(2) FIXED,
    ETC_DC              VARCHAR(1000),
    USE_AT              CHAR(1),
	EMAIL_SNDNG_AT 		CHAR(1),
	SMS_SNDNG_AT 		CHAR(1),
	EMAIL_RECPTN_AT 	CHAR(1),
	SMS_RECPTN_AT 		CHAR(1),    
    FRST_REGISTER_PNTTM DATE DEFAULT SYSDATE,
    FRST_REGISTER_ID    VARCHAR(20),
    LAST_UPDUSR_PNTTM   DATE,
    LAST_UPDUSR_ID      VARCHAR(20)
);

/* 8.프로세스정보 테이블 */

DROP TABLE OE2TNPROCSINFO;

CREATE TABLE OE2TNPROCSINFO
(
    SYS_PROCS_ID            VARCHAR(20) CONSTRAINT OE2TNPROCSINFO_PK PRIMARY KEY NOT NULL,
    SERVER_NM               VARCHAR(60),
    PROCS_NM                VARCHAR(60),
    MNTRNG_TRGET_PROCS      VARCHAR(60),
    MNTRNG_TRGET_IP         VARCHAR(60),
    MNTRNG_TRGET_PORT       VARCHAR(10) FIXED,
    MNTRNG_TRGET_CONTEXT    VARCHAR(60),
    MNTRNG_TRGET_AGT_URL    VARCHAR(250),
    SVC_STTUS               VARCHAR(2) FIXED,
    ETC_DC                  VARCHAR(1000),
    USE_AT                  CHAR(1),
    FRST_REGISTER_PNTTM     DATE DEFAULT SYSDATE,
    FRST_REGISTER_ID        VARCHAR(20),
    LAST_UPDUSR_PNTTM       DATE,
    LAST_UPDUSR_ID          VARCHAR(20)
);

/* 9.네트워크 서비스 정보 테이블 */

DROP TABLE OE2TNNTWRKINFO;

CREATE TABLE OE2TNNTWRKINFO
(
    SYS_NTWRK_ID        VARCHAR(20) NOT NULL,
    SVC_IP              VARCHAR(23) NOT NULL,
    SVC_PORT            VARCHAR(10) FIXED NOT NULL,
    SVC_NM              VARCHAR(255) NOT NULL,
    SVC_STTUS           VARCHAR(2) FIXED,
    ETC_DC              VARCHAR(1000),
    USE_AT              CHAR(1),
    FRST_REGISTER_PNTTM DATE DEFAULT SYSDATE,
    FRST_REGISTER_ID    VARCHAR(20),
    LAST_UPDUSR_PNTTM   DATE,
    LAST_UPDUSR_ID      VARCHAR(20),
    CONSTRAINT OE2TNNTWRKINFO_PK PRIMARY KEY (SYS_NTWRK_ID,SVC_IP,SVC_PORT)
);

/* 10.파일시스템 정보 테이블 */

DROP TABLE OE2TNFILESYSINFO;

CREATE TABLE OE2TNFILESYSINFO
(
    FILE_SYS_ID             VARCHAR(20) CONSTRAINT OE2TNFILESYSINFO_PK PRIMARY KEY NOT NULL,
    SERVER_NM               VARCHAR(60),
    OPERSYSM_TY 			VARCHAR(60),
    FILE_SYS_NM             VARCHAR(60),
    FILE_SYS_MANAGE_NM      VARCHAR(255),
    FILE_SYS_MG             NUMERIC(8) NOT NULL,
    FILE_SYS_THRHLD         NUMERIC(8) NOT NULL,
    FILE_SYS_USEQTY         NUMERIC(8) NOT NULL,
    FILE_SYS_STTUS          VARCHAR(15) FIXED,
    ETC_DC                  VARCHAR(1000),
    USE_AT                  CHAR(1),
    FRST_REGISTER_PNTTM     DATE DEFAULT SYSDATE,
    FRST_REGISTER_ID        VARCHAR(20),
    LAST_UPDUSR_PNTTM       DATE,
    LAST_UPDUSR_ID          VARCHAR(20),
    MNTRNG_TRGET_AGT_URL    VARCHAR(250)
);

/* 11.송수신 정보 테이블 */

DROP TABLE OE2TNTRSMRCVINFO;

CREATE TABLE OE2TNTRSMRCVINFO
(
    CNTC_ID             CHAR(8) CONSTRAINT OE2TNTRSMRCVINFO_PK PRIMARY KEY NOT NULL,
    CNTC_NM             VARCHAR(100),
    TEST_CLASS_NM       VARCHAR(1000),
    PROVD_INSTT_NM      VARCHAR(100),
    REQUST_INSTT_NM     VARCHAR(100),
    SVC_STTUS           CHAR(2),
    FRST_REGISTER_PNTTM DATE,
    FRST_REGISTER_ID    VARCHAR(20),
    LAST_UPDUSR_PNTTM   DATE,
    LAST_UPDUSR_ID      VARCHAR(20),
    USE_AT              CHAR(1)
);

/*==============================================================*/
/* Application Agent Monitoring	테이블 : 5                      */
/*==============================================================*/


/* 1.레이어정보 테이블 */

DROP TABLE OE2TNLYRINFO;

DROP SEQUENCE SQ_OE2TNLYRINFO_LYR_SN;

CREATE SEQUENCE SQ_OE2TNLYRINFO_LYR_SN
  START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNLYRINFO
(
    LYR_SN      NUMERIC(10) CONSTRAINT OE2TNLYRINFO_PK PRIMARY KEY NOT NULL,
    HST_NM      VARCHAR(20) NOT NULL,
    APLCTN_NM   VARCHAR(255) NOT NULL,
    LYR_NM      VARCHAR(50) NOT NULL,
    LYR_PD      NUMERIC(20),
    INPUT_DT    DATE
);
	
CREATE INDEX OE2TNLYRINFO_I01 ON OE2TNLYRINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 2.실행 정보 테이블 */

DROP TABLE OE2TNEXECUTINFO;

DROP SEQUENCE SQ_OE2TNEXECUTINFO_EXECUT_SN;

CREATE SEQUENCE SQ_OE2TNEXECUTINFO_EXECUT_SN
  START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNEXECUTINFO
(
    EXECUT_SN               NUMERIC(10) CONSTRAINT OE2TNEXECUTINFO_PK PRIMARY KEY NOT NULL,
    HST_NM                  VARCHAR(20) NOT NULL,
    APLCTN_NM               VARCHAR(255) NOT NULL,
    LYR_NM                  VARCHAR(50) NOT NULL,
    CLASS_NM                VARCHAR(255) NOT NULL,
    EXECUT_CN               VARCHAR(4000) NOT NULL,
    LYR_DETAIL              VARCHAR(300),
    EXECUT_CO               NUMERIC(20),
    TOT_INCLS_TIME          NUMERIC(20),
    TOT_EXCL_TIME           NUMERIC(20),
    MXMM_INCLS_TIME         NUMERIC(20),
    MUMM_INCLS_TIME         NUMERIC(20),
    MXMM_EXCL_TIME          NUMERIC(20),
    MUMM_EXCL_TIME          NUMERIC(20),
    FRST_EXECUT_TIME        NUMERIC(20),
    LAST_EXECUT_TIME        NUMERIC(20),
    INCLS_FRST_EXECUT_TIME  NUMERIC(20),
    INCLS_LAST_EXECUT_TIME  NUMERIC(20),
    EXCL_FRST_EXECUT_TIME   NUMERIC(20),
    EXCL_LAST_EXECUT_TIME   NUMERIC(20),
    INPUT_DT                DATE
);
	
CREATE INDEX OE2TNEXECUTINFO_I01 ON OE2TNEXECUTINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 3.사용정보 테이블 */

DROP TABLE OE2TNUSEINFO;

DROP SEQUENCE SQ_OE2TNUSEINFO_USE_SN;

CREATE SEQUENCE SQ_OE2TNUSEINFO_USE_SN
  START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNUSEINFO
(
    USE_SN      NUMERIC(10) CONSTRAINT OE2TNUSEINFO_PK PRIMARY KEY NOT NULL,
    HST_NM      VARCHAR(20) NOT NULL,
    APLCTN_NM   VARCHAR(255) NOT NULL,
    INPUT_DT    DATE,
    CALL_DT     DATE,
    BRWSR_TY    VARCHAR(50),
    BRWSR_VER   VARCHAR(50),
    OPERSYSM_TY VARCHAR(50),
    OPERSYSM_VER VARCHAR(40),
    SYS_INFO    VARCHAR(250),
    JOB_INFO    VARCHAR(250),
    ETC_INFO    VARCHAR(250),
    USID        VARCHAR(50),
    INADRS_INFO VARCHAR(255),
    REFRN_URL   VARCHAR(255)
)
	
CREATE INDEX OE2TNUSEINFO_I01 ON OE2TNUSEINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 4.호출정보 테이블 */

DROP TABLE OE2TNCALLINFO;

DROP SEQUENCE SQ_OE2TNCALLINFO_CALL_SN;	

CREATE SEQUENCE SQ_OE2TNCALLINFO_CALL_SN
  START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNCALLINFO
(
    CALL_SN     NUMERIC(10) CONSTRAINT OE2TNCALLINFO_PK PRIMARY KEY NOT NULL,
    HST_NM      VARCHAR(20) NOT NULL,
    APLCTN_NM   VARCHAR(255) NOT NULL,
    CALL_RELATE BLOB NOT NULL,
    INPUT_DT    DATE
)
	
CREATE INDEX OE2TNCALLINFO_I01 ON OE2TNCALLINFO (INPUT_DT, APLCTN_NM, HST_NM);	

/* 5.오류정보 테이블 */

DROP TABLE OE2TNEXCPINFO;

DROP SEQUENCE SQ_OE2TNEXCPINFO_EXCP_SN;

CREATE SEQUENCE "SQ_OE2TNEXCPINFO_EXCP_SN"
  START WITH 1
  MAXVALUE 999999999
  MINVALUE 1
  CYCLE
  CACHE 20;

CREATE TABLE OE2TNEXCPINFO
(
    EXCP_SN     NUMERIC(10) CONSTRAINT OE2TNEXCPINFO_PK PRIMARY KEY NOT NULL,
    HST_NM      VARCHAR(20) NOT NULL,
    APLCTN_NM   VARCHAR(255) NOT NULL,
    INPUT_DT    DATE,
    EXCP_DT     DATE,
    EXCP_MSSAGE VARCHAR(1000),
    EXCP_TRACE  VARCHAR(4000),
    CLASS_NM    VARCHAR(255),
    METHOD_NM   VARCHAR(255),
    SYS_INFO    VARCHAR(250) DEFAULT '',
    JOB_INFO    VARCHAR(250) DEFAULT '',
    ETC_INFO    VARCHAR(250) DEFAULT '',
    USID        VARCHAR(50) DEFAULT ''
)
	
CREATE INDEX OE2TNEXCP_I01 ON OE2TNEXCPINFO (INPUT_DT, APLCTN_NM, HST_NM);	

/*==============================================================*/
/* Common Table  테이블 : 3	                       			        */
/*==============================================================*/

/* 1.Id Gen 테이블 */

ALTER TABLE OE2TNIDS DROP CONSTRAINT OE2TNIDS_PK;

DROP TABLE OE2TNIDS;

CREATE TABLE OE2TNIDS (
		TABLE_NAME VARCHAR(16) CONSTRAINT OE2TNIDS_PK PRIMARY KEY NOT NULL,
		NEXT_ID NUMERIC(30 , 0) NOT NULL
	);
	

/* 2.공통코드 테이블 */

DROP TABLE OE2TCCMMNCODE;

CREATE TABLE OE2TCCMMNCODE
(
    CODE_ID             VARCHAR(6) FIXED CONSTRAINT OE2TCCMMNCODE_PK PRIMARY KEY NOT NULL,
    CODE_ID_NM          VARCHAR(180),
    CODE_ID_DC          VARCHAR(600),
    CL_CODE             CHAR(3),
    USE_AT              CHAR(1),
    FRST_REGISTER_PNTTM DATE,
    FRST_REGISTER_ID    VARCHAR(20),
    LAST_UPDUSR_PNTTM   DATE,
    LAST_UPDUSR_ID      VARCHAR(20)
);

/* 3.공통코드 상세테이블 */		

DROP TABLE OE2TCCMMNDETAILCODE;

CREATE TABLE OE2TCCMMNDETAILCODE
(
    CODE_ID VARCHAR(6) FIXED NOT NULL,
    CODE    VARCHAR(15) FIXED NOT NULL,
    CODE_NM VARCHAR(60),
    CODE_DC VARCHAR(200),
    USE_AT  CHAR(1),
    CONSTRAINT OE2TCCMMNDETAILCODE_PK PRIMARY KEY (CODE_ID,CODE)
);


/*==============================================================*/
/* Statistic Table  (개발중 12개 테이블)                        */
/*==============================================================*/

DROP TABLE OE2TNJDBCINFODAYSTATS;

DROP TABLE OE2TNJDBCINFOHOUSTATS;

DROP TABLE OE2TNJDBCINFOMINSTATS;

DROP TABLE OE2TNJDBCINFOMONSTATS;
  
DROP TABLE OE2TNMORYINFODAYSTATS;

DROP TABLE OE2TNMORYINFOHOUSTATS;

DROP TABLE OE2TNMORYINFOMINSTATS;

DROP TABLE OE2TNMORYINFOMONSTATS;

DROP TABLE OE2TNTHREADINFODAYSTATS;

DROP TABLE OE2TNTHREADINFOHOUSTATS;

DROP TABLE OE2TNTHREADINFOMINSTATS;

DROP TABLE OE2TNTHREADINFOMONSTATS;


CREATE TABLE OE2TNJDBCINFODAYSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   JDBC_NM              VARCHAR(50),
   AVRG_TOT_CO          NUMERIC(22),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   JDBC_THRHLD          NUMERIC(22)
);

CREATE TABLE OE2TNJDBCINFOHOUSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   JDBC_NM              VARCHAR(50),
   AVRG_TOT_CO          NUMERIC(22),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   JDBC_THRHLD          NUMERIC(22)
);

CREATE TABLE OE2TNJDBCINFOMINSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   JDBC_NM              VARCHAR(50),
   AVRG_TOT_CO          NUMERIC(22),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   JDBC_THRHLD          NUMERIC(22)
);

CREATE TABLE OE2TNJDBCINFOMONSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   JDBC_NM              VARCHAR(50),
   AVRG_TOT_CO          NUMERIC(22),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   JDBC_THRHLD          NUMERIC(22)
);

CREATE TABLE OE2TNMORYINFODAYSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   HPMORY_THRHLD        NUMERIC(22),
   MNR_GC_CO            NUMERIC(22),
   MNR_GC_TM            NUMERIC(22),
   MJR_GC_CO            NUMERIC(22),
   MJR_GC_TM            NUMERIC(22)
);

CREATE TABLE OE2TNMORYINFOHOUSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   HPMORY_THRHLD        NUMERIC(22),
   MNR_GC_CO            NUMERIC(22),
   MNR_GC_TM            NUMERIC(22),
   MJR_GC_CO            NUMERIC(22),
   MJR_GC_TM            NUMERIC(22)
);

CREATE TABLE OE2TNMORYINFOMINSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   HPMORY_THRHLD        NUMERIC(22),
   MNR_GC_CO            NUMERIC(22),
   MNR_GC_TM            NUMERIC(22),
   MJR_GC_CO            NUMERIC(22),
   MJR_GC_TM            NUMERIC(22)
);

CREATE TABLE OE2TNMORYINFOMONSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   HPMORY_THRHLD        NUMERIC(22),
   MNR_GC_CO            NUMERIC(22),
   MNR_GC_TM            NUMERIC(22),
   MJR_GC_CO            NUMERIC(22),
   MJR_GC_TM            NUMERIC(22)
);

CREATE TABLE OE2TNTHREADINFODAYSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   THREAD_THRHLD        NUMERIC(22)
);

CREATE TABLE OE2TNTHREADINFOHOUSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   THREAD_THRHLD        NUMERIC(22)
);

CREATE TABLE OE2TNTHREADINFOMINSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   THREAD_THRHLD        NUMERIC(22)
);

CREATE TABLE OE2TNTHREADINFOMONSTATS  (
   CUR_TIME             DATE,
   SERVER_KND           CHAR(2),
   SERVER_NM            VARCHAR(60),
   CNTNR_SN             NUMERIC(10),
   CNTNR_NM             VARCHAR(60),
   AVRG_CUR_CO          NUMERIC(22),
   MXMM_CUR_CO          NUMERIC(22),
   THREAD_THRHLD        NUMERIC(22)
);