/*==============================================================*/
/* MBean Table 테이블 :19                      								  */
/*==============================================================*/

/* 1. GC 테이블 */

ALTER TABLE OE2TNGCINFO DROP PRIMARY KEY;

DROP TABLE OE2TNGCINFO;

CREATE TABLE OE2TNGCINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		CUR_TIME DATETIME,
		MNR_GC_CO NUMERIC(10 , 0),
		MNR_GC_TM NUMERIC(15 , 0),
		MJR_GC_CO NUMERIC(15 , 0),
		MJR_GC_TM NUMERIC(10 , 0)
	);
	
CREATE UNIQUE INDEX OE2TNGCINFO_FK ON OE2TNGCINFO (SN,CNTNR_SN,CUR_TIME);

/* 2. JBoss JDBC테이블 */

ALTER TABLE OE2TNJBSSJDBCINFO DROP PRIMARY KEY;

DROP TABLE OE2TNJBSSJDBCINFO;


CREATE TABLE OE2TNJBSSJDBCINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		JDBC_NM VARCHAR(50),
		IDL_CO NUMERIC(5 , 0),
		ALLC_CO NUMERIC(5 , 0),
		CUR_CO NUMERIC(5 , 0),
		MXMM_CNNC_USE_CO NUMERIC(5 , 0),
		CNNC_CREAT_CO NUMERIC(5 , 0),
		CNNC_DESTRC_CO NUMERIC(5 , 0),
		AVBL_CNNC_CO NUMERIC(5 , 0)
	);

CREATE UNIQUE INDEX OE2TNJBSSJDBCINFO_FK ON OE2TNJBSSJDBCINFO (SN,CNTNR_SN,CUR_TIME);

/* 3. JBoss Session 테이블 */ 

ALTER TABLE OE2TNJBSSSESIONINFO DROP PRIMARY KEY;

DROP TABLE OE2TNJBSSSESIONINFO;
  
CREATE TABLE OE2TNJBSSSESIONINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		ACTIVE_SESION NUMERIC(5 , 0),
		SESION_CO NUMERIC(5 , 0),
		MXMM_ACTIVE NUMERIC(5 , 0),
		SESION_MXMM_BEING_TIME NUMERIC(10 , 0),
		SESION_AVRG_BEING_TIME NUMERIC(10 , 0),
		REJECT_SESION NUMERIC(5 , 0),
		EXPRTN_SESION NUMERIC(5 , 0),
		WAIT_QUEUE_CO NUMERIC(5 , 0)
	);

CREATE UNIQUE INDEX OE2TNJBSSSESIONINFO_FK ON OE2TNJBSSSESIONINFO (SN,CNTNR_SN,CUR_TIME);

/* 4. JBoss Thread 테이블	   */

ALTER TABLE OE2TNJBSSTHREADINFO DROP PRIMARY KEY;

DROP TABLE OE2TNJBSSTHREADINFO;

CREATE TABLE OE2TNJBSSTHREADINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0),
		CUR_THREAD_CO NUMERIC(5 , 0),
		ALIVE_CO NUMERIC(5 , 0),
		MXMM_THREAD_CO NUMERIC(5 , 0),
		CUR_THREAD_BUSY_CO NUMERIC(5 , 0)
	);

CREATE UNIQUE INDEX OE2TNJBSSTHREADINFO_FK ON OE2TNJBSSTHREADINFO (SN,CNTNR_SN,CUR_TIME);
/* 5. JEUS JDBC 테이블	   */	  

ALTER TABLE OE2TNJEUSJDBCINFO DROP PRIMARY KEY;

DROP TABLE OE2TNJEUSJDBCINFO;
  
CREATE TABLE OE2TNJEUSJDBCINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		JDBC_NM VARCHAR(50),
		IDL_CO NUMERIC(5 , 0),
		CUR_CO NUMERIC(5 , 0),
		TOT_CO NUMERIC(5 , 0)
	);

CREATE UNIQUE INDEX OE2TNJEUSJDBCINFO_FK ON OE2TNJEUSJDBCINFO (SN,CNTNR_SN,CUR_TIME);

/* 6. JEUS Session 테이블	   */	  

ALTER TABLE OE2TNJEUSSESIONINFO DROP PRIMARY KEY;

DROP TABLE OE2TNJEUSSESIONINFO;
  
CREATE TABLE OE2TNJEUSSESIONINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		CUR_THREAD_CO NUMERIC(5 , 0),
		MXMM_THREAD_CO NUMERIC(5 , 0),
		WAIT_QUEUE_CO NUMERIC(5 , 0)
	);

CREATE UNIQUE INDEX OE2TNJEUSSESIONINFO_FK ON OE2TNJEUSSESIONINFO (SN,CNTNR_SN,CUR_TIME);
/* 7. JEUS Thread 테이블	   */		  	  

ALTER TABLE OE2TNJEUSTHREADINFO DROP PRIMARY KEY;

DROP TABLE OE2TNJEUSTHREADINFO;
  
CREATE TABLE OE2TNJEUSTHREADINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		THREAD_SIZE NUMERIC(5 , 0),
		THREAD_CORE_SIZE NUMERIC(5 , 0),
		THREAD_MXMM_SIZE NUMERIC(5 , 0),
		THREAD_EXC_TIME_CO NUMERIC(5 , 0),
		THREAD_EXC_MUMM_TIME NUMERIC(5 , 0),
		THREAD_EXC_MXMM_TIME NUMERIC(5 , 0),
		QUEUE_TIME NUMERIC(10 , 0),
		QUEUE_MUMM_TIME NUMERIC(10 , 0),
		QUEUE_MXMM_TIME NUMERIC(10 , 0),
		QUEUE_CUR_SIZE NUMERIC(5 , 0),
		QUEUE_MUMM_SIZE NUMERIC(5 , 0),
		QUEUE_MXMM_SIZE NUMERIC(5 , 0)
	);

CREATE UNIQUE INDEX OE2TNJEUSTHREADINFO_FK ON OE2TNJEUSTHREADINFO (SN,CNTNR_SN,CUR_TIME);

/* 8. LOADED CLASS 테이블	  */

ALTER TABLE OE2TNLOADCLASSINFO DROP PRIMARY KEY;

DROP TABLE OE2TNLOADCLASSINFO;

CREATE TABLE OE2TNLOADCLASSINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		CUR_TIME DATETIME,
		LOAD_CLASS_CO NUMERIC(10 , 0),
		TOT_CLASS_CO NUMERIC(10 , 0),
		UNLDNG_CLASS_CO NUMERIC(10 , 0)
	);
	
CREATE UNIQUE INDEX OE2TNLOADCLASSINFO_FK ON OE2TNLOADCLASSINFO (SN,CNTNR_SN,CUR_TIME);

/* 9. 모델 클래스 정보 */


ALTER TABLE OE2TNMODELCLASSINFO DROP PRIMARY KEY;

DROP TABLE OE2TNMODELCLASSINFO;

CREATE TABLE OE2TNMODELCLASSINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		CUR_TIME DATETIME,
		CLASS_COLCT BLOB,
		INTRFC_COLCT BLOB
	);
	
CREATE UNIQUE INDEX OE2TNMODELCLASSINFO_FK ON OE2TNMODELCLASSINFO (SN,CNTNR_SN,CUR_TIME);

/* 10. MEMORY 테이블	*/	  

ALTER TABLE OE2TNMORYINFO DROP PRIMARY KEY;

DROP TABLE OE2TNMORYINFO;

CREATE TABLE OE2TNMORYINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		HPMORY_USAGE NUMERIC(20 , 0),
		NNHPMORY_USAGE NUMERIC(20 , 0),
		CODECACHE_PEAK_USAGE NUMERIC(20 , 0),
		CODECACHE_USAGE NUMERIC(20 , 0),
		EDENSPACE_PEAK_USAGE NUMERIC(20 , 0),
		EDENSPACE_USAGE NUMERIC(20 , 0),
		PERMGEN_PEAK_USAGE NUMERIC(20 , 0),
		PERMGEN_USAGE NUMERIC(20 , 0),
		SURVIVORSPACE_PEAK_USAGE NUMERIC(20 , 0),
		SURVIVORSPACE_USAGE NUMERIC(20 , 0),
		TENUREDGEN_PEAK_USAGE NUMERIC(20 , 0),
		TENUREDGEN_USAGE NUMERIC(20 , 0),
		PERMGENRO_PEAK_USAGE NUMERIC(20 , 0),
		PERMGENRO_USAGE NUMERIC(20 , 0),
		PERMGENRW_PEAK_USAGE NUMERIC(20 , 0),
		PERMGENRW_USAGE NUMERIC(20 , 0),
		APP_NAME VARCHAR(20),
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		CUR_TIME DATETIME,
		HPMORY_CONFM_USAGE NUMERIC(20 , 0),
		HPMORY_MXMM_USAGE NUMERIC(20 , 0),
		NNHPMORY_CONFM_USAGE NUMERIC(20 , 0),
		NNHPMORY_MXMM_USAGE NUMERIC(20 , 0),
		CODECACHE_CONFM_USAGE NUMERIC(20 , 0),
		CODECACHE_MXMM_USAGE NUMERIC(20 , 0),
		EDENSPACE_CONFM_USAGE NUMERIC(20 , 0),
		EDENSPACE_MXMM_USAGE NUMERIC(20 , 0),
		PERMGEN_CONFM_USAGE NUMERIC(20 , 0),
		PERMGEN_MXMM_USAGE NUMERIC(20 , 0),
		PERMGENRO_CONFM_USAGE NUMERIC(20 , 0),
		PERMGENRO_MXMM_USAGE NUMERIC(20 , 0),
		PERMGENRW_CONFM_USAGE NUMERIC(20 , 0),
		PERMGENRW_MXMM_USAGE NUMERIC(20 , 0),
		SURVIVORSPACE_CONFM_USAGE NUMERIC(20 , 0),
		SURVIVORSPACE_MXMM_USAGE NUMERIC(20 , 0),
		TENUREDGEN_CONFM_USAGE NUMERIC(20 , 0),
		TENUREDGEN_MXMM_USAGE NUMERIC(20 , 0),
		WAS_KND CHAR(2)
	);
	
CREATE UNIQUE INDEX OE2TNMORYINFO_FK ON OE2TNMORYINFO (SN,CNTNR_SN,CUR_TIME,WAS_KND);

/* 11. OS 및 CPU 테이블 */

ALTER TABLE OE2TNOSCPUINFO DROP CONSTRAINT OE2TNOSCPUINFO_PK;

DROP TABLE OE2TNOSCPUINFO;

CREATE TABLE OE2TNOSCPUINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		CUR_TIME DATETIME,
		ORMPM NUMERIC(10 , 0),
		CPU_USGQTY NUMERIC(7 , 2)
	);


CREATE UNIQUE INDEX OE2TNOSCPUINFO_FK ON OE2TNOSCPUINFO (SN,CNTNR_SN,CUR_TIME);

/* 12. OS 및 런타임 테이블 */

ALTER TABLE OE2TNOSRUNTIMEINFO DROP PRIMARY KEY;

DROP TABLE OE2TNOSRUNTIMEINFO;
  
CREATE TABLE OE2TNOSRUNTIMEINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		ARCHTC VARCHAR(10),
		AVBL_PRCSR NUMERIC(3 , 0),
		OPERSYSM_NM VARCHAR(50),
		OPERSYSM_VER VARCHAR(40),
		JVM_NM VARCHAR(50),
		JVM_VENDOR VARCHAR(50),
		JIT_NM VARCHAR(50),
		JVM_VER VARCHAR(100)
	);


/* 13. SCHEDULE 테이블 */

ALTER TABLE OE2TNSCHDULINFO DROP PRIMARY KEY;

DROP TABLE OE2TNSCHDULINFO;
  
CREATE TABLE OE2TNSCHDULINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		SCHDUL_NM VARCHAR(100),
		GROUP_NM VARCHAR(60),
		JOB_NM VARCHAR(50),
		CLASS_NM VARCHAR(255),
		SCHDUL_CYCLE VARCHAR(20),
		APLCTN_NM VARCHAR(20),
		OPERT_CN BLOB,
		TIME_OF_FST_EXEC NUMERIC(5 , 0),
		TIME_OF_LST_EXEC NUMERIC(5 , 0),
		CUR_TIME DATETIME,
		TRIGR_KND VARCHAR(20)
	);
	
CREATE UNIQUE INDEX OE2TNSCHDULINFO_FK ON OE2TNSCHDULINFO (SN,CNTNR_SN,CUR_TIME);

/* 14. TOMCAT SESSION 테이블 */

ALTER TABLE OE2TNTMCTSESIONINFO DROP PRIMARY KEY;

DROP TABLE OE2TNTMCTSESIONINFO;
  
CREATE TABLE OE2TNTMCTSESIONINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		ACTIVE_SESION NUMERIC(5 , 0),
		SESION_CO NUMERIC(5 , 0),
		MXMM_ACTIVE NUMERIC(5 , 0),
		SESION_MXMM_BEING_TIME NUMERIC(10 , 0),
		SESION_AVRG_BEING_TIME NUMERIC(10 , 0),
		REJECT_SESION NUMERIC(5 , 0),
		EXPRTN_SESION NUMERIC(5 , 0),
		WAIT_QUEUE_CO NUMERIC(5 , 0)
	);
	
CREATE UNIQUE INDEX OE2TNTMCTSESIONINFO_FK ON OE2TNTMCTSESIONINFO (SN,CNTNR_SN,CUR_TIME);
	  
/* 15. TOMCAT THREAD 테이블 */

ALTER TABLE OE2TNTMCTTHREADINFO DROP CONSTRAINT OE2TNTMCTTHREADINFO_PK;

DROP TABLE OE2TNTMCTTHREADINFO;
  
CREATE TABLE OE2TNTMCTTHREADINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		CUR_THREAD_CO NUMERIC(5 , 0),
		ALIVE_CO NUMERIC(5 , 0),
		MXMM_THREAD_CO NUMERIC(5 , 0),
		CUR_THREAD_BUSY_CO NUMERIC(5 , 0)
	);

/* 16.WEBLOGIC JDBC 테이블 */

ALTER TABLE OE2TNWBLGJDBCINFO DROP PRIMARY KEY;

DROP TABLE OE2TNWBLGJDBCINFO;
  
CREATE TABLE OE2TNWBLGJDBCINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		JDBC_NM VARCHAR(50),
		CNNC_AVRG_CO NUMERIC(5 , 0),
		CNNC_CUR_CO NUMERIC(5 , 0),
		CNNC_HGH_CO NUMERIC(5 , 0),
		CNNC_DELAY_TM NUMERIC(5 , 0),
		CNNC_TOT_CO NUMERIC(5 , 0),
		CUR_CPCTY NUMERIC(5 , 0),
		CUR_CPCTY_HGH_CO NUMERIC(5 , 0),
		LKGE_CNNC_CO NUMERIC(5 , 0),
		NO_AVBL NUMERIC(5 , 0),
		NO_UNAVBL NUMERIC(22 , 0),
		STATMNT VARCHAR(30),
		WAIT_CNNC_CUR_CO NUMERIC(5 , 0),
		WAIT_CNNC_FAILR_TOT NUMERIC(5 , 0),
		WAIT_CNNC_HGH_CO NUMERIC(5 , 0),
		WAIT_CNNC_TOT NUMERIC(5 , 0),
		WAIT_SECND_HGH_CO NUMERIC(5 , 0)
	);
	
CREATE UNIQUE INDEX OE2TNWBLGJDBCINFO_FK ON OE2TNWBLGJDBCINFO (SN,CNTNR_SN,CUR_TIME);

/* 17. WEBLOGIC THREAD 테이블 */

ALTER TABLE OE2TNWBLGTHREADINFO DROP PRIMARY KEY;

DROP TABLE OE2TNWBLGTHREADINFO;
  
CREATE TABLE OE2TNWBLGTHREADINFO (
		SN BIGINT AUTO_INCREMENT PRIMARY KEY,
		CUR_TIME DATETIME,
		CNTNR_SN NUMERIC(10 , 0) NOT NULL,
		COMPET_RQEST_CO NUMERIC(10 , 0),
		THREAD_IDL_CO NUMERIC(10 , 0),
		THREAD_CO NUMERIC(10 , 0),
		THREAD_TOT_CO NUMERIC(10 , 0),
		HEALTH_STTUS VARCHAR(50),
		HGH_POSSESN_THREAD_CO NUMERIC(5 , 0),
		QUEUE_LT NUMERIC(5 , 0),
		QUEUE_MXMM_LT NUMERIC(5 , 0),
		STABLE_THREAD_CO NUMERIC(5 , 0),
		THROUGHPUT FLOAT(5)
	);
	

/* 18. JDBC JOB 테이블 */

ALTER TABLE OE2TNJDBCJOBMAPNGINFO DROP PRIMARY KEY;

DROP TABLE OE2TNJDBCJOBMAPNGINFO;

CREATE TABLE OE2TNJDBCJOBMAPNGINFO (
		WAS_KND VARCHAR(2) NOT NULL,
		JDBC_NM VARCHAR(50) NOT NULL,
		JDBC_JOB_NM VARCHAR(150),
		DB_AT CHAR(1)
	);
	
ALTER TABLE OE2TNJDBCJOBMAPNGINFO ADD CONSTRAINT PRIMARY KEY (WAS_KND, JDBC_NM);		 
/* 19.스케줄 엄무명 정보 테이블 */

ALTER TABLE OE2TNSCHDULJOBINFO DROP PRIMARY KEY;

DROP TABLE OE2TNSCHDULJOBINFO;

CREATE TABLE OE2TNSCHDULJOBINFO (
		JOB_ENG_NM VARCHAR(1024) NOT NULL,
		JOB_KOREAN_NM VARCHAR(1024)
	);
	
ALTER TABLE OE2TNSCHDULJOBINFO ADD CONSTRAINT PRIMARY KEY (JOB_ENG_NM);	

/*==============================================================*/
/* Admin Table 테이블 : 11			                                */
/*==============================================================*/

/* MBean Client 설정 테이블 삭제 */
ALTER TABLE OE2TNMBCLIENT DROP FOREIGN KEY OE2TNMBCLIENT_FK1;

ALTER TABLE OE2TNMBCLIENT DROP PRIMARY KEY;

DROP INDEX OE2TNMBCLIENT_FK1 ON OE2TNMBCLIENT;

DROP TABLE OE2TNMBCLIENT;

/* 어플리케이션 정보 테이블 삭제 */
ALTER TABLE OE2TNAPLCTNINFO DROP FOREIGN KEY OE2TNAPLCTNINFO_FK1;

ALTER TABLE OE2TNAPLCTNINFO DROP PRIMARY KEY;

DROP INDEX OE2TNAPLCTNINFO_FK1 ON OE2TNAPLCTNINFO;

DROP TABLE OE2TNAPLCTNINFO;

/* 컨테이너정보 테이블 삭제*/

ALTER TABLE OE2TNCNTNRINFO DROP FOREIGN KEY OE2TNCNTNRINFO_FK1;

ALTER TABLE OE2TNCNTNRINFO DROP PRIMARY KEY;

DROP INDEX OE2TNCNTNRINFO_FK1 ON OE2TNCNTNRINFO;

DROP TABLE OE2TNCNTNRINFO;




/* 1.모니터링 서버 테이블 */

ALTER TABLE OE2TNMNTRGSERVERINFO DROP PRIMARY KEY;

DROP TABLE OE2TNMNTRGSERVERINFO;

CREATE TABLE OE2TNMNTRGSERVERINFO (
		SERVER_ID CHAR(20) NOT NULL,
		SERVER_NM VARCHAR(60),
		SERVER_KND CHAR(2),
		WAS_VER VARCHAR(20),
		SERVER_MNGR_ID VARCHAR(20),
		SERVER_MNGR_PASSWORD VARCHAR(20),
		SERVER_IP VARCHAR(23),
		HST_NM VARCHAR(20),
		OPERSYSM_INFO VARCHAR(2000),
		CPU_INFO VARCHAR(2000),
		MORY_INFO VARCHAR(2000),
		DISK_INFO VARCHAR(2000),
		USE_AT CHAR(1)
	);
	
ALTER TABLE OE2TNMNTRGSERVERINFO ADD CONSTRAINT PRIMARY KEY (SERVER_ID);

/* 2.컨테이너정보 테이블 생성*/

CREATE TABLE OE2TNCNTNRINFO (
		CNTNR_SN DECIMAL(10 , 0) NOT NULL,
		SERVER_ID CHAR(20) NOT NULL,
		CNTNR_NM VARCHAR(255),
		CNTNR_DC VARCHAR(2000),
		RMI_PORT VARCHAR(20),
		MBSC_CNNC_TIME DECIMAL(10 , 0),
		CNTNR_STTUS DECIMAL(10 , 0),
		CNNC_MXMM_CO DECIMAL(10 , 0),
		JNDI_PORT VARCHAR(20)
	);
	
ALTER TABLE OE2TNCNTNRINFO ADD CONSTRAINT PRIMARY KEY (CNTNR_SN);

ALTER TABLE OE2TNCNTNRINFO ADD CONSTRAINT OE2TNCNTNRINFO_FK1 FOREIGN KEY (SERVER_ID)
	REFERENCES OE2TNMNTRGSERVERINFO (SERVER_ID);

CREATE INDEX OE2TNCNTNRINFO_FK1 ON OE2TNCNTNRINFO (SERVER_ID);

/* 3.어플리케이션 정보 테이블 */

CREATE TABLE OE2TNAPLCTNINFO (
		CNTNR_SN DECIMAL(10 , 0) NOT NULL,
		APLCTN_NM VARCHAR(255) NOT NULL,
		APLCTN_DC VARCHAR(2000),
		MNTRNG_AT VARCHAR(1),
		CALL_TRACE_AT VARCHAR(1),
		ERROR_MNTRNG_AT VARCHAR(1),
		JDBC_MNTRNG_AT VARCHAR(1),
		RMI_PORT VARCHAR(20),
		SETUP_FILE_LC VARCHAR(255),
		LWET_THRHLD DECIMAL(10 , 0),
		USER_MNTRNG_AT VARCHAR(1),
		TRANSMIS_CYCLE DECIMAL(10 , 0),
		APLCTN_KOREAN_NM VARCHAR(1024)
	);
	
ALTER TABLE OE2TNAPLCTNINFO ADD CONSTRAINT PRIMARY KEY (CNTNR_SN, APLCTN_NM);

ALTER TABLE OE2TNAPLCTNINFO ADD CONSTRAINT OE2TNAPLCTNINFO_FK1 FOREIGN KEY (CNTNR_SN)
	REFERENCES OE2TNCNTNRINFO (CNTNR_SN);
	
CREATE INDEX OE2TNAPLCTNINFO_FK1 ON OE2TNAPLCTNINFO (CNTNR_SN);

/* 4.MBean Client 설정 테이블 생성 */

CREATE TABLE OE2TNMBCLIENT (
		SN DECIMAL(5 , 0) NOT NULL,
		CNTNR_SN DECIMAL(10 , 0) NOT NULL,
		MODEL_MNTRNG VARCHAR(1),
		MODEL_MNTRNG_CYCLE DECIMAL(10 , 0),
		SCHDUL_MNTRNG VARCHAR(1),
		SCHDUL_MNTRNG_CYCLE DECIMAL(10 , 0),
		OPERSYSM_MNTRNG VARCHAR(1),
		OPERSYSM_MNTRNG_CYCLE DECIMAL(10 , 0),
		MEMORY_MNTRNG VARCHAR(1),
		MEMORY_MNTRNG_CYCLE DECIMAL(10 , 0),
		CLASS_MNTRNG VARCHAR(1),
		CLASS_MNTRNG_CYCLE DECIMAL(10 , 0),
		THREAD_MNTRNG VARCHAR(1),
		THREAD_MNTRNG_CYCLE DECIMAL(10 , 0),
		JDBCPOOL_MNTRNG VARCHAR(1),
		JDBCPOOL_MNTRNG_CYCLE DECIMAL(10 , 0),
		SESION_MNTRNG VARCHAR(1),
		SESION_MNTRNG_CYCLE DECIMAL(10 , 0),
		START_TIME VARCHAR(20) NOT NULL,
		END_TIME VARCHAR(20),
		CPU_THRHLD DECIMAL(5 , 0),
		HPMORY_THRHLD DECIMAL(5 , 0),
		NNHPMORY_THRHLD DECIMAL(5 , 0),
		SESION_THRHLD DECIMAL(5 , 0),
		THREAD_THRHLD DECIMAL(5 , 0),
		JDBC_THRHLD DECIMAL(5 , 0)
	);
	
ALTER TABLE OE2TNMBCLIENT ADD CONSTRAINT PRIMARY KEY (SN);

ALTER TABLE OE2TNMBCLIENT ADD CONSTRAINT OE2TNMBCLIENT_FK1 FOREIGN KEY (CNTNR_SN)
	REFERENCES OE2TNCNTNRINFO (CNTNR_SN);
	
CREATE INDEX OE2TNMBCLIENT_FK1 ON OE2TNMBCLIENT (CNTNR_SN);	

/* 5.사용자 정보 테이블 */

ALTER TABLE OE2TNUSERINFO DROP PRIMARY KEY;

DROP TABLE OE2TNUSERINFO;

CREATE TABLE OE2TNUSERINFO (
		USID VARCHAR(20) NOT NULL,
		USER_NM VARCHAR(60),
		EMAIL_ADRES VARCHAR(50),
		MBTLNUM VARCHAR(20),
		PASSWORD VARCHAR(2000),
		MONITORING_USER_ROLE VARCHAR(2)
	);
	
ALTER TABLE OE2TNUSERINFO ADD CONSTRAINT OE2TNUSERINFO_PK PRIMARY KEY (USID);

/* 6.DB서비스 정보 테이블 */

ALTER TABLE OE2TNDBINFO DROP PRIMARY KEY;

DROP TABLE OE2TNDBINFO;

CREATE TABLE OE2TNDBINFO (
		SYS_DB_ID VARCHAR(20) NOT NULL,
		SERVER_NM VARCHAR(60),
		DATA_SOURC_NM VARCHAR(60),
		DBMS_KIND VARCHAR(2),
		CNNC_URL VARCHAR(250),
		USER_ID VARCHAR(20),
		PASSWORD VARCHAR(250),
		CECK_SQL VARCHAR(250),
		SVC_STTUS VARCHAR(2),
		ETC_DC VARCHAR(1000),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATETIME,
		FRST_REGISTER_ID VARCHAR(20),
		LAST_UPDUSR_PNTTM DATETIME,
		LAST_UPDUSR_ID VARCHAR(20)
	);
	
ALTER TABLE OE2TNDBINFO ADD CONSTRAINT PRIMARY KEY (SYS_DB_ID);

/* 7.HTTP 서비스 정보 테이블 */

ALTER TABLE OE2TNHTTPINFO DROP PRIMARY KEY;

DROP TABLE OE2TNHTTPINFO;

CREATE TABLE OE2TNHTTPINFO (
		SYS_HTTP_ID VARCHAR(20) NOT NULL,
		SERVER_NM VARCHAR(60),
		SVC_NM VARCHAR(60),
		SVC_URL VARCHAR(250),
		SVC_KIND VARCHAR(2),
		SVC_STTUS VARCHAR(2),
		ETC_DC VARCHAR(1000),
		USE_AT CHAR(1),
		EMAIL_SNDNG_AT CHAR(1),
		SMS_SNDNG_AT CHAR(1),
		EMAIL_RECPTN_AT CHAR(1),
		SMS_RECPTN_AT CHAR(1),		
		FRST_REGISTER_PNTTM DATETIME,
		FRST_REGISTER_ID VARCHAR(20),
		LAST_UPDUSR_PNTTM DATETIME,
		LAST_UPDUSR_ID VARCHAR(20)
	);
	
ALTER TABLE OE2TNHTTPINFO ADD CONSTRAINT PRIMARY KEY (SYS_HTTP_ID);

/* 8.프로세스정보 테이블 */

ALTER TABLE OE2TNPROCSINFO DROP PRIMARY KEY;

DROP TABLE OE2TNPROCSINFO;

CREATE TABLE OE2TNPROCSINFO (
		SYS_PROCS_ID VARCHAR(20) NOT NULL,
		SERVER_NM VARCHAR(60),
		PROCS_NM VARCHAR(60),
		MNTRNG_TRGET_PROCS VARCHAR(60),
		MNTRNG_TRGET_IP VARCHAR(60),
		MNTRNG_TRGET_PORT VARCHAR(10),
		MNTRNG_TRGET_CONTEXT VARCHAR(60),
		MNTRNG_TRGET_AGT_URL VARCHAR(250),
		SVC_STTUS VARCHAR(2),
		ETC_DC VARCHAR(1000),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATETIME,
		FRST_REGISTER_ID VARCHAR(20),
		LAST_UPDUSR_PNTTM DATETIME,
		LAST_UPDUSR_ID VARCHAR(20)
	);		
	
ALTER TABLE OE2TNPROCSINFO ADD CONSTRAINT PRIMARY KEY (SYS_PROCS_ID);	

/* 9.네트워크 서비스 정보 테이블 */

ALTER TABLE OE2TNNTWRKINFO DROP PRIMARY KEY;

DROP TABLE OE2TNNTWRKINFO;

CREATE TABLE OE2TNNTWRKINFO (
		SYS_NTWRK_ID VARCHAR(20) NOT NULL,
		SVC_IP VARCHAR(23) NOT NULL,
		SVC_PORT VARCHAR(10) NOT NULL,
		SVC_NM VARCHAR(255) NOT NULL,
		SVC_STTUS VARCHAR(2),
		ETC_DC VARCHAR(1000),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATETIME,
		FRST_REGISTER_ID VARCHAR(20),
		LAST_UPDUSR_PNTTM DATETIME,
		LAST_UPDUSR_ID VARCHAR(20)
	);
	
ALTER TABLE OE2TNNTWRKINFO ADD CONSTRAINT PRIMARY KEY (SYS_NTWRK_ID, SVC_IP, SVC_PORT);

/* 10.파일시스템 정보 테이블 */

ALTER TABLE OE2TNFILESYSINFO DROP PRIMARY KEY;

DROP TABLE OE2TNFILESYSINFO;

CREATE TABLE OE2TNFILESYSINFO (
		FILE_SYS_ID VARCHAR(20) NOT NULL,
		SERVER_NM VARCHAR(60),
		OPERSYSM_TY VARCHAR(60),
		FILE_SYS_NM VARCHAR(60),
		FILE_SYS_MANAGE_NM VARCHAR(255),
		FILE_SYS_MG DECIMAL(8 , 0) NOT NULL,
		FILE_SYS_THRHLD DECIMAL(8 , 0) NOT NULL,
		FILE_SYS_USEQTY DECIMAL(8 , 0) NOT NULL,
		FILE_SYS_STTUS VARCHAR(15),
		ETC_DC VARCHAR(1000),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATETIME,
		FRST_REGISTER_ID VARCHAR(20),
		LAST_UPDUSR_PNTTM DATETIME,
		LAST_UPDUSR_ID VARCHAR(20),
		MNTRNG_TRGET_AGT_URL VARCHAR(250)
	);
	
ALTER TABLE OE2TNFILESYSINFO ADD CONSTRAINT PRIMARY KEY (FILE_SYS_ID);

/* 11.송수신 정보 테이블 */

ALTER TABLE OE2TNTRSMRCVINFO DROP PRIMARY KEY;

DROP TABLE OE2TNTRSMRCVINFO;

CREATE TABLE OE2TNTRSMRCVINFO (
		CNTC_ID CHAR(8) NOT NULL,
		CNTC_NM VARCHAR(100),
		TEST_CLASS_NM VARCHAR(1000),
		PROVD_INSTT_NM VARCHAR(100),
		REQUST_INSTT_NM VARCHAR(100),
		SVC_STTUS CHAR(2),
		FRST_REGISTER_PNTTM DATETIME,
		FRST_REGISTER_ID VARCHAR(20),
		LAST_UPDUSR_PNTTM DATETIME,
		LAST_UPDUSR_ID VARCHAR(20),
		USE_AT CHAR(1)
	);
	
ALTER TABLE OE2TNTRSMRCVINFO ADD CONSTRAINT PRIMARY KEY (CNTC_ID);

/*==============================================================*/
/* Application Agent Monitoring	테이블 : 5                      */
/*==============================================================*/


/* 1.레이어정보 테이블 */

ALTER TABLE OE2TNLYRINFO DROP PRIMARY KEY;

DROP TABLE OE2TNLYRINFO;

CREATE TABLE OE2TNLYRINFO (
  LYR_SN INT(10) unsigned NOT NULL AUTO_INCREMENT,
  HST_NM VARCHAR(20) NOT NULL,
  APLCTN_NM VARCHAR(255) NOT NULL,
  LYR_NM VARCHAR(50) NOT NULL,
  LYR_PD BIGINT(20) DEFAULT NULL,
  INPUT_DT DATETIME NOT NULL,
  PRIMARY KEY (LYR_SN)
);

CREATE INDEX OE2TNLYRINFO_I01 ON OE2TNLYRINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 2.실행 정보 테이블 */

ALTER TABLE OE2TNEXECUTINFO DROP PRIMARY KEY;	

DROP TABLE OE2TNEXECUTINFO;

CREATE TABLE `OE2TNEXECUTINFO` (
  EXECUT_SN INT(10) unsigned NOT NULL AUTO_INCREMENT,
  HST_NM VARCHAR(20) NOT NULL,
  APLCTN_NM VARCHAR(255) NOT NULL,
  LYR_NM VARCHAR(50) NOT NULL,
  CLASS_NM VARCHAR(255) NOT NULL,
  EXECUT_CN VARCHAR(4000) NOT NULL,
  LYR_DETAIL VARCHAR(300) DEFAULT NULL,
  EXECUT_CO BIGINT(20) DEFAULT NULL,
  TOT_INCLS_TIME BIGINT(20) DEFAULT NULL,
  TOT_EXCL_TIME BIGINT(20) DEFAULT NULL,
  MXMM_INCLS_TIME BIGINT(20) DEFAULT NULL,
  MUMM_INCLS_TIME BIGINT(20) DEFAULT NULL,
  MXMM_EXCL_TIME BIGINT(20) DEFAULT NULL,
  MUMM_EXCL_TIME BIGINT(20) DEFAULT NULL,
  FRST_EXECUT_TIME BIGINT(20) DEFAULT NULL,
  LAST_EXECUT_TIME BIGINT(20) DEFAULT NULL,
  INCLS_FRST_EXECUT_TIME BIGINT(20) DEFAULT NULL,
  INCLS_LAST_EXECUT_TIME BIGINT(20) DEFAULT NULL,
  EXCL_FRST_EXECUT_TIME BIGINT(20) DEFAULT NULL,
  EXCL_LAST_EXECUT_TIME BIGINT(20) DEFAULT NULL,
  INPUT_DT DATETIME NOT NULL,
  PRIMARY KEY (EXECUT_SN)
);
	
CREATE INDEX OE2TNEXECUTINFO_I01 ON OE2TNEXECUTINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 3.사용정보 테이블 */

ALTER TABLE OE2TNUSEINFO DROP PRIMARY KEY;

DROP TABLE OE2TNUSEINFO;

CREATE TABLE OE2TNUSEINFO (
  USE_SN INT(10) unsigned NOT NULL AUTO_INCREMENT,
  HST_NM VARCHAR(20) NOT NULL,
  APLCTN_NM VARCHAR(255) NOT NULL,
  INPUT_DT DATETIME NOT NULL,
  CALL_DT DATETIME DEFAULT NULL,
  BRWSR_TY VARCHAR(50) DEFAULT NULL,
  BRWSR_VER VARCHAR(50) DEFAULT NULL,
  OPERSYSM_TY VARCHAR(50) DEFAULT NULL,
  OPERSYSM_VER VARCHAR(40) DEFAULT NULL,
  SYS_INFO VARCHAR(250) DEFAULT NULL,
  JOB_INFO VARCHAR(250) DEFAULT NULL,
  ETC_INFO VARCHAR(250) DEFAULT NULL,
  USID VARCHAR(50) DEFAULT NULL,
  INADRS_INFO VARCHAR(255) DEFAULT NULL,
  REFRN_URL VARCHAR(1024) DEFAULT NULL,
  PRIMARY KEY (USE_SN)
) 
	
CREATE INDEX OE2TNUSEINFO_I01 ON OE2TNUSEINFO (INPUT_DT, APLCTN_NM, HST_NM);

/* 4.호출정보 테이블 */

ALTER TABLE OE2TNCALLINFO DROP PRIMARY KEY;

DROP TABLE OE2TNCALLINFO;


CREATE TABLE OE2TNCALLINFO (
  CALL_SN INT(10) unsigned NOT NULL AUTO_INCREMENT,
  HST_NM VARCHAR(20) NOT NULL,
  APLCTN_NM VARCHAR(255) NOT NULL,
  CALL_RELATE BLOB NOT NULL,
  INPUT_DT DATETIME NOT NULL,
  PRIMARY KEY (CALL_SN)
) 
	
CREATE INDEX OE2TNCALLINFO_I01 ON OE2TNCALLINFO (INPUT_DT, APLCTN_NM, HST_NM);	

/* 5.오류정보 테이블 */

ALTER TABLE OE2TNEXCPINFO DROP PRIMARY KEY;

DROP TABLE OE2TNEXCPINFO;

CREATE TABLE OE2TNEXCPINFO (
  EXCP_SN INT(10) unsigned NOT NULL AUTO_INCREMENT,
  HST_NM VARCHAR(20) NOT NULL,
  APLCTN_NM VARCHAR(255) NOT NULL,
  INPUT_DT DATETIME NOT NULL,
  EXCP_DT DATETIME DEFAULT NULL,
  EXCP_MSSAGE VARCHAR(1000) DEFAULT NULL,
  EXCP_TRACE text CHARACTER SET UTF8,
  CLASS_NM VARCHAR(255) DEFAULT NULL,
  METHOD_NM VARCHAR(255) DEFAULT NULL,
  SYS_INFO VARCHAR(250) DEFAULT NULL,
  JOB_INFO VARCHAR(250) DEFAULT NULL,
  ETC_INFO VARCHAR(250) DEFAULT NULL,
  USID VARCHAR(50) DEFAULT NULL,
  PRIMARY KEY (EXCP_SN)
)

CREATE INDEX OE2TNEXCP_I01 ON OE2TNEXCPINFO (INPUT_DT, APLCTN_NM, HST_NM);

/*==============================================================*/
/* Common Table  테이블 : 3	                       			        */
/*==============================================================*/

/* 1.Id Gen 테이블 */

ALTER TABLE OE2TNIDS DROP PRIMARY KEY;

DROP TABLE OE2TNIDS;

CREATE TABLE OE2TNIDS (
		TABLE_NAME VARCHAR(16) NOT NULL,
		NEXT_ID DECIMAL(30 , 0) NOT NULL
	);
	
ALTER TABLE OE2TNIDS ADD CONSTRAINT PRIMARY KEY (TABLE_NAME);

/* 2.공통코드 테이블 */

ALTER TABLE OE2TCCMMNCODE DROP PRIMARY KEY;

DROP TABLE OE2TCCMMNCODE;

CREATE TABLE OE2TCCMMNCODE (
		CODE_ID VARCHAR(6) NOT NULL,
		CODE_ID_NM VARCHAR(180),
		CODE_ID_DC VARCHAR(600),
		CL_CODE CHAR(3),
		USE_AT CHAR(1),
		FRST_REGISTER_PNTTM DATETIME,
		FRST_REGISTER_ID VARCHAR(20),
		LAST_UPDUSR_PNTTM DATETIME,
		LAST_UPDUSR_ID VARCHAR(20)
	);
	
ALTER TABLE OE2TCCMMNCODE ADD CONSTRAINT PRIMARY KEY (CODE_ID);

/* 3.공통코드 상세테이블 */		

ALTER TABLE OE2TCCMMNDETAILCODE DROP PRIMARY KEY;

DROP TABLE OE2TCCMMNDETAILCODE;

CREATE TABLE OE2TCCMMNDETAILCODE (
		CODE_ID VARCHAR(6) NOT NULL,
		CODE VARCHAR(15) NOT NULL,
		CODE_NM VARCHAR(60),
		CODE_DC VARCHAR(200),
		USE_AT CHAR(1)
	);
	
ALTER TABLE OE2TCCMMNDETAILCODE ADD CONSTRAINT PRIMARY KEY (CODE_ID, CODE);


/*==============================================================*/
/* Statistic Table  (개발중 12개 테이블)                        */
/*==============================================================*/

DROP TABLE OE2TNJDBCINFODAYSTATS;

DROP TABLE OE2TNJDBCINFOHOUSTATS;

DROP TABLE OE2TNJDBCINFOMINSTATS;

DROP TABLE OE2TNJDBCINFOMONSTATS;
  
DROP TABLE OE2TNMORYINFODAYSTATS;

DROP TABLE OE2TNMORYINFOHOUSTATS;

DROP TABLE OE2TNMORYINFOMINSTATS;

DROP TABLE OE2TNMORYINFOMONSTATS;

DROP TABLE OE2TNTHREADINFODAYSTATS;

DROP TABLE OE2TNTHREADINFOHOUSTATS;

DROP TABLE OE2TNTHREADINFOMINSTATS;

DROP TABLE OE2TNTHREADINFOMONSTATS;



CREATE TABLE OE2TNJDBCINFODAYSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		JDBC_NM VARCHAR(50),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		JDBC_THRHLD DECIMAL(22 , 0)
	);
	
CREATE TABLE OE2TNJDBCINFOHOUSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		JDBC_NM VARCHAR(50),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		JDBC_THRHLD DECIMAL(22 , 0)
	);	
	
CREATE TABLE OE2TNJDBCINFOMINSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		JDBC_NM VARCHAR(50),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		JDBC_THRHLD DECIMAL(22 , 0)
	);	

CREATE TABLE OE2TNJDBCINFOMONSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		JDBC_NM VARCHAR(50),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		JDBC_THRHLD DECIMAL(22 , 0)
	);
	
CREATE TABLE OE2TNMORYINFODAYSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		HPMORY_THRHLD DECIMAL(22 , 0),
		MNR_GC_CO DECIMAL(22 , 0),
		MNR_GC_TM DECIMAL(22 , 0),
		MJR_GC_CO DECIMAL(22 , 0),
		MJR_GC_TM DECIMAL(22 , 0)
	);
	
CREATE TABLE OE2TNMORYINFOHOUSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		HPMORY_THRHLD DECIMAL(22 , 0),
		MNR_GC_CO DECIMAL(22 , 0),
		MNR_GC_TM DECIMAL(22 , 0),
		MJR_GC_CO DECIMAL(22 , 0),
		MJR_GC_TM DECIMAL(22 , 0)
	);	

CREATE TABLE OE2TNMORYINFOMINSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		HPMORY_THRHLD DECIMAL(22 , 0),
		MNR_GC_CO DECIMAL(22 , 0),
		MNR_GC_TM DECIMAL(22 , 0),
		MJR_GC_CO DECIMAL(22 , 0),
		MJR_GC_TM DECIMAL(22 , 0)
	);

CREATE TABLE OE2TNMORYINFOMONSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		HPMORY_THRHLD DECIMAL(22 , 0),
		MNR_GC_CO DECIMAL(22 , 0),
		MNR_GC_TM DECIMAL(22 , 0),
		MJR_GC_CO DECIMAL(22 , 0),
		MJR_GC_TM DECIMAL(22 , 0)
	);
	
CREATE TABLE OE2TNTHREADINFODAYSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		THREAD_THRHLD DECIMAL(22 , 0)
	);	

CREATE TABLE OE2TNTHREADINFOHOUSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		THREAD_THRHLD DECIMAL(22 , 0)
	);

CREATE TABLE OE2TNTHREADINFOMINSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		THREAD_THRHLD DECIMAL(22 , 0)
	);

CREATE TABLE OE2TNTHREADINFOMONSTATS (
		CUR_TIME DATETIME,
		SERVER_KND CHAR(2),
		SERVER_NM VARCHAR(60),
		CNTNR_SN DECIMAL(10 , 0),
		CNTNR_NM VARCHAR(60),
		AVRG_CUR_CO DECIMAL(22 , 0),
		MXMM_CUR_CO DECIMAL(22 , 0),
		THREAD_THRHLD DECIMAL(22 , 0)
	);	
