import jeus.management.RemoteMBeanServerFactory;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;


public class MonitoringClient {
    public static void main(String[] args) throws Exception {

        
        // Step 1. Setting Environments
        String hostname = args[0];
        String username = args[1];
        String password = args[2];

        Hashtable env = new Hashtable();

        env.put(Context.INITIAL_CONTEXT_FACTORY, "jeus.jndi.JNSContextFactory");
        env.put(Context.PROVIDER_URL, hostname);
        env.put(Context.SECURITY_PRINCIPAL, username);
        env.put(Context.SECURITY_CREDENTIALS, password);

	InitialContext ic = new InitialContext(env); 
        MBeanServerConnection mbeanServer = RemoteMBeanServerFactory.getMBeanServer(env);
        
        
        Set jvmMBeans = mbeanServer.queryMBeans(null, null);

        System.out.println("***************************************************");
        System.out.println("mbeanServer" + mbeanServer);
        System.out.println("***************************************************");
        for (Iterator i = jvmMBeans.iterator(); i.hasNext();) {
              ObjectName objName = ((ObjectInstance) i.next()).getObjectName();
              System.out.println("[Jeus MBean] " + objName); 
        }
    }
}
