/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.db.DBHelper;
import org.apache.log4j.db.DBReceiver;
import org.apache.log4j.scheduler.Job;
import org.apache.log4j.spi.ComponentBase;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

class DBReceiverJob
extends ComponentBase
implements Job {
    long lastId = 0L;
    DBReceiver parentDBReceiver;

    DBReceiverJob(DBReceiver parent) {
        this.parentDBReceiver = parent;
    }

    public void execute() {
        this.getLogger().debug("DBReceiverJob.execute() called");
        Connection connection = null;
        try {
            try {
                LoggerRepository loggerRepository = this.parentDBReceiver.getLoggerRepository();
                connection = this.parentDBReceiver.connectionSource.getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT ");
                sql.append("sequence_number, ");
                sql.append("timestamp, ");
                sql.append("rendered_message, ");
                sql.append("logger_name, ");
                sql.append("level_string, ");
                sql.append("ndc, ");
                sql.append("thread_name, ");
                sql.append("reference_flag, ");
                sql.append("caller_filename, ");
                sql.append("caller_class, ");
                sql.append("caller_method, ");
                sql.append("caller_line, ");
                sql.append("event_id ");
                sql.append("FROM logging_event ");
                sql.append(" WHERE event_id > " + this.lastId);
                sql.append(" ORDER BY event_id ASC");
                Statement statement = connection.createStatement();
                ResultSet rs = statement.executeQuery(sql.toString());
                while (rs.next()) {
                    long id;
                    LoggingEvent event = new LoggingEvent();
                    event.setSequenceNumber(rs.getLong(1));
                    event.setTimeStamp(rs.getLong(2));
                    event.setRenderedMessage(rs.getString(3));
                    event.setLoggerName(rs.getString(4));
                    String levelStr = rs.getString(5);
                    Level level = Level.toLevel(levelStr);
                    event.setLevel(level);
                    event.setNDC(rs.getString(6));
                    event.setThreadName(rs.getString(7));
                    short mask = rs.getShort(8);
                    String fileName = rs.getString(9);
                    String className = rs.getString(10);
                    String methodName = rs.getString(11);
                    String lineNumber = rs.getString(12).trim();
                    if (fileName.equals("?")) {
                        event.setLocationInformation(LocationInfo.NA_LOCATION_INFO);
                    } else {
                        event.setLocationInformation(new LocationInfo(fileName, className, methodName, lineNumber));
                    }
                    this.lastId = id = rs.getLong(13);
                    event.setProperty("log4jid", Long.toString(id));
                    if ((mask & DBHelper.PROPERTIES_EXIST) != 0) {
                        this.getProperties(connection, id, event);
                    }
                    if ((mask & DBHelper.EXCEPTION_EXISTS) != 0) {
                        this.getException(connection, id, event);
                    }
                    if (this.parentDBReceiver.isPaused()) continue;
                    this.parentDBReceiver.doPost(event);
                }
                statement.close();
                statement = null;
            }
            catch (SQLException sqle) {
                this.getLogger().error((Object)"Problem receiving events", sqle);
                Object var18_16 = null;
                this.closeConnection(connection);
            }
            Object var18_15 = null;
            this.closeConnection(connection);
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            this.closeConnection(connection);
            throw throwable;
        }
    }

    void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getProperties(Connection connection, long id, LoggingEvent event) throws SQLException {
        String sql = "SELECT mapped_key, mapped_value FROM logging_event_property WHERE event_id='" + id + "'";
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            while (rs.next()) {
                String key = rs.getString(1);
                String value = rs.getString(2);
                event.setProperty(key, value);
            }
            Object var11_9 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getException(Connection connection, long id, LoggingEvent event) throws SQLException {
        String sql = "SELECT trace_line FROM logging_event_exception where event_id='" + id + "' ORDER by i ASC";
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            Vector<String> v = new Vector<String>();
            while (rs.next()) {
                v.add(rs.getString(1));
            }
            int len = v.size();
            String[] strRep = new String[len];
            int i = 0;
            while (i < len) {
                strRep[i] = (String)v.get(i);
                ++i;
            }
            event.setThrowableInformation(new ThrowableInformation(strRep));
            Object var13_11 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            if (statement == null) throw throwable;
            statement.close();
            throw throwable;
        }
        statement.close();
    }
}

