/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import java.util.List;
import org.apache.log4j.config.ConfiguratorBase;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.LoggerRepository;
import org.xml.sax.Attributes;

public class ConfigurationAction
extends Action {
    static final String INTERNAL_DEBUG_ATTR = "debug";
    boolean attachment = false;

    public void begin(ExecutionContext ec, String name, Attributes attributes) {
        String debugAttrib = attributes.getValue(INTERNAL_DEBUG_ATTR);
        if (debugAttrib == null || debugAttrib.equals("") || debugAttrib.equals("false") || debugAttrib.equals("null")) {
            this.getLogger().debug("Ignoring debug attribute.");
        } else {
            LoggerRepository repository = (LoggerRepository)ec.getObject(0);
            ConfiguratorBase.attachTemporaryConsoleAppender(repository);
            this.getLogger().debug("Starting internal logs on console.");
            this.attachment = true;
        }
    }

    public void end(ExecutionContext ec, String name) {
        if (this.attachment) {
            this.getLogger().debug("Will stop writing internal logs on console.");
            LoggerRepository repository = (LoggerRepository)ec.getObject(0);
            List errorList = ec.getErrorList();
            ConfiguratorBase.detachTemporaryConsoleAppender(repository, errorList);
        }
    }
}

